package com.elitesland.yst.production.fin.application.service.arorder;

import com.elitesland.yst.production.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.yst.production.fin.domain.param.arorder.ArOrderPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.arorder
 * @date 2022/4/12 15:43
 */
public interface ArOrderService {


    PagingVO<ArOrderVO> page(ArOrderPageParam arOrderPageParam);

    ArOrderVO get(Long id);

    ApiResult<Long> audit(Long id);

    ApiResult<Long> refush(List<Long> id, String content);

    ApiResult<Long> del(List<Long> ids);

    /**
     * 新增-应收单
     * 状态为草稿状态
     *
     * @param arOrderSaveParam
     * @return
     */
    ApiResult<Long> save(ArOrderSaveParam arOrderSaveParam);

    /**
     * 提交-校验明细金额，汇总金额，单头金额
     * 状态为-已提交
     *
     * @param arOrderSaveParam
     * @return
     */
    ApiResult<Long> commit(ArOrderSaveParam arOrderSaveParam);

    /**
     * 修改-应收单
     *
     * @param arOrderSaveParam
     * @return
     */
    ApiResult<Long> update(ArOrderSaveParam arOrderSaveParam);

    /**
     * 获取应收单详情和明细汇总信息
     *
     * @param id
     * @return
     */
    ArOrderVO getArOrderAndDtl(Long id);

}
