package com.elitesland.yst.production.fin.domain.entity.arverrec;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/4/26 13:12
 */
@Entity
@Table(name = "ar_ver_rec")
@org.hibernate.annotations.Table(appliesTo = "ar_ver_rec", comment = "应收核销记录")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ArVerRecDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 5454865011709631129L;

    @Column(name = "ver_no", columnDefinition = "varchar(20) comment '核销编号'")
    private String verNo;

    @Column(name = "ar_ver_amt", columnDefinition = "decimal(18,8) comment '应收核销金额'")
    private BigDecimal arVerAmt;

    @Column(name = "rec_ver_amt", columnDefinition = "decimal(18,8) comment '收款核销金额'")
    private BigDecimal recVerAmt;

    @Column(name = "cancel_user", columnDefinition = "varchar(20) comment '取消人'")
    private String cancelUser;

    @Column(name = "cancel_user_id", columnDefinition = "bigint(20) comment '取消人ID'")
    private Long cancelUserId;

    @Column(name = "cancel_date", columnDefinition = "datetime(6) comment '取消时间'")
    private LocalDateTime cancelDate;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArVerRecDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArVerRecDO entity = (ArVerRecDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
