package com.elitesland.yst.production.fin.domain.service.paytype;


import com.elitesland.yst.production.fin.domain.entity.paytype.PayTypeOu;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypeOuPageParam;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeOuDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
/**
 * @author zhiyu.he
 * @date 2022/3/16 10:41
 */
public interface PayTypeOuDomainService {

    /**
     * 根据付款单ID查询公司数据
     * @param payTypeId 付款单ID
     * @return 公司信息
     */
    List<PayTypeOuDTO> queryByPayTypeIds(List<Long> payTypeId);

    /**
     * 分页查询公司信息
     * @param param 查询参数
     * @return 公司信息
     */
    PagingVO<PayTypeOuDTO> page(PayTypeOuPageParam param);

    /**
     * 取消分配公司 --删除
     * @param ids 主键ID
     * @return 主键ID
     */
    List<Long> cancelOu(List<Long> ids);

    /**
     * 根据公司ID查询付款单ID
     * @param ouId 公司ID
     * @return 付款单ID
     */
    List<Long> queryByOuId(Long ouId);

    /**
     * 分配公司
     * @param payTypeOus 公司信息
     * @return 新增数据ID
     */
    List<Long> addOu(List<PayTypeOu> payTypeOus);
}
