package com.elitesland.yst.production.fin.domain.service.paytype;


import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.fin.application.convert.paytype.PayTypeOuConvert;
import com.elitesland.yst.production.fin.domain.entity.paytype.PayTypeOu;
import com.elitesland.yst.production.fin.domain.entity.paytype.PayTypeOuDO;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypeOuPageParam;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeOuDTO;
import com.elitesland.yst.production.fin.infr.repo.paytype.PayTypeOuRepo;
import com.elitesland.yst.production.fin.infr.repo.paytype.PayTypeOuRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;
/**
 * @author zhiyu.he
 * @date 2022/3/16 10:41
 */
@Service
@RequiredArgsConstructor
public class PayTypeOuDomainServiceImpl implements PayTypeOuDomainService {

    private final PayTypeOuRepo payTypeOuRepo;

    private final PayTypeOuRepoProc payTypeOuRepoProc;

    @Override
    public List<PayTypeOuDTO> queryByPayTypeIds(List<Long> payTypeIds) {
        return payTypeOuRepoProc.queryByPayTypeIds(payTypeIds);
    }

    @Override
    public PagingVO<PayTypeOuDTO> page(PayTypeOuPageParam param) {
        return payTypeOuRepoProc.page(param);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> cancelOu(List<Long> ids) {
        payTypeOuRepoProc.deleteByIds(ids);
        return ids;
    }

    @Override
    public List<Long> queryByOuId(Long ouId) {
        return payTypeOuRepoProc.queryByOuId(ouId);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> addOu(List<PayTypeOu> payTypeOus) {
        payTypeOus.forEach(PayTypeOu::checkNotNull);
        if (CollUtil.isEmpty(payTypeOus)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "分配公司获取数据为空");
        } else {
            Long payTypeId = payTypeOus.get(0).getPayTypeId();
            List<Long> ids = payTypeOuRepoProc.queryByPayTypeIds(List.of(payTypeId))
                    .stream().map(PayTypeOuDTO::getOuId).collect(Collectors.toList());
            //只保留之前没有分配过的公司
            List<PayTypeOu> needSave = payTypeOus.stream().
                    filter(ou -> !ids.contains(ou.getOuId())).collect(Collectors.toList());
            List<PayTypeOuDO> typeOuDOS = PayTypeOuConvert.INSTANCE.convert(needSave);
            return payTypeOuRepo.saveAll(typeOuDOS).stream().
                    map(PayTypeOuDO::getId).collect(Collectors.toList());
        }
    }
}
