package com.elitesland.yst.production.fin.infr.factory.recorder;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.util.StringUtils;
import com.elitesland.yst.production.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.yst.production.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.yst.production.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:59
 */
@RequiredArgsConstructor
@Component
public class RecOrderFactory {

    private final RecOrderRepoProc recOrderRepoProc;

    private final RecOrderDtlRepoProc recOrderDtlRepoProc;

    public PagingVO<RecOrderDTO> recOrderPage(RecOrderPageParam param) {
        if (!StringUtils.isEmpty(param.getSourceNoDtl())) {
            //查询出所有付款单ID
            List<Long> ids = recOrderDtlRepoProc.queryBySourceNo(param.getSourceNoDtl()).stream().distinct().collect(Collectors.toList());
            //如果为空直接返回空
            if (CollUtil.isEmpty(ids)) {
                return new PagingVO<>(0,new ArrayList<>());
            } else {
                //不为空加上主键ID作为查询条件
                return recOrderRepoProc.page(param, ids);
            }
        } else {
            //为空走普通查询
            return recOrderRepoProc.page(param, null);
        }
    }
}
