package com.elitesland.yst.production.fin.infr.factory.rectype;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.fin.domain.param.rectype.RecTypePageParam;
import com.elitesland.yst.production.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.yst.production.fin.infr.repo.rectype.RecTypeOuRepoProc;
import com.elitesland.yst.production.fin.infr.repo.rectype.RecTypeRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/11 14:56
 */
@RequiredArgsConstructor
@Component
public class RecTypeFactory {

    private final RecTypeRepoProc recTypeRepoProc;

    private final RecTypeOuRepoProc reTypeOuRepoProc;

    public PagingVO<RecTypeDTO> payTypePage(RecTypePageParam param) {
        //如果公司ID为空走普通查询
        if (param.getOuId() != null) {
            //查询出所有付款单ID
            List<Long> ids = reTypeOuRepoProc.queryByOuId(param.getOuId()).stream().distinct().collect(Collectors.toList());
            //如果为空直接返回空
            if (CollUtil.isEmpty(ids)) {
                return new PagingVO<>(0,new ArrayList<>());
            } else {
                //不为空加上主键ID作为查询条件
                return recTypeRepoProc.page(param, ids);
            }
        } else {
            //为空走普通查询
            return recTypeRepoProc.page(param, null);
        }
    }
}
