package com.elitesland.yst.production.fin.infr.repo.paytype;


import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.fin.domain.entity.paytype.QPayTypeDO;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypePageParam;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @version V1.0
 * @package com.elitesland.yst.production.fin.infr.repo.proc
 * @date 2022/3/10 13:03
 */
@Component
@RequiredArgsConstructor
public class PayTypeRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPayTypeDO qPayTypeDO = QPayTypeDO.payTypeDO;

    public PagingVO<PayTypeDTO> page(PayTypePageParam payTypeParam, List<Long> ids) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(payTypeParam.getPayTypeCode())) {
            predicates.add(qPayTypeDO.payTypeCode.like('%' + payTypeParam.getPayTypeCode() + '%'));
        }
        if (StringUtils.isNotBlank(payTypeParam.getPayTypeName())) {
            predicates.add(qPayTypeDO.payTypeName.like('%' + payTypeParam.getPayTypeName() + '%'));
        }
        if (!CollUtil.isEmpty(ids)) {
            predicates.add(qPayTypeDO.id.in(ids));
        }
        predicates.add(qPayTypeDO.deleteFlag.eq(0));
        JPAQuery<PayTypeDTO> query = select(PayTypeDTO.class).where(ExpressionUtils.allOf(predicates));
        payTypeParam.setPaging(query);
        payTypeParam.fillOrders(query, qPayTypeDO);
        return PagingVO.<PayTypeDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public PayTypeDTO defaultValue() {
        return select(PayTypeDTO.class)
                .where(qPayTypeDO.defaultFlag.isTrue())
                .where(qPayTypeDO.enableFlag.isTrue())
                .fetchOne();
    }

    public List<PayTypeDTO> findAll() {
        return select(PayTypeDTO.class)
                .where(qPayTypeDO.enableFlag.isTrue())
                .fetch();
    }

    public Long updateDefaultById(Long id, Boolean isDefault) {
        return jpaQueryFactory.update(qPayTypeDO)
                .set(qPayTypeDO.defaultFlag, isDefault)
                .where(qPayTypeDO.id.eq(id))
                .execute();
    }

    public void updateDefault() {
        jpaQueryFactory.update(qPayTypeDO)
                .set(qPayTypeDO.defaultFlag, false)
                .where(qPayTypeDO.defaultFlag.isTrue())
                .execute();
    }

    public Boolean existPayCode(String payCode) {
        return jpaQueryFactory.select(qPayTypeDO.payTypeCode)
                .from(qPayTypeDO)
                .where(qPayTypeDO.payTypeCode.eq(payCode))
                .fetchCount() > 0;
    }

    public Boolean existPayName(String payName) {
        return jpaQueryFactory.select(qPayTypeDO.payTypeName)
                .from(qPayTypeDO)
                .where(qPayTypeDO.payTypeName.eq(payName))
                .fetchCount() > 0;
    }

    public List<PayTypeDTO> findByIds(Collection<Long> ids) {
        return select(PayTypeDTO.class)
                .where(qPayTypeDO.id.in(ids))
                .where(qPayTypeDO.deleteFlag.eq(0))
                .fetch();
    }

    public Boolean isFirst() {
        return jpaQueryFactory.select(qPayTypeDO.id)
                .from(qPayTypeDO)
                .where(qPayTypeDO.deleteFlag.eq(0))
                .fetchCount() > 0;
    }

    public void deleteByIds(List<Long> ids) {
        jpaQueryFactory.delete(qPayTypeDO)
                .where(qPayTypeDO.id.in(ids))
                .execute();
    }

    public void updateEnable(List<Long> ids, Boolean trueOrFalse) {
        jpaQueryFactory.update(qPayTypeDO)
                .set(qPayTypeDO.enableFlag, trueOrFalse)
                .where(qPayTypeDO.id.in(ids))
                .execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPayTypeDO.id,
                qPayTypeDO.payTypeCode,
                qPayTypeDO.payTypeName,
                qPayTypeDO.defaultFlag,
                qPayTypeDO.enableFlag)
        ).from(qPayTypeDO);
    }
}
