package com.elitesland.yst.production.fin.provider.aporder;

import com.elitesland.yst.production.fin.Application;
import com.elitesland.yst.production.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.yst.production.fin.domain.entity.aporder.ApOrder;
import com.elitesland.yst.production.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.yst.production.fin.param.aporder.ApOrderRpcParam;
import com.elitesland.yst.production.fin.service.aporder.ApOrderRpcService;
import com.elitescloud.boot.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.provider.aporder
 * @date 2022/5/17 16:07
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ApOrderRpcService.PATH)
public class ApOrderRpcServiceImpl implements ApOrderRpcService {


    public final ApOrderDomainService apOrderDomainService;

    @Override
    public Long save(ApOrderRpcParam apOrderRpcParam) {
        if (StringUtils.isBlank(apOrderRpcParam.getCreateMode())) {
            throw new BusinessException("单据来源 createMode不能为空");
        }
        // DTO转
        ApOrder apOrder = ApOrderConvert.INSTANCE.convertRpc(apOrderRpcParam);
        Long resId = apOrderDomainService.save(apOrder);
        return resId;
    }

}
