package com.elitesland.yst.production.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/03
 */
@Data
public class InvStkAllRpcDtoParam implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("商品及单位集合")
    private List<InvStkItemUomRpcDtoParam> invStkItemUomParams;

    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("温层")
    private String deter1;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("序列号")
    private List<String> snNos;

    @ApiModelProperty("生产批次")
    private String menuLotNo;

    /**
     * 库存合作伙伴类型
     */
    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    /**
     * 库存合作伙伴名称
     */
    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    /**
     * 库存合作伙伴编码
     */
    @ApiModelProperty("合作伙伴编码")
    private String pCode;

    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;


    @ApiModelProperty("仓库集合")
    private List<Long> whIds;

    @ApiModelProperty("公司ID集合")
    private List<Long> ouIds;

    @ApiModelProperty("bu集合")
    private List<Long> buIds;

    @ApiModelProperty("功能区集合")
    private List<String> deter2s;

    @ApiModelProperty("批次号集合")
    private List<String> lotNos;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("功能库区类型")
    private String deter2Type;





}
