package com.elitesland.yst.production.inv.dto.invstk;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * <p>
 * 库存余额报表实体类
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-05-16 10:58:08
 */
@Data
public class InvStkGroupRpcDTO implements Serializable {

    /**
     * 公司ID
     */
    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    private String ouCode;
    private String ouName;

    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("品类")
    private String itemCateCode;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty(value = "仓库类型名称")
    private String whTypeName;

    @ApiModelProperty(value = "仓库类型编码")
    private String whCode;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名称（暂时使用）")
    private String deter2Name;

    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;

    /**
     * 现有量
     */
    @ApiModelProperty("现有量")
    private BigDecimal ohQty;
    /**
     * 现有量2
     */
    @ApiModelProperty("现有量2")
    private BigDecimal ohQty2;
    /**
     * SO硬承诺量 SO已配货
     */
    @ApiModelProperty("SO硬承诺量 SO已配货")
    private BigDecimal rsvQty;
    /**
     * RO预留量 未配货的可用预留量
     */
    @ApiModelProperty("RO预留量 未配货的可用预留量")
    private BigDecimal rsvQty2;

    /**
     * 预留量4
     */
    @ApiModelProperty("预留量4")
    private BigDecimal rsvQty4;
    /**
     * 锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏
     */
    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
    private BigDecimal lockQty;

    /**
     * 锁定量2
     */
    @ApiModelProperty("锁定量2")
    private BigDecimal lockQty2;
    /**
     * 锁定量3
     */
    @ApiModelProperty("锁定量3")
    private BigDecimal lockQty3;
    /**
     * 锁定量4
     */
    @ApiModelProperty("锁定量4")
    private BigDecimal lockQty4;

    /**
     * 在途量
     */
    @ApiModelProperty("在途量")
    private BigDecimal owQty;

    /**
     * 在途量2
     */
    @ApiModelProperty("在途量2")
    private BigDecimal owQty2;
    /**
     * 在途量3
     */
    @ApiModelProperty("在途量3")
    private BigDecimal owQty3;
    /**
     * 在途量4
     */
    @ApiModelProperty("在途量4")
    private BigDecimal owQty4;

    /**
     * 可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量
     */
    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    private BigDecimal avalQty;

    /**
     * 可用量2
     */
    @ApiModelProperty("可用量2")
    private BigDecimal avalQty2;

    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("库存合作伙伴类型")
    @SysCode(sys = "yst-inv", mod = "PARTNER_TYPE")
    private String pType;
    @ApiModelProperty("库存合作伙伴类型名称")
    private String pTypeName;

    @ApiModelProperty("品牌")
    private String brand;
    private String brandName;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty("商品SKU条码")
    private String barCode;

    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    private String itemTypeName;
    @ApiModelProperty("商品SKU物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty("库存总重")
    private Double stkWeight;

    @ApiModelProperty("库存总体积")
    private Double stkVolume;

    @ApiModelProperty("箱毛重")
    private Float pkgGrossWeight;

    @ApiModelProperty("箱高")
    private Float pkgHeight;

    @ApiModelProperty("箱宽")
    private Float pkgWidth;

    @ApiModelProperty("箱长")
    private Float pkgLength;

    @ApiModelProperty("货架")
    private String goodShelve;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("品类")
    private List<String> itemCatePathName;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    @ApiModelProperty("货位")
    private String whPosi;


    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("序列号")
    private String snNo;

}
