package com.elitesland.yst.production.inv.dto.invstk;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 库存结存明细(InvStk)实体类
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-1 14:00:47
 */
@Data
@ApiModel(description = "出库结果信息")
public class InvStkQtyResultRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    /**
     * 实际发货数量
     */
    @ApiModelProperty("数量")
    private BigDecimal qty;
    /**
     * 实际发货批号
     */
    @ApiModelProperty("批号")
    private String lotNo;

    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;

    /**
     * 单据号
     */
    @ApiModelProperty("来源单据号")
    private String srcDocNo;

    @ApiModelProperty("行号")
    private Double lineNo;


}