package com.elitesland.yst.production.inv.dto.invwh;

import com.elitesland.yst.production.inv.util.BaseModelDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @since 2020-07-16 14:07:34
 */
@Data
@ApiModel(value = "inv_wh_area", description = "库区")
public class InvWhAreaSaveDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = 253177224560509155L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("地址号 仓库本身的地址号")
    private Long addrNo;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    /**
     * 库存合作伙伴编码
     */
    @ApiModelProperty("合作伙伴编码")
    private String pCode;

    /**
     * 库存合作伙伴类型
     */
    @ApiModelProperty("合作伙伴类型")
    private String pType;

    /**
     * 合作伙伴地址
     */
    @ApiModelProperty("合作伙伴地址")
    private String pAddr;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区(旧版) [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;


    /**
     * 客户地址号 ADDR_NO
     */
    @ApiModelProperty("客户地址号 ADDR_NO")
    private String deter3;

    /**
     * 限定词4
     */
    @ApiModelProperty("限定词4")
    private String deter4;
    /**
     * 限定词5
     */
    @ApiModelProperty("限定词5")
    private String deter5;
    /**
     * E1BP编号
     */
    @ApiModelProperty("ERP编码")
    private String outerCode;

    /**
     * ERP编号
     */
    @ApiModelProperty("ERP名")
    private String outerCodeName;

    /**
     * E1库区编号
     */
    @ApiModelProperty("E1库区编号")
    private String outerCode2;


    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCodeName;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("详细地址")
    private String detailaddr;

    @ApiModelProperty("外部系统编码")
    private String otherSysCode;

    @ApiModelProperty("外部系统名称")
    private String otherSysName;
}