package com.elitesland.yst.production.inv.dto.invwh;


import com.elitesland.yst.production.inv.util.BaseModelDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


/**
 * <p>
 * 功能说明 仓库
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-1 14:00:47
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel( description = "仓库配送范围")
public class InvWhDeliveryRpcDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = -84413014701696628L;

    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("whId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("secBuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whTypeName;

    /**
     * 地址号 仓库本身的地址号
     */
    @ApiModelProperty("地址号 仓库本身的地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;


    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;

    @ApiModelProperty("公司名称")
    private String ouName;


    @ApiModelProperty("省编码")
    private String pcode;

    @ApiModelProperty("省")
    private String pname;


    @ApiModelProperty("市编码")
    private String ccode;

    @ApiModelProperty("市")
    private String cname;

    /**
     * aCode
     */
    @ApiModelProperty("区（县）编码")
    private String acode;

    @ApiModelProperty("区（县)")
    private String aname;

    /**
     * sCode
     */
    @ApiModelProperty("乡编码")
    private String scode;

    /**
     * sCode
     */
    @ApiModelProperty("乡")
    private String sname;


    @ApiModelProperty("全国")
    private Integer allArea;
    private String allAreaName;

    @ApiModelProperty("是否3PL仓库-京云仓标志")
    private Integer thirdplFlag;

    @ApiModelProperty("erp仓库编码")
    private String erpCode;

    @ApiModelProperty("仓库属性-售后仓")
    private String es1;
    private String es1Name;

    @ApiModelProperty("京东仓库关联码")
    private String jdrelateCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京云仓编码")
    private String jdwhCode;

    @ApiModelProperty("不良京云仓")
    private Integer jdbadFlag;








}
