package com.elitesland.yst.production.inv.provider;

import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSettingRpcDTO;
import com.elitesland.yst.production.inv.dto.invwhAreaSetting.InvWhAreaSettingParamRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2022-05-07 14:00:15
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvWhAreaSettingProvider.PATH)
public interface InvWhAreaSettingProvider {
    String PATH = "/invWhAreaSetting";
    /**
     * 废弃不用
     * 根据功能区编码查询功能区名称
     * param deter2s
     *
     * @return
     */
    @PostMapping("/findDeter2List")
    List<InvWhAreaSettingRpcDTO> findDeter2List(@RequestBody List<String> deter2s);

    @PostMapping("/findWhAreaSettingByParam")
    List<InvWhAreaSettingRpcDTO> findWhAreaSettingByParam(@RequestBody InvWhAreaSettingParamRpcDTO whAreaSettingParamRpcDTO);



}
