package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 库存余额 锁定（公共方法37入参）
 * </p>
 *
 * @author ssy
 * @since 2020-09-25
 */
@Data
@ApiModel(value = "库存余额 锁定（公共方法37入参）", description = "库存余额 锁定（公共方法37入参）")
public class InvStkCommon37InSaveVO extends InvBaseModel implements Serializable {

    private static final long serialVersionUID = 6739108872561911140L;
    @ApiModelProperty("操作数量")
    private BigDecimal qty;

    @ApiModelProperty("单据号")
    private String docNo;

    @ApiModelProperty("行号")
    private Double lineNo;

    @ApiModelProperty("日期")
    private LocalDateTime opDate;

    @ApiModelProperty("操作人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("操作类型1")
    private InvStk28Enum invStk28Enum1;
    @ApiModelProperty("操作类型2")
    private InvStk28Enum invStk28Enum2;

    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;

    @ApiModelProperty("销售配货单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDDid;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCode;
    String reasonCodeName;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("来源单据关联的订单类别")
    private String srcDocCls2;

    @ApiModelProperty("来源单据ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId2;

    @ApiModelProperty("来源单据编号2")
    private String srcDocNo2;

    @ApiModelProperty("来源订单明细ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid2;










}