package com.elitesland.yst.production.inv.application.facade.vo.ck;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author lvqf
 * @Date 2021/2/10
 * @Description
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "INV_CK_D", description = "库存盘点明细")
public class InvCkDSaveVO extends BaseModelVO {


    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("品项ID")
    private Long itemId;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("库存数")
    private BigDecimal accQty;

    @ApiModelProperty("实盘数")
    private BigDecimal factQty;

    @ApiModelProperty("库存单位")
    private String uom;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作类型")
    @SysCode(sys = "yst-inv",mod = "PARTNER_TYPE")
    private String pType;
    private String pTypeName;

    @ApiModelProperty("库存合作伙伴名")
    private String pName;
}
