package com.elitesland.yst.production.inv.application.facade.vo.despatch;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 04日 5:16 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "invDespatchConfigPageVO", description = "货运地返回对象")
public class InvDespatchConfigPageVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -3564154459948817175L;
    @ApiModelProperty("发货地编码")
    private String desCode;

    @ApiModelProperty("发货地名")
    private String desName;

    @ApiModelProperty("功能区数量")
    private Integer deter2Count;

    @ApiModelProperty("启用状态")
    private String isEnable;

    @ApiModelProperty("预留字段1")
    private String deter1;
    @ApiModelProperty("所属公司名称")
    private String deter1Name;

    @ApiModelProperty("预留字段3")
    private String deter3;

    @ApiModelProperty("预留字段4")
    private String deter4;

    @ApiModelProperty("预留字段5")
    private String deter5;

    @ApiModelProperty("预留字段6")
    private String deter6;

    @ApiModelProperty(value = "贸易公司白名单标识")
    private Boolean tradeCompanyFlag;
}
