package com.elitesland.yst.production.inv.application.facade.vo.invTrn;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lu.wang
 * @date 2020-08-10 11:13
 * Desc: 库内转移单及明细VO
 */
@Data
@ExcelIgnoreUnannotated
@ApiModel(value = "INV_TRN_TRND", description = "库存转移及明细")
public class InvTrnAndTrnDDownloadRespVO implements Serializable {
    private static final long serialVersionUID = -4731711854801898617L;

    @ExcelProperty("转移单号")
    String docNo;


//    @SysCode(sys = "COM", mod = "APPR_STATUS")
//    String docStatus;
    @ExcelProperty("状态")
    String docStatusName;
    @ExcelProperty("公司")
    String ouName;

//    @SysCode(sys = "ITM", mod = "ITEM_GROUP")
//    String brand;
    @ExcelProperty("品牌")
    String brandName;
    @ExcelProperty("商品编号")
    String itemCode;
    @ExcelProperty("商品名称")
    String itemName;
    @NumberFormat(value = "#,###.##")
    @ExcelProperty("转移数量")
    BigDecimal qty;
    @ExcelProperty("单位")
    String uomName;
    @ExcelProperty("转移原因")
    String reasonCodeName;
    @ExcelProperty("批次")
    String lotNo;

//    @SysCode(sys = "COM", mod = "REASON_CODE")
//    String reasonCode;
    @ExcelProperty("从功能区")
    String odeter2Name;
    @ExcelProperty("至功能区")
    String ideter2Name;

/*    @ExcelProperty("从仓库编码")
    String owhCode;*/
    @ExcelProperty("从仓库")
    String owhName;
/*    @ExcelProperty("至仓库编码")
    String iwhCode;*/
    @ExcelProperty("至仓库")
    String iwhName;

//    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
//    String oDeter1;
/*    @ExcelProperty("从温层")
    String odeter1Name;*/

//    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
//    String iDeter1;
/*    @ExcelProperty("到温层")
    String ideter1Name;*/

//    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
//    String oDeter2;


//    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
//    String iDeter2;


//    @SysCode(sys = "COM", mod = "UOM")
//    String uom;

/*    @ExcelProperty("退货RMA")
    String relateDocNo;*/

  /*  @ExcelProperty("申请日期")
    LocalDateTime applyDate;*/
    @ExcelProperty("创建人")
    String createUserName;
    @ExcelProperty("创建日期")
    LocalDateTime ioDate;

    @ExcelProperty("转移备注")
    String remark;
    /*@NumberFormat(value = "#,###.##")
    @ExcelProperty("成本单价")
    Float costPrice;
    @NumberFormat(value = "#,###.##")
    @ExcelProperty("成本金额")
    Float costAmt;
    @ExcelProperty("外部单据公司")
    String outerOu;
    @ExcelIgnore

    @ExcelProperty("外部单据行号")
    String outerLineno;*/
    String outerType;
    @ColumnWidth(16)
    @ExcelProperty("外部单据编号")
    String outerNo;

}
