package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * <p>
 * 库存余额报表实体类
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-05-16 10:58:08
 */
@Data
public class InvStkGroupBatchRespVO implements Serializable {

    /**
     * 公司ID
     */
    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;


    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴名")
    private String pTypeName;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty(value ="仓库类型名称")
    String whTypeName;

    private String whCode;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名称（暂时使用）")
    private String deter2Name;

    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;

    /**
     * 现有量
     */
    @ApiModelProperty("现有量")
    private BigDecimal ohQty;

    /**
     * SO硬承诺量 SO已配货
     */
    @ApiModelProperty("SO硬承诺量 SO已配货")
    private BigDecimal rsvQty;
    /**
     * RO预留量 未配货的可用预留量
     */
    @ApiModelProperty("RO预留量 未配货的可用预留量")
    private BigDecimal rsvQty2;

    /**
     * 锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏
     */
    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
    private BigDecimal lockQty;


    @ApiModelProperty("批次")
    private String lotNo;

    /**
     * 可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量
     */
    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    private BigDecimal avalQty;


    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;

    @ApiModelProperty("货架")
    private String goodShelve;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;





}