package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;


@Data
@ApiModel(description = "库存快照查询")
public class InvStkSsQueryParamVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -7588596429607190084L;
    @ApiModelProperty("品牌")
    private List<String> brands;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;


    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号集合")
    private List<String> itemCodes;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;

    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("功能区ID集合")
    private List<String> deter2s;

    @ApiModelProperty("商品ID集合")
    private List<Long> itemIds;

    /**
     * 商品类型
     */
    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("物料类型")
    private String itemType2;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty("创建人id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("合作伙伴类型")
    private String pType;

    @ApiModelProperty("合作伙伴code")
    private String pCode;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("快照时间")
    private LocalDateTime stkSsTime;

    @ApiModelProperty("功能区关键字")
    private String deter2KeyWord;

    @ApiModelProperty("库存快照时间从")
    private LocalDateTime stkSsTimeFrom;

    @ApiModelProperty("库存快照时间至")
    private LocalDateTime stkSsTimeTo;


}
