package com.elitesland.yst.production.inv.application.facade.vo.ioc;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:库存操作码
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvIocParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -3090471520631246842L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("操作码ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> idList;

    @ApiModelProperty("操作码")
    private String ioCode;
    @ApiModelProperty("操作码编码集合")
    private List<String> ioCodeList;

    @ApiModelProperty("操作码名称")
    private String ioName;

    @ApiModelProperty("操作类型 [UDC]INV:IO_TYPE")
    private String ioType;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    private String status;

}
