package com.elitesland.yst.production.inv.application.service;

import com.elitesland.yst.production.inv.application.facade.vo.InvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon37InSaveVO;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;

import java.util.List;
import java.util.Optional;


/**
 * @author lvqf
 * @date 2021-02-1 11:36
 * Desc:
 */
public interface InvAjService {


    /**
     * zhao_qiao_gong
     * 保存库存调整单
     *
     * @param createParam 保存信息
     * @return 主表id
     */
    Long saveOneInvAj(InvAjSaveVO createParam);


    void cancelBatch(List<Long> ids);

    Optional<InvAjDTO> findInvAj(Long id);

    void approveBatch(List<Long> ids);

    void refuseBatch(List<Long> ids);

    void confirmInvAj(List<Long> ids);

    Long submitOneInvAj(InvAjSaveVO invAjSaveVO);

    /**
     * @description: TODO
     * @author
     * @date  转换公共方法入参（工作刘需要调用）
     * @version 1.0
     */
    List<InvStkCommon37InSaveVO> convertCommon37InVO(List<InvAjDRespVO> invAjDRespVOS, InvAjDTO invAjDTO, InvStk28Enum invStk28Enum);
}
