package com.elitesland.yst.production.inv.application.service;

import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.*;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-01-029 10:58:11
 */
public interface InvStkService {

    InvStkGroupRespVO getInvStkGroupByParam(InvBaseModel queryParam);

    List<InvStkGroupRespVO> selectInvStkGroupByInvBaseModel(InvBaseModel param);

    /**
     * 批量查询库存
     *
     * @param param
     * @return
     */
    List<InvStkGroupBatchRespVO> getInvStkGroupBatchByParam(InvStkGroupBatchParamVO param);

    PagingVO<InvStkGroupRespVO> searchD(InvStkQueryGroupParamVO param);


    /**
     * 全量库存分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 库存多条数据
     */
    PagingVO<InvStkGroupRespVO> fullSearch(InvStkQueryGroupParamVO param);

    List<InvStkGroupRespVO> selectInvStkGroupByParam(InvStkQueryGroupParamVO param);

    void update(InvStkUpdateSaveVO param);

    Long createOne(InvStkDO invStkDO);

    Long createInvStk(InvStkDO invStkDO);

    int updateStkQty(InvStkDO invStkDO);

    void deleteBatch(List<Long> ids);

    /**
     * 根据条件 itemId、variId、lotNo、whId,（deter1,deter2)||deter3 取唯一对应的库存信息
     *
     * @param queryParam 查询条件
     * @return
     */
    InvStkRespVO getInvStk(InvBaseModel queryParam);

    InvStkDO getInvStkDo(InvBaseModel queryParam);

    Optional<InvStkRespVO> findIdOne(Long id);

    PagingVO<InvStkRespVO> search(InvStkQueryParamVO param);

    /**
     * 库存批次查询
     *
     * @param param
     */
    PagingVO<InvStkDRespVO> searchLot(InvStkDQueryParamVO param);

    /**
     * 分页查询在库商品
     *
     * @param queryParam
     * @return
     */
    PagingVO<ItmInvStkItemRespVO> searchInvStkItem(InvStkItemQueryParam queryParam);

    List<ItmInvStkItemRespVO> getInvStkItemByParam(InvStkItemQueryParam queryParam);

    List<ItmInvStkItemRespVO> selectInvStkItemByDesIds(List<Long> desIds);



}
