package com.elitesland.yst.production.inv.application.service.impl;


import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.yst.production.inv.application.facade.vo.*;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21InVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommonSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.*;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvAjConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAjDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAj;
import com.elitesland.yst.production.inv.domain.entity.InvAjD;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDO;
import com.elitesland.yst.production.inv.domain.service.InvAjDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAjDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.spi.InvAjSpi;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.vo.InvAjVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @author lvqf
 * @date 2021-02-1 11:36
 * Desc:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InvAjServiceImpl implements InvAjService {
    private final JPAQueryFactory jpaQueryFactory;
    private final InvAjDomainService invAjDomainService;
    private final InvAjDDomainService invAjDDomainService;
    private final SystemService systemService;
    private final TransactionTemplate transactionTemplate;
    private final WorkflowService workflowService;
    private final InvWhAreaService invWhAreaService;
    private final ItmOutService itmOutService;
    private final InvStkCommonService invStkCommonService;
    private final OrgOutService orgOutService;
    private final InvWhDomainService invWhDomainService;
    private final InvStkService invStkService;

    private final InvLotCommonService invLotCommonService;

    private final InvLotService invLotService;

    private final InvStkOptBizService invStkOptBizService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveOneInvAj(InvAjSaveVO invAjSaveVO) {
        invAjSaveVO.setCreateTime(LocalDateTime.now());
        this.checkInvAjQty(invAjSaveVO);
        //保存调整单
        Long masId = this.saveInvAj(invAjSaveVO);
        // 校验仓库、温层对应功能区是否存在
        List<InvAjDSaveVO> invAjDSaveVOList = invAjSaveVO.getInvAjDSaveVOList();
        if (!CollectionUtils.isEmpty(invAjDSaveVOList)) {
            whVerify(invAjSaveVO.getInvAjDSaveVOList());
        }
        //保存调整单明细
        this.saveInvAjDVOS(invAjSaveVO, masId);
        return masId;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelBatch(List<Long> ids) {
        ids.forEach(id -> {
            InvAjDTO invAjDTO = invAjDomainService.findById(id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "此库存调整但不存在，请检查");
            }
            if (!UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(invAjDTO.getDocStatus())
                    && !UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "只有草稿/已拒绝状态的调整单能够取消，请检查");
            }
            //更新申请单状态为 取消
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_CL.getValueCode());
            InvAj invAj = InvAjConvert.INSTANCE.invAjDTOToInvAj(invAjDTO);
            invAjDomainService.createInvAj(invAj);
        });
    }

    @Override
    @SysCodeProc
    public Optional<InvAjDTO> findInvAj(Long masId) {
        if (masId == null) {
            return Optional.empty();
        }
        InvAjDTO invAjDTO = invAjDomainService.findById(masId);
        if (Objects.nonNull(invAjDTO)) {
            // 填充仓库编码、名称等信息
            this.fillUpNameList(List.of(invAjDTO));
            List<InvAjDRespVO> invAjDRespVOS = invAjDDomainService.findByMasId(masId);
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            List<Long> itemIds = invAjDRespVOS.stream().filter(f -> f.getItemId() != null)
                    .map(InvAjDRespVO::getItemId)
                    .distinct().collect(Collectors.toList());
            itmItemPartParam.setItemIds(itemIds);
            List<String> deter2s = invAjDRespVOS.stream().map(InvAjDRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            InvWhAreaParamVO invWhAreaParamVO = new InvWhAreaParamVO();
            invWhAreaParamVO.setDeter2s(deter2s);
            invWhAreaParamVO.setWhId(invAjDTO.getWhId());
            List<InvWhAreaRespVO> whAreaRespVOS = invWhAreaService.findWhAreasByParam(invWhAreaParamVO);
            List<ItmItemRpcDTO> itmItemPartDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            Map<String, String> pTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_CUST.getModel(), UdcEnum.INV_PARTNER_TYPE_CUST.getCode());
            List<InvAjDRespVO> invAjDRespVOList = invAjDRespVOS.stream().map(e -> {
                whAreaRespVOS.stream().filter(a -> a.getDeter2().equals(e.getDeter2()))
                        .findAny().ifPresent(m ->{
                            e.setDeter2Name(m.getDeter2Name());
                });
                InvAjDRespVO invAjDRespVO = new InvAjDRespVO();
                BeanUtils.copyProperties(e, invAjDRespVO);

                invAjDRespVO.setReasonCodeName(getUdcDesc(UdcEnum.INV_REASON_CODE_SKAJ.getModel(), UdcEnum.INV_REASON_CODE_SKAJ.getCode(),
                        e.getReasonCode()));
                invAjDRespVO.setUomName(getUdcDesc(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode(), e.getUom()));
                // 商品编码、名称转换
                if (!CollectionUtils.isEmpty(itmItemPartDTOS)) {
                    itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(i -> {
                        invAjDRespVO.setItemCode(i.getItemCode());
                        invAjDRespVO.setItemName(i.getItemName());
                        invAjDRespVO.setLotFlag(i.getLotFlag());
                    });
                }
                // 合作伙伴类型名称
                if (!CollectionUtils.isEmpty(pTypeMap) && pTypeMap.containsKey(invAjDRespVO.getPType())) {
                    invAjDRespVO.setPTypeName(pTypeMap.get(invAjDRespVO.getPType()));
                }
                // 合作伙伴名称转换
                if (e.getPType() != null && e.getPCode() != null) {
                    InvParentParamVO paramVO = new InvParentParamVO();
                    paramVO.setCode(e.getPCode());
                    paramVO.setType(e.getPType());
                    List<OrgRespVO> vos = orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(vos)) {
                        invAjDRespVO.setPName(vos.get(0).getName());
                    }
                }
                // 库存可供量查询
                invAjDRespVO.setAvalQty(getAvalQty(invAjDRespVO));
                // 保质期天数查询
                if (invAjDRespVO.getLotNo() != null) {
                    invAjDRespVO.setExpireDays(getExpireDays(invAjDRespVO));
                }
                return invAjDRespVO;
            }).collect(Collectors.toList());
            invAjDTO.setInvAjDVOList(invAjDRespVOList);
            return Optional.of(invAjDTO);
        }
        return Optional.empty();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approveBatch(List<Long> ids) {
        ids.forEach(id -> {
            InvAjDTO invAjDTO = invAjDomainService.findById(id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "单据不存在，请检查");
            }

            if (invAjDTO.getProcInstId() != null && UdcEnum.PUR_PO_STATUS_APPING.getValueCode().equals(invAjDTO.getProcInstStatus())) {
                throw new BusinessException(ApiCode.FAIL, "该调整单已开启工作流，需进入工作流审核！");
            }
            if (!UdcEnum.INV_AJ_STATUS_APPING.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "请选择调整单状态为审核中");
            }

            //暂时注释（批次没有迁移）
            //批次调整
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType())) {
                val invAjDVOS = invAjDDomainService.findByMasId(invAjDTO.getId());
                //批次去重
                ArrayList<InvAjDRespVO> invAjDRespVOS = invAjDVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(
                        () -> new TreeSet<>(Comparator.comparing(o -> o.getItemId() + "_" + o.getLotNo() + "_" + o.getVariId()))),
                        ArrayList::new));
                List<InvLotSaveVO> invLotVOList = new ArrayList<>();
                invAjDRespVOS.stream().forEach(i -> {
                    if (i.getLotNo() == null) {
                        throw new BusinessException(ApiCode.FAIL, "数据异常请检查！批次调整批次号不能为空");
                    }
                    List<String> param = new ArrayList<>();
                    param.add(i.getItemId() + "_" + i.getLotNo());
                    val ret = invLotService.findByAndItemIdAndLotNo(param);
                    if (ret.isEmpty()) {
                        if (i.getToLotNo() != null) {
                            InvLotSaveVO tmp = new InvLotSaveVO();
                            tmp.setItemId(i.getItemId());
                            if(i.getManuDate() == null || i.getExpireDate() == null){
                                throw new BusinessException(ApiCode.FAIL,"批次商品生产日期和失效日期不能为空");
                            }
                            tmp.setManuDate(i.getManuDate());
                            tmp.setExpireDate(i.getExpireDate());
                            tmp.setLotNo(i.getToLotNo());
                            tmp.setSrcDocNo(invAjDTO.getDocNo());
                            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
                            tmp.setOuId(invAjDTO.getOuId());
                            invLotVOList.add(tmp);
                        }
                    } else {
                        List<InvLotCommonSaveVO> invLotCommonSaveVOS = new ArrayList<>();
                        ret.stream().forEach(v -> {
                            v.setMenuLotNo(i.getMenuLotNo());
                            InvLotCommonSaveVO lotVO = BeanUtil.copyProperties(v, InvLotCommonSaveVO.class);
                            invLotCommonSaveVOS.add(lotVO);
                        });
                        // 修改批次信息
                        invLotCommonService.updateInvLotInfo(invLotCommonSaveVOS);
                    }
                });
                // 创建批次
                invLotCommonService.createInvLotInfo(invLotVOList);
            }

            //更新申请单状态为 已审批
            invAjDTO.setId(id);
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPED.getValueCode());
            this.update(invAjDTO);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void refuseBatch(List<Long> ids) {
        ids.forEach(id -> {
            InvAjDTO invAjDTO = this.findIdOne(id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "单据不存在，请检查！ id" + id);
            }
            if (!UdcEnum.INV_AJ_STATUS_APPING.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "单据状态异常无法审批，请检查");
            }

            val invAjDVOS = invAjDDomainService.findByMasId(id);
            List<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = convertCommon37InVO(invAjDVOS, invAjDTO, InvStk28Enum.T_TYPE_26);
            // 调用公共方法37库存锁定减
            if (!CollectionUtils.isEmpty(invStkCommon37InSaveVOS)) {
                invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
            }
            // 更新申请单状态为 已拒绝
            invAjDTO.setId(id);
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_RJ.getValueCode());
            this.update(invAjDTO);
        });
    }

    @Override
    public void confirmInvAj(List<Long> ids) {
        ids = ids.stream().distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.FAIL, "参数异常，请检查");
        }
        for (Long id : ids) {
            InvAjDTO invAjDTO = this.findIdOne(id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "单据不存在，请联系管理人员");
            }
            invAjDTO.setIoDate(LocalDateTime.now());
            if (!UdcEnum.INV_AJ_STATUS_APPED.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "单据状态异常，只有审批完成单据才可确认");
            }
            List<InvAjDRespVO> invAjDRespVOS = invAjDDomainService.findByMasId(id);
            //过期销毁
            if (UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjDTO.getDocType())) {
                InvStkCommonOperateDTO stkCommonOperateDTO = getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ004.getType());
                invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
                //在库调整 - 退料入库
            } else if (UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjDTO.getDocType())) {
                List<InvAjDRespVO> invAjDRespVOS1 = invAjDRespVOS.stream().filter(i -> !StringUtils.isEmpty(i.getToLotNo())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(invAjDRespVOS1)) {
                    this.createLot(invAjDTO, invAjDRespVOS);
                }
                InvStkCommonOperateDTO stkCommonOperateDTO = getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ001.getType());
                invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
                //在库调整 - 领料出库（减少库存）
            } else if (UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType())) {
                  InvStkCommonOperateDTO stkCommonOperateDTO = getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ004.getType());
                invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
                //批次调整
            } else if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType())) {
                this.createLot(invAjDTO, invAjDRespVOS);
                InvStkCommonOperateDTO stkCommonOperateDTO = getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ004.getType());
                invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
                InvStkCommonOperateDTO stkCommonOperateDTO2 = getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ001.getType());
                invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO2);
                // 期初调整
            } else if (UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjDTO.getDocType())) {
                this.createLot(invAjDTO, invAjDRespVOS);
                InvStkCommonOperateDTO stkCommonOperateDTO = getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ001.getType());
                invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            }
            invAjDTO.setId(invAjDTO.getId());
            // 设置单据状态为已确认
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_CF.getValueCode());
            invAjDTO.setIoDate(LocalDateTime.now());
            this.update(invAjDTO);
            //调用库存成本暂时没有接口，先注释
//            invCostAjService.createByInvAj(invAjDTO);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long submitOneInvAj(InvAjSaveVO invAjSaveVO) {
        invAjSaveVO.setLotFlag(true);
        //检查入参id
        Long id = invAjSaveVO.getId();
        Long masId = null;
        InvAjDTO invAjDTO = new InvAjDTO();
        //设置隔离级别
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        //保存或修改后点击提交
        if (id != null) {
            //1,是否存在
            invAjDTO = invAjDomainService.findById(id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "单据不存在,无法提交");
            }
            //2,是否可以编辑
            if (UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(invAjDTO.getDocStatus())
                    || UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(invAjDTO.getDocStatus())) {
                this.saveOneInvAj(invAjSaveVO);
                invAjDTO = InvAjConvert.INSTANCE.invAjSaveVOToInvAjDTO(invAjSaveVO);
                invAjDTO.setProcInstId(invAjDTO.getProcInstId());
                invAjDTO.setProcInstStatus(invAjDTO.getProcInstStatus());
            } else {
                throw new BusinessException(ApiCode.FAIL, "单据状态异常，只有草稿和拒绝状态单据才可提交");
            }
        }
        //直接点击提交(需要先保存后提交)
        if (id == null) {
            //开启事务
            masId = transactionTemplate.execute(transactionStatus -> {
                try {
                    //保存单子(手动开启事务提交)
                    Long aLong = this.saveOneInvAj(invAjSaveVO);
                    return aLong;
                } catch (RuntimeException e) {
                    //回滚
                    transactionStatus.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
            invAjDTO = invAjDomainService.findById(masId);
        }

        /**查询公司的类型：1.总部公司（集团公司） 2.区域公司 3.分子公司
         * 1，3需要开启工作流
         * 2，需要跳过工作流，走正常流程
         * */
        OrgOuRpcDTO orgOuRpcDTO1 = orgOutService.findOuById(invAjSaveVO.getOuId());
        OrgOuRpcDTO orgOuRpcDTO = new OrgOuRpcDTO();
        orgOuRpcDTO.setOuCode("100010");
        orgOuRpcDTO.setOuType("10");
        if (ObjectUtils.isEmpty(orgOuRpcDTO)) {
            throw new BusinessException(ApiCode.FAIL, "查询支撑域公司失败，公司编号为：" + invAjSaveVO.getOuId());
        }
        if (orgOuRpcDTO.getOuType() == null) {
            throw new BusinessException(ApiCode.FAIL, "查询支撑域公司类型失败，公司编号为：" + invAjSaveVO.getOuId());
        }
        if (StringUtils.isEmpty(invAjDTO.getReasonCode())) {
            throw new BusinessException(ApiCode.FAIL, "原因码为空，单号：{}：" + invAjSaveVO.getDocNo());
        }
        try {
            //开始工作流
            List<InvAjSpi> invAjSpis = SpringFactoriesLoader.loadFactories(InvAjSpi.class,null);
            if(!CollectionUtils.isEmpty(invAjSpis)){
                for(InvAjSpi invAjSpi : invAjSpis){
                    InvAjVO invAjVO = new InvAjVO();
                    BeanCopyUtil.beanCopyWithIngore(invAjDTO,invAjVO,BeanCopyUtil.getNullAndIgnorePropertyNames(invAjDTO));
                    invAjSpi.submitAjCallBack(workflowService,jpaQueryFactory,id,invAjVO);
                }
            }
//            this.chiocSign(orgOuRpcDTO, user, id, invAjDTO, 1);
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "启动工作流失败：" + e.getMessage());
        }
        return invAjDTO.getId();
    }

    /**
     * @description: TODO
     * @author
     * @date 启动库存锁定量
     * @version 1.0
     */
    private void stratLock(Long masId, InvAjSaveVO invAjSaveVO) {
        //更新单据状态为完成
        InvAjDTO invAjDTO = this.findIdOne(masId);
        if (Objects.nonNull(invAjDTO)) {
            //非集团公司和分子公司类型不需要启动工作流，手动修改状态
            if (invAjSaveVO.isLotFlag()) {
                InvAjDTO ajDTO = InvAjConvert.INSTANCE.invAjSaveVOToInvAjDTO(invAjSaveVO);
                invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                ajDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                this.update(ajDTO);
            }
            List<InvAjDRespVO> invAjDVOS = invAjDDomainService.findByMasId(invAjDTO.getId());
            List<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = convertCommon37InVO(invAjDVOS, invAjDTO, InvStk28Enum.T_TYPE_22);
            // 调用公共方法37 库存锁定增
            if (!CollectionUtils.isEmpty(invStkCommon37InSaveVOS)) {
                invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
            }
        }
        ;
    }

    private void stratLock2(Long masId, InvAjSaveVO invAjSaveVO) {

        //更新单据状态为完成
        InvAjDTO invAjDTO = this.findIdOne(masId);
        if (Objects.nonNull(invAjDTO)) {
            //非集团公司和分子公司类型不需要启动工作流，手动修改状态
            if (invAjSaveVO.isLotFlag()) {
                InvAjDTO ajDTO = InvAjConvert.INSTANCE.invAjSaveVOToInvAjDTO(invAjSaveVO);
                invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                ajDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                this.update(ajDTO);
            }
            List<InvAjDRespVO> invAjDVOS = invAjDDomainService.findByMasId(invAjDTO.getId());
            //锁定
            InvStkCommonOperateDTO operateDTO = getInvStkCommonOperateDTO(invAjDVOS, invAjDTO,InvStkSceneCodeEnum.INV_AJ_AJ002.getType());
            invStkOptBizService.invStkCommonOperate(operateDTO);
        }
        ;
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAjDRespVO> invAjDRespVOS, InvAjDTO invAjDTO,String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invAjDRespVOS.stream().forEach(invAjDSaveVO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAjDSaveVO.getWhId());
            operateBodyDTO.setItemId(invAjDSaveVO.getItemId());
            operateBodyDTO.setDeter2(invAjDSaveVO.getDeter2());
            operateBodyDTO.setSrcDocId(invAjDTO.getId());
            operateBodyDTO.setDocNo(invAjDTO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAjDSaveVO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
            operateBodyDTO.setLineNo(invAjDSaveVO.getLineNo());
            operateBodyDTO.setCreateUserId(invAjDTO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAjDSaveVO.getUom());
            operateBodyDTO.setQty(invAjDSaveVO.getQty());
            operateBodyDTO.setLotNo(invAjDSaveVO.getLotNo());
            if(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjDTO.getDocType())
            || UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjDTO.getDocType())){
                operateBodyDTO.setLotNo(invAjDSaveVO.getToLotNo());
            }
            if(UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType())){
                operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKOUT.getValueCode());
            }
            operateBodyDTO.setPCode(invAjDSaveVO.getPCode());
            operateBodyDTO.setPType(invAjDSaveVO.getPType());
            operateBodyDTO.setOuId(invAjDTO.getOuId());
            operateBodyDTO.setVariId(invAjDSaveVO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }

    /**
     * @description: TODO
     * @author
     * @date 根据不同的原因码启动工作流
     * @version 1.0
     */
    public void chiocSign(OrgOuRpcDTO orgOuRpcDTO, SysUserDTO user, Long id, InvAjDTO invAjDTO, int sign) {
        if (id == null
                || invAjDTO.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invAjDTO.getProcInstStatus())
        ) {
            /**根据原因码，公司类型不同开启不同的工作流*/
            //流程判断
            String procInstName = "库存调整:" + invAjDTO.getDocNo();
            String procDefKeyName = ProcDefKey.INV_ADJST.name();
            this.startFile(procDefKeyName, invAjDTO, procInstName, user);
        }
    }

    /**
     * @description: TODO
     * @author
     * @date 开启工作流
     * @version 1.0
     */
    public void startFile(String procDefKeyName, InvAjDTO invAjDTO, String procInstName, SysUserDTO user) {
        /************************************************************************
         *                              工作流开始                              *
         ************************************************************************/
        //获取流程变量
        WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(procDefKeyName, procInstName, invAjDTO.getId() + "", null));
        if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
            throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
        }
        //修改业务审批数据
        QInvAjDO qInvAjDO = QInvAjDO.invAjDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvAjDO)
                .set(qInvAjDO.procInstId, processInfoWorkflowResult.getData().getProcInstId())
                .set(qInvAjDO.submitTime, LocalDateTime.now())
                .where(qInvAjDO.id.eq(invAjDTO.getId()));
        if (!Objects.equals(processInfoWorkflowResult.getData().getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qInvAjDO.procInstStatus, ProcInstStatus.APPROVING);
            jpaUpdateClause.set(qInvAjDO.docStatus, UdcEnum.PUR_PO_STATUS_APPING.getValueCode());//单据状态
        }
        jpaUpdateClause.execute();

        /************************************************************************
         *                              工作流结束                                *
         ************************************************************************/
    }

    /**
     * 创建批次
     *
     * @param invAjDTO      调整主表
     * @param invAjDRespVOS 调整明细
     */
    private void createLot(InvAjDTO invAjDTO, List<InvAjDRespVO> invAjDRespVOS) {
        List<InvLotSaveVO> invLots = new ArrayList<>();
        //查询新建的批次是否存在
        List<InvLotCommon21InVO> invLotCommon21InVOS = invAjDRespVOS.stream().map(grd -> {
            InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO();
            invLotCommon21InVO.setItemId(grd.getItemId());
            invLotCommon21InVO.setVariId(grd.getVariId());
            invLotCommon21InVO.setLotNo(grd.getToLotNo());
            invLotCommon21InVO.setOuId(invAjDTO.getOuId());
            return invLotCommon21InVO;
        }).collect(Collectors.toList());
        //暂时注释，批次项目没有迁移
        //TODO 此方法上游未加公司维度
        Map<Integer, List<InvLotRespVO>> invLotVOMap = invLotCommonService.getInvLotVOList(invLotCommon21InVOS);
        invAjDRespVOS.forEach(grd -> {
            //如果批次已经存在结束此次循环
            if (invLotVOMap.get(invAjDRespVOS.indexOf(grd)) != null && invLotVOMap.get(invAjDRespVOS.indexOf(grd)).size() != 0) {
                return;
            }
            InvLotSaveVO invLotSaveVO = new InvLotSaveVO();
            invLotSaveVO.setOuId(invAjDTO.getOuId());
            invLotSaveVO.setItemId(grd.getItemId());
            invLotSaveVO.setManuDate(grd.getManuDate());//生产日期
            invLotSaveVO.setExpireDate(grd.getExpireDate());//失效日期
            if(grd.getExpireDate() != null){
               invLotSaveVO.setUntilExpireDays((int) (grd.getExpireDate().toLocalDate().toEpochDay() - LocalDate.now().toEpochDay()));
            }
            invLotSaveVO.setLotNo(grd.getToLotNo());//批次号
            invLotSaveVO.setMenuLotNo(grd.getMenuLotNo());
            invLotSaveVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
            invLotSaveVO.setSrcDocId(invAjDTO.getId());
            invLotSaveVO.setSrcDocNo(invAjDTO.getDocNo());
            invLotSaveVO.setSrcDocDid(grd.getId());
            invLotSaveVO.setVariId(grd.getVariId());
            invLotSaveVO.setMenuLotNo(grd.getMenuLotNo());
            invLots.add(invLotSaveVO);
        });
        if (!CollectionUtils.isEmpty(invLots)) {
            invLotCommonService.createInvLotInfo(invLots);
        }
    }

    public InvAjDTO findIdOne(Long id) {
        InvAjDTO invAjDTO = invAjDomainService.findById(id);
        if (Objects.nonNull(invAjDTO)) {
            val temp = invWhDomainService.findById(invAjDTO.getWhId());
            if (temp.isPresent()) {
                invAjDTO.setWhCode(temp.get().getWhCode());
            }
        }
        return invAjDTO;

    }

    private InvStkCommon28InSaveVO setInvStkCommon28InVO(InvAjDTO invAjDTO, InvAjDRespVO invAjDRespVO) {
        InvStkCommon28InSaveVO invStkCommon28InSaveVO = new InvStkCommon28InSaveVO();
        invStkCommon28InSaveVO.setDocNo(invAjDTO.getDocNo());//单据号
        invStkCommon28InSaveVO.setLineNo(invAjDRespVO.getLineNo());//行号
        invStkCommon28InSaveVO.setOpDate(invAjDTO.getApplyDate());//日期
        invStkCommon28InSaveVO.setCreateUserId(invAjDTO.getApplyEmpId());//收货人
        invStkCommon28InSaveVO.setInvStk28Enum2(null);

        invStkCommon28InSaveVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());//来源单据类别
        invStkCommon28InSaveVO.setSrcDocId(invAjDTO.getId());//来源单据id
        invStkCommon28InSaveVO.setSrcDocDid(invAjDRespVO.getId());//来源单据明细id
        invStkCommon28InSaveVO.setItemId(invAjDRespVO.getItemId());//商品
        invStkCommon28InSaveVO.setVariId(invAjDRespVO.getVariId());//异构
        invStkCommon28InSaveVO.setWhId(invAjDTO.getWhId());//仓库id
        invStkCommon28InSaveVO.setPCode(invAjDRespVO.getPCode());
        invStkCommon28InSaveVO.setPType(invAjDRespVO.getPType());
        invStkCommon28InSaveVO.setDeter1(invAjDRespVO.getDeter1());//温层
        invStkCommon28InSaveVO.setDeter2(invAjDRespVO.getDeter2());//功能区
        invStkCommon28InSaveVO.setDeter3(invAjDRespVO.getDeter3());//客户号
        invStkCommon28InSaveVO.setLotNo(invAjDRespVO.getLotNo());//批次号
        invStkCommon28InSaveVO.setReasonCode(invAjDTO.getReasonCode()); //原因码
        return invStkCommon28InSaveVO;


    }

    /**
     * 转换公共方法37入参VO
     *
     * @param invAjDRespVOS
     * @param invAjDTO
     * @param invStk28Enum
     * @return
     */
    @Override
    public List<InvStkCommon37InSaveVO> convertCommon37InVO(List<InvAjDRespVO> invAjDRespVOS, InvAjDTO invAjDTO, InvStk28Enum invStk28Enum) {
        List<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = new ArrayList<>();
        invAjDRespVOS.forEach(invAjDRespVO -> {
            InvStkCommon37InSaveVO invStkCommon37InSaveVO = this.setInvStkCommon37InVO(invAjDTO, invAjDRespVO);
            invStkCommon37InSaveVO.setInvStk28Enum1(invStk28Enum);
            //库存操作对象
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType())
                    || UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjDTO.getDocType())) {
                invStkCommon37InSaveVOS.add(invStkCommon37InSaveVO);
            }//领料出库需要产生库存锁定
            if (UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType())) {
                invStkCommon37InSaveVOS.add(invStkCommon37InSaveVO);
            }
        });

        return invStkCommon37InSaveVOS;
    }

    private InvStkCommon37InSaveVO setInvStkCommon37InVO(InvAjDTO invAjDTO, InvAjDRespVO invAjDRespVO) {
        InvStkCommon37InSaveVO invStkCommon37InSaveVO = new InvStkCommon37InSaveVO();
        invStkCommon37InSaveVO.setDocNo(invAjDTO.getDocNo()); //单据号
        invStkCommon37InSaveVO.setQty(invAjDRespVO.getQty());
        invStkCommon37InSaveVO.setLineNo(invAjDRespVO.getLineNo());
        invStkCommon37InSaveVO.setOpDate(invAjDTO.getIoDate());
        invStkCommon37InSaveVO.setCreateUserId(invAjDTO.getCreateUserId());
        invStkCommon37InSaveVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
        invStkCommon37InSaveVO.setSrcDocId(invAjDTO.getId());
        invStkCommon37InSaveVO.setSrcDocDid(invAjDRespVO.getId());
        invStkCommon37InSaveVO.setInvStk28Enum2(null);
        invStkCommon37InSaveVO.setPCode(invAjDRespVO.getPCode());
        invStkCommon37InSaveVO.setPType(invAjDRespVO.getPType());
        invStkCommon37InSaveVO.setDeter1(invAjDRespVO.getDeter1());
        invStkCommon37InSaveVO.setDeter2(invAjDRespVO.getDeter2());
        invStkCommon37InSaveVO.setDeter3(invAjDRespVO.getDeter3());
        invStkCommon37InSaveVO.setItemId(invAjDRespVO.getItemId());
        invStkCommon37InSaveVO.setVariId(invAjDRespVO.getVariId());
        invStkCommon37InSaveVO.setLotNo(invAjDRespVO.getLotNo());
        invStkCommon37InSaveVO.setWhId(invAjDTO.getWhId());
        invStkCommon37InSaveVO.setUom(invAjDRespVO.getUom());
        invStkCommon37InSaveVO.setReasonCode(invAjDTO.getReasonCode()); //原因码
        return invStkCommon37InSaveVO;
    }

    /**
     * 保质期天数查询
     *
     * @param invAjDRespVO
     * @return
     */
    private Integer getExpireDays(InvAjDRespVO invAjDRespVO) {
        Integer expireDays = null;
        List<String> param = new ArrayList<>();
        param.add(invAjDRespVO.getItemId() + "_" + invAjDRespVO.getLotNo());
        //暂时注释，批次项目暂时没有迁移
//        List<InvLotRespVO> invLotRespVOS = invLotService.findByAndItemIdAndLotNo(param);
//        if (!CollectionUtils.isEmpty(invLotRespVOS) && invLotRespVOS.get(0).getExpireDays() != null) {
//            return invLotRespVOS.get(0).getExpireDays();
//        }
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(Arrays.asList(invAjDRespVO.getItemId()));
        List<ItmItemRpcDTO> itmItemDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        if (!CollectionUtils.isEmpty(itmItemDTOS) && itmItemDTOS.get(0).getGuaranteeDays() != null) {
            return itmItemDTOS.get(0).getGuaranteeDays();
        }
        return expireDays;
    }

    /**
     * 可供量查询
     *
     * @param invAjDRespVO
     * @return
     */
    private BigDecimal getAvalQty(InvAjDRespVO invAjDRespVO) {
        val invStkParam = new InvBaseModel();
        invStkParam.setItemId(invAjDRespVO.getItemId());
        invStkParam.setWhId(invAjDRespVO.getWhId());
        invStkParam.setVariId(invAjDRespVO.getVariId());
        invStkParam.setLotNo(invAjDRespVO.getLotNo());
        invStkParam.setDeter1(invAjDRespVO.getDeter1());
        invStkParam.setDeter2(invAjDRespVO.getDeter2());
        invStkParam.setPCode(invAjDRespVO.getPCode());
        invStkParam.setPType(invAjDRespVO.getPType());
        invStkParam.setDeter3(invAjDRespVO.getDeter3());
        val invStk = invStkCommonService.getInvStk(invStkParam);
        if (invStk != null) {
            return invStk.getAvalQty();
        }
        return null;
    }


    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty(udcVal) || StringUtils.isEmpty(domain) || StringUtils.isEmpty(udcCode)) {
            return null;
        }
        Map<String, String> codeMap = systemService.sysUdcGetCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty(codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return codeMap.get(udcVal);
        }
        return null;
    }

    /**
     * 填充反查数据
     *
     * @param vos 查询结果
     */
    private void fillUpNameList(List<InvAjDTO> vos) {
        List<Long> whIds = vos.stream().map(InvAjDTO::getWhId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> userIds = vos.stream().map(InvAjDTO::getApplyEmpId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, String> docTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_TYPE_LOT.getModel(), UdcEnum.INV_AJ_TYPE_LOT.getCode());
        Map<String, String> docStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_STATUS_DR.getModel(), UdcEnum.INV_AJ_STATUS_DR.getCode());
        Map<String, String> reasonMap = systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_119.getModel(), UdcEnum.COM_REASON_CODE_119.getCode());
        List<String> deter2s = vos.stream().filter(f -> f.getDeter2() != null).map(InvAjDTO::getDeter2).distinct()
                .filter(Objects::nonNull).collect(Collectors.toList());
        InvWhAreaParamVO whAreaParamVO = new InvWhAreaParamVO();
        whAreaParamVO.setWhIds(whIds);
        whAreaParamVO.setDeter2s(deter2s);
        List<InvWhAreaRespVO> whAreaRespVOS = invWhAreaService.findWhAreasByParam(whAreaParamVO);
        Map<String, String> apprStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());
        List<InvWhRespVO> orgSuppVOS = invWhDomainService.findIdBatch(whIds);
        List<SysUserVO> userVOS = systemService.findAllEmpsByIdIn(userIds);
        List<Long> ouIds = vos.stream().map(InvAjDTO::getOuId).filter(Objects::nonNull).collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuRpcDTOS = orgOutService.findOuByIds(ouIds);
        List<Long> buIds = vos.stream().map(InvAjDTO::getBuId).filter(Objects::nonNull).collect(Collectors.toList());
        List<OrgBuRpcDTO> orgBuRpcDTOS = orgOutService.findBuByIds(buIds);
        vos.stream().forEach(vo -> {
            if(!CollectionUtils.isEmpty(whAreaRespVOS)){
                whAreaRespVOS.stream().filter(a -> a.getDeter2().equals(vo.getDeter2()) &&
                        a.getWhId().equals(vo.getWhId()))
                        .findAny().ifPresent(m -> {
                            vo.setDeter2Name(m.getDeter2Name());
                });
            }
            vo.setProcInstStatusName(vo.getProcInstStatus() != null ? vo.getProcInstStatus().getDesc() : null);
            if (!CollectionUtils.isEmpty(orgOuRpcDTOS)) {
                orgOuRpcDTOS.stream().filter(u -> u.getId().equals(vo.getOuId())).findAny().ifPresent(i -> {
                    vo.setOuCode(i.getOuCode());
                    vo.setOuName(i.getOuName());
                });
            }
            if (!CollectionUtils.isEmpty(orgBuRpcDTOS)) {
                orgBuRpcDTOS.stream().filter(b -> b.getId().equals(vo.getBuId())).findAny().ifPresent(i -> {
                    vo.setBuName(i.getBuName());
                });
            }
            Optional<InvWhRespVO> orgWhVO = orgSuppVOS.stream().filter(v -> v.getId().equals(vo.getWhId())).findFirst();
            if (orgWhVO.isPresent()) {
                InvWhRespVO whVO = orgWhVO.get();
                vo.setWhCode(whVO.getWhCode());
                vo.setWhName(whVO.getWhName());
                vo.setWhType(whVO.getWhType());
            }
            if (!CollectionUtils.isEmpty(userVOS)) {
                userVOS.stream().filter(u -> u.getId().equals(vo.getApplyEmpId())).findAny().ifPresent(i -> {
                    vo.setApplyEmpName(i.getUsername());
                });
            }
            if (!CollectionUtils.isEmpty(docTypeMap) && docTypeMap.containsKey(vo.getDocType())) {
                vo.setDocTypeName(docTypeMap.get(vo.getDocType()));
            }
            if (!CollectionUtils.isEmpty(docStatusMap) && docStatusMap.containsKey(vo.getDocStatus())) {
                vo.setDocStatusName(docStatusMap.get(vo.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty(reasonMap) && reasonMap.containsKey(vo.getReasonCode())) {
                vo.setReasonCodeName(reasonMap.get(vo.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty(apprStatusMap) && apprStatusMap.containsKey(vo.getApprStatus())) {
                vo.setApprStatusName(apprStatusMap.get(vo.getApprStatus()));
            }
        });
    }

    /**
     * 保存调整单
     *
     * @param invAjSaveVO
     * @return
     */
    private Long saveInvAj(InvAjSaveVO invAjSaveVO) {
        InvAj invAj = InvAjConvert.INSTANCE.invAjSaveVOToInvAj(invAjSaveVO);
        Long masId = invAj.getId();
        //设置状态为草稿
        invAj.setDocStatus(invAjSaveVO.getDocStatus() == null ? UdcEnum.INV_AJ_STATUS_DR.getValueCode() : invAjSaveVO.getDocStatus());
        if (masId != null) {
            InvAjDTO invAjDTO = invAjDomainService.findById(masId);
            if (Objects.nonNull(invAjDTO)) {
                if (!UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(invAj.getDocStatus())
                        && !UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(invAj.getDocStatus())) {
                    throw new BusinessException(ApiCode.FAIL, "单据状态异常，无法再次保存");
                }
                this.update(invAjDTO);
                invAjDDomainService.deleteByMasId(masId);
            } else {
                invAj.setDocNo(getInvAjDocNo(invAjSaveVO));
                masId = invAjDomainService.createInvAj(invAj);
            }
        } else {
            invAj.setDocNo(getInvAjDocNo(invAjSaveVO)); //发号器
            masId = invAjDomainService.createInvAj(invAj);
        }
        return masId;
    }

    /**
     * 获取调整单单号
     *
     * @param invAjSaveVO
     * @return
     */
    private String getInvAjDocNo(InvAjSaveVO invAjSaveVO) {
        if (invAjSaveVO.getOuCode() == null) {
            throw new BusinessException(ApiCode.FAIL, "公司编码为空，调用系统域服务公司查询异常，请检查");
        }
        String docNo = null;
        if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjSaveVO.getDocType())) {
            // 批次调整
            docNo = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IE.getCode(), List.of(invAjSaveVO.getOuCode()));
        } else if (UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjSaveVO.getDocType())) {
            // 过期销毁
            docNo = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_ID.getCode(), List.of(invAjSaveVO.getOuCode()));
        } else if (UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjSaveVO.getDocType())
                || UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjSaveVO.getDocType())) {
            // 退料入库、期初调整
            docNo = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IA.getCode(), List.of(invAjSaveVO.getOuCode()));
        } else if (UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjSaveVO.getDocType())) {
            //领料出库
            docNo = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IB.getCode(), List.of(invAjSaveVO.getOuCode()));
        }
        return docNo;
    }

    private void saveInvAjDVOS(InvAjSaveVO createParam, Long masId) {
        //保存调整单明细
        if (!CollectionUtils.isEmpty(createParam.getInvAjDSaveVOList())) {
            List<InvAjDSaveVO> invAjDSaveVOS = createParam.getInvAjDSaveVOList();
            Long finalMasId = masId;
            AtomicDouble linoNo = new AtomicDouble(0);
            List<InvAjD> invAjDList = invAjDSaveVOS.stream().map(d -> {
                InvAjD invAjD = InvAjDConvert.INSTANCE.invAjDSaveVOToInvAjD(d);
                invAjD.setMasId(finalMasId);
                invAjD.setLineNo(linoNo.addAndGet(1));
                invAjD.setCreateTime(LocalDateTime.now());
                if ((createParam.getSourceFlag() == null ? 0 : createParam.getSourceFlag()) == 1
                        && UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(createParam.getDocType())
                        && createParam.getDeter2().equals(UdcEnum.INV_FUNC_TYPE_13.getValueCode())
                ) {
                    invAjD.setDeter2(UdcEnum.INV_FUNC_TYPE_13.getValueCode());
                    invAjD.setReasonCode(UdcEnum.COM_REASON_CODE_119.getValueCode());
                }
                if(createParam.getDocType().equals(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode())){
                    invAjD.setLotNo(invAjD.getToLotNo());
                }
                //数据权限
                this.verifyAjDAuthority(createParam, invAjD);
                return invAjD;
            }).collect(Collectors.toList());

            //创建明细
            invAjDDomainService.saveAll(invAjDList);
        }

    }

    @Transactional(rollbackFor = Exception.class)
    public void update(InvAjDTO invAjDTO) {
        if (Objects.nonNull(invAjDTO)) {
            InvAj invAj = InvAjConvert.INSTANCE.invAjDTOToInvAj(invAjDTO);
            invAjDomainService.createInvAj(invAj);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + invAjDTO.getId());
        }
    }

    private void verifyAjDAuthority(InvAjSaveVO createParam, InvAjD invAjDDO) {
        try {
            invAjDDO.setSecBuId(createParam.getSecBuId() == null ? null : createParam.getSecBuId());
            invAjDDO.setSecOuId(createParam.getOuId() == null ? null : createParam.getOuId());
        } catch (Exception e) {
            log.error("无法获取当前登录人信息，请先登录：{}" + e.getMessage());
        }

    }

    /**
     * 校验库存数量
     *
     * @param invAjSaveVO
     */
    private void checkInvAjQty(InvAjSaveVO invAjSaveVO) {
        invAjSaveVO.getInvAjDSaveVOList().stream().forEach(i -> {
            InvRoCommon30InSaveVO param = new InvRoCommon30InSaveVO();
            param.setItemId(i.getItemId());
            param.setLotNo(i.getLotNo());
            param.setWhId(i.getWhId());
            param.setDeter2(i.getDeter2());
            param.setQty(i.getQty());
            param.setUom(i.getUom());
            param.setDocStatus(UdcEnum.INV_RO_STATUS_APPED.getValueCode());
            if (invAjSaveVO.getDocType().equals(UdcEnum.INV_AJ_TYPE_STKO.getValueCode()) ||
                    invAjSaveVO.getDocType().equals(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode())) {

            } else if (this.checkInvStkExist(param)) {
                //期初调整不需要校验库存
                throw new BusinessException(ApiCode.FAIL, "库存可供量不足！");
            }

        });
    }


    public Boolean checkInvStkExist(InvRoCommon30InSaveVO queryParam) {
        InvBaseModel stkParam = new InvBaseModel();
        stkParam.setItemId(queryParam.getItemId());
        stkParam.setLotNo(queryParam.getLotNo());
        stkParam.setWhId(queryParam.getWhId());
        stkParam.setDeter2(queryParam.getDeter2());
        stkParam.setPCode(queryParam.getPCode());
        stkParam.setPType(queryParam.getPType());
        stkParam.setLimit1(queryParam.getLimit1());
        stkParam.setLimit2(queryParam.getLimit2());
        val invStk = invStkService.getInvStk(stkParam);
        if (invStk == null) {
            return true;
        }
        if (invStk.getAvalQty().compareTo(queryParam.getQty()) >= 0) {
            return false;
        } else {
            return true;
        }

    }

    //参数校验
    private void whVerify(List<InvAjDSaveVO> invAjDSaveVOList) {
        long count = invAjDSaveVOList.stream().map(ajd -> ajd.getItemId() + "_" + ajd.getWhId()
                + "_" + ajd.getDeter2() + "_" + ajd.getLotNo()
                + "_" + ajd.getPCode()
                + "-" + ajd.getLimit1() + "-" + ajd.getLimit2()).distinct().count();
        if (count != invAjDSaveVOList.size()) {
            throw new BusinessException("明细数据参数错误，商品编码,同一仓库，同一库区 或 同一仓库，同一库区，同一批次存在相同数据，请检查");
        }
        invAjDSaveVOList.forEach(i -> {
            InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
            areaParamVO.setWhId(i.getWhId());
            areaParamVO.setDeter2(i.getDeter2());
           // List<InvWhAreaRespVO> invWhAreaRespVOList = invWhAreaDomainService.findWhAreasByParam(areaParamVO);
            List<InvWhAreaRespVO> invWhAreaRespVOList = invWhAreaService.findWhAreasByParam(areaParamVO);
            if (CollectionUtils.isEmpty(invWhAreaRespVOList)) {
                throw new BusinessException(ApiCode.FAIL, String.format("该仓库没有功能库区[%s],请检查数据！", i.getWhName(), i.getDeter2Name()));
            }
            //网格仓库存合作伙伴校验
            if (i.getPType() != null && i.getPCode() != null) {
                List<InvWhAreaRespVO> whAreaRespVOS = invWhAreaRespVOList.stream().filter(v -> i.getPCode().equals(v.getPCode()) && i.getPType().equals(v.getPType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(whAreaRespVOS)) {
                    throw new BusinessException(ApiCode.FAIL, String.format("该仓库功能库区【%s】中,库存合作伙伴【%s】不存在，请配置！", i.getDeter2Name(), i.getPCode()));
                }
            }
        });

    }

}
