package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvDespatchConfigService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.despatch.InvDespatchConfigConvert;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvDespatchConfigDTO;
import com.elitesland.yst.production.inv.infr.repo.despatch.InvDespatchConfigProc;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 04日 5:29 下午
 * @version: 1.0
 */
@Slf4j
@Service("invDespatchConfigBizService")
@AllArgsConstructor
public class InvDespatchConfigServiceImpl implements InvDespatchConfigService {

    private final InvDespatchConfigDomainService invDespatchConfigDomainService;

    private final SystemService systemService;

    private final InvWhService invWhService;

    private final InvDespatchConfigProc invDespatchConfigProc;

    private final OrgOutService orgOutService;


    private final InvWhAreaSettingService invWhAreaSettingService;


    @Override
    public PagingVO<InvDespatchConfigPageVO> searchPage(InvDespatchConfigQueryParam queryParam) {
        if(StringUtils.hasLength(queryParam.getDeter2KeyWord())){
            val invWhRespVOS = invWhService.getDespatchWhByDeter2KeyWord(queryParam.getDeter2KeyWord());
            if(CollectionUtils.isEmpty(invWhRespVOS)){
                return PagingVO.<InvDespatchConfigPageVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            }
            List<String> desCodes = invWhRespVOS.stream().map(InvWhRespVO::getDesCode)
                    .filter(Objects::nonNull)
                    .distinct().collect(Collectors.toList());
            queryParam.setDesCodes(desCodes);
        }
        PagingVO<InvDespatchConfigPageVO> page = invDespatchConfigDomainService.searchPage(queryParam);
        List<InvDespatchConfigPageVO> records = page.getRecords();
        if(!CollectionUtils.isEmpty(records)){
            List<String> desCodes = records.stream().map(InvDespatchConfigPageVO::getDesCode)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<InvDespatchConfigRespVO> configRespVOS = invDespatchConfigDomainService.getDeter2Count(desCodes);

            List<String> deter1List = records.stream().map(InvDespatchConfigPageVO::getDeter1)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<OrgOuRpcDTO> orgOuRpcDTOList = CollectionUtil.isEmpty(deter1List) ? new ArrayList<>() : orgOutService.findOuByCodes(deter1List);
            Map<String,OrgOuRpcDTO> ouMap = CollectionUtil.isEmpty(orgOuRpcDTOList) ? new HashMap<>() : orgOuRpcDTOList.stream().collect(Collectors.toMap(OrgOuRpcDTO::getOuCode, t -> t, (t1, t2) -> t1));

            if(!CollectionUtils.isEmpty(configRespVOS)){
                Map<String, List<InvDespatchConfigRespVO>> map = configRespVOS.stream().collect(Collectors.groupingBy(InvDespatchConfigRespVO::getDesCode));
                records.forEach( i ->{
                    if(map.containsKey(i.getDesCode())){
                        i.setDeter2Count(map.get(i.getDesCode()).get(0).getDeter2Count());
                    }
                });
            }

            records.forEach( i ->{
                if(ouMap.containsKey(i.getDeter1())){
                    i.setDeter1Name(ouMap.get(i.getDeter1()).getOuName());
                }
            });
        }
        return PagingVO.<InvDespatchConfigPageVO>builder()
                .total(page.getTotal())
                .records(records)
                .build();
    }

    @Override
    @Transactional
    public Long saveOrUpdate(InvDespatchConfigSaveVO createParam) {
        verifyParam(createParam);
        InvDespatchConfigDTO despatchConfigDTO;
        if(Objects.nonNull(createParam.getId())){
            val ret = invDespatchConfigDomainService.findIdOne(createParam.getId());
            if(ret == null){
                throw new BusinessException(ApiCode.FAIL,"数据不存在");
            }
            BeanCopyUtil.beanCopyWithIngore(createParam,ret,BeanCopyUtil.getNullPropertyNames(createParam));
            despatchConfigDTO = ret;
        }else{
            despatchConfigDTO = InvDespatchConfigConvert.INSTANCE.saveVoToDto(createParam);
        }
        return invDespatchConfigDomainService.saveOrUpdate(despatchConfigDTO);
    }

    private void verifyParam(InvDespatchConfigSaveVO createParam) {
        List<InvDespatchRpcDTO> despatchRpcDTOS = invDespatchConfigDomainService.findByDesName(createParam.getDesName());
        if(!CollectionUtils.isEmpty(despatchRpcDTOS)){
            long count = despatchRpcDTOS.stream().filter(i -> !i.getId().equals(createParam.getId())).count();
            if(count > 0){
                throw new BusinessException(ApiCode.FAIL,"已存在相同的名称，不能重复");
            }
        }
        List<InvDespatchRpcDTO> byDesCode = invDespatchConfigDomainService.findByDesCode(createParam.getDesCode());
        if(!CollectionUtils.isEmpty(byDesCode)){
            long count = byDesCode.stream().filter(i -> !i.getId().equals(createParam.getId())).count();
            if(count > 0){
                throw new BusinessException(ApiCode.FAIL,"已存在相同的编码，不能重复");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(createParam.getDeter1())){
            throw new BusinessException(ApiCode.FAIL,"所属公司编码为空");
        }
        if (Objects.isNull(createParam.getTradeCompanyFlag())){
            throw new BusinessException(ApiCode.FAIL,"贸易公司白名单为空");
        }
    }

    @Override
    public InvDespatchConfigRespVO findIdOne(Long id) {
        val configDTO = invDespatchConfigDomainService.findIdOne(id);
        InvDespatchConfigRespVO invDespatchConfigRespVO = InvDespatchConfigConvert.INSTANCE.dtoToVo(configDTO);
        if (Objects.nonNull(invDespatchConfigRespVO)){
            if (org.apache.commons.lang3.StringUtils.isNotBlank(invDespatchConfigRespVO.getDeter1())){
                OrgOuRpcDTO orgOuRpcDTO = orgOutService.findOuByOuCode(invDespatchConfigRespVO.getDeter1());
                if (Objects.nonNull(orgOuRpcDTO)){
                    invDespatchConfigRespVO.setDeter1Name(orgOuRpcDTO.getOuName());
                }
            }

        }
        return invDespatchConfigRespVO;
    }

    @Override
    public PagingVO<InvDespatchConfigWhPageVO> searchDtlPage(InvDespatchConfigDtlQueryParam param) {
        PagingVO<InvDespatchConfigWhPageVO> pagingVO = invDespatchConfigDomainService.searchDespatchWhPage(param);
        if(!CollectionUtils.isEmpty(pagingVO.getRecords())){
            translateWhPageVO(pagingVO.getRecords());
        }
        return pagingVO;
    }

    @Override
    public Boolean enableDespatchConfig(List<Long> id, String isEnable) {
        return invDespatchConfigDomainService.enableDespatchConfig(id,isEnable);
    }

    @Override
    public List<SelectOptionVO> listDespatchConfig(SelectOptionParam selectOptionParam) {
        return invDespatchConfigProc.listDespatchConfig(selectOptionParam);
    }

    private void translateWhPageVO(List<InvDespatchConfigWhPageVO> invDespatchConfigWhPageVOS){
        List<Long> ouIds = invDespatchConfigWhPageVOS.stream()
                .map(InvDespatchConfigWhPageVO::getOuId)
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());
        List<OrgOuRpcDTO> ouRpcDTOS = orgOutService.findOuByIds(ouIds);
        List<String> deter2Types = invDespatchConfigWhPageVOS.stream()
                .map(InvDespatchConfigWhPageVO::getDeter2Type)
                .filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhAreaSettingRespVO> whAreaSettingRespVOS = invWhAreaSettingService.findByDeter2Types(deter2Types);
        Map<Long, List<OrgOuRpcDTO>> ouMap = null;
        if(!CollectionUtils.isEmpty(ouRpcDTOS)){
            ouMap = ouRpcDTOS.stream().collect(Collectors.groupingBy(OrgOuRpcDTO::getId));
        }
        Map<Long, List<OrgOuRpcDTO>> finalOuMap = ouMap;
        invDespatchConfigWhPageVOS.forEach(i ->{
            if(!CollectionUtils.isEmpty(whAreaSettingRespVOS)){
               whAreaSettingRespVOS.stream().filter(w -> w.getDeter2Type().equals(i.getDeter2Type()))
                       .findAny().ifPresent(m ->{
                           i.setDeter2TypeName(m.getDeter2TypeName());
               });
            }
            if(finalOuMap != null && finalOuMap.containsKey(i.getOuId())){
                i.setOuName(finalOuMap.get(i.getOuId()).get(0).getOuName());
            }
        });
    }
}
