package com.elitesland.yst.production.inv.application.service.impl;


import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespDVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotAllRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCombineParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvStkDParam;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.PurDubbleService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import com.elitesland.yst.production.inv.domain.convert.InvLotConvert;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLot;
import com.elitesland.yst.production.inv.domain.entity.lot.InvLotDO;
import com.elitesland.yst.production.inv.domain.service.InvLotDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvLotDTO;
import com.elitesland.yst.production.inv.infr.repo.lot.InvLotRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;


/**
 * <p>
 * 批次主档
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 15:08:00
 */
@Service("invLotService")
@AllArgsConstructor
public class InvLotServiceImpl implements InvLotService {
    private final InvLotDomainService invLotDomainService;

    private final InvLotRepo invLotRepo;

    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final PurDubbleService purDubbleService;

    @Override
    @SysCodeProc
    public PagingVO<InvLotRespVO> search(InvLotParam param) {
        val pagingVo = invLotDomainService.invLotSearch(param);
        if (CollectionUtils.isEmpty(pagingVo.getRecords())) {
            return PagingVO.<InvLotRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        val vos = pagingVo.getRecords();
        List<InvLotRespVO> invLotRespVOList = vos.stream().map(
                InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());

        return PagingVO.<InvLotRespVO>builder()
                .total(pagingVo.getTotal())
                .records(invLotRespVOList)
                .build();
    }

    @Override
    public List<String> findLotNoByManuLot(String manuLot) {
        List<String> lotNos = invLotRepo.findByMenuLotNo(manuLot);
        return lotNos;
    }

   /* @Override
    @SysCodeProc
    public Optional<InvLotRespVO> findCodeOne(String key) {
        InvLotRespVO vo = invLotRepoProc.select(null).fetchOne();
        return Optional.ofNullable(vo);
    }*/


    @Override
    @SysCodeProc
    public ApiResult<InvLotRespVO> findLotById(Long id) {
        val invLotDTOOptional = this.findIdOne(id);
        if (invLotDTOOptional.isEmpty()) {
            return ApiResult.fail("批次信息数据不存在");
        }
        return ApiResult.ok(invLotDTOOptional.get());
    }

    @Override
    @SysCodeProc
    public Optional<InvLotRespVO> findIdOne(Long id) {
        val invLotDTOOptional = invLotDomainService.findById(id);
        if (invLotDTOOptional.isEmpty()) {
            return Optional.empty();
        }
        InvLotDTO invLotDTO = invLotDTOOptional.get();
        InvLotRespVO invLotRespVO = InvLotConvert.INSTANCE.dtoToRespVo(invLotDTO);

        this.fillUpNameList(List.of(invLotRespVO));

        return Optional.of(invLotRespVO);
    }

    @Override
    @SysCodeProc
    public List<InvLotRespVO> findIdBatch(List<Long> idList) {
        //根据id批量查询
        List<InvLotDTO> invLotDTOList = invLotDomainService.findIdBatch(idList);
        List<InvLotRespVO> invLotRespVOList = invLotDTOList.stream().map(
                InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());

        return invLotRespVOList;
    }


    /**
     * Bug: Nullpointer Exception when invLotRepo query returns a null value.
     * Fix: Filtered null InvLotDO instances from being collected into the list.
     *
     * @Author: Alvy Yin
     * @Date 2020-9-15 15:00
     */
    @Override
    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNo(List<String> itmIdNo) {
        List<InvLotDTO> invLotDTOS = new ArrayList<>();
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            /** 2021-04-23 和需求确定，库存批次可以为空，不需要校验 **/
            if (split.length == 0) {
                throw new BusinessException(ApiCode.FAIL, "操作失败，数据错误,商品不存在");
            }
            if (split.length == 2) {
                List<InvLotDTO> invLotDTOList = invLotDomainService.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
                if (invLotDTOList != null && invLotDTOList.size() == 1) {
                    invLotDTOS.add(invLotDTOList.get(0));
                }
            }
        }
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvLotRespVO> findListByAndItemIdAndLotNo(List<String> itmIdNo) {
        List<InvLotDTO> invLotDTOS = new ArrayList<>();
        if (CollectionUtils.isEmpty(itmIdNo)) {
            return Lists.newArrayList();
        }
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            if (split.length != 2) {
                throw new BusinessException(ApiCode.FAIL, "操作失败，数据错误");
            }
            // List<InvLotDO> invo = invLotRepo.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
            List<InvLotDTO> invLotDTOList = invLotDomainService.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);

            if (!CollectionUtils.isEmpty(invLotDTOList)) {
                invLotDTOS.add(invLotDTOList.get(0));
            }
        }
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
    }

    /**
     * 修改方法提前说声避免你抛出异常我一条数据 都拿不到
     *
     * @param itmIdNo
     * @return
     */
    @Override
    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNo2(List<String> itmIdNo) {
        List<InvLotDTO> invLotDTOS = new ArrayList<>();
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
            // List<InvLotDO> invo = invLotRepo.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);
            List<InvLotDTO> invLotDTOList = invLotDomainService.findAllByItemIdAndLotNo(Long.valueOf(split[0]), split[1]);

            if (invLotDTOList != null && invLotDTOList.size() == 1) {
                invLotDTOS.add(invLotDTOList.get(0));
            }
        }
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
    }

    /**
     * v.getItemId() + "_" + v.getVariId()+"_"+v.getLotNo()
     *
     * @param itmIdNo
     * @return
     */
    @Override
    @SysCodeProc
    public List<InvLotRespVO> findByAndItemIdAndLotNoList(List<String> itmIdNo) {
        List<InvLotRespVO> invLotRespVOList = new ArrayList<>();
        for (String itmid : itmIdNo) {
            String[] split = itmid.split("_");
//            if(split.length!=2) throw new BusinessException(ApiCode.FAIL,"操作失败，数据错误");
//            if(Long.valueOf(split[0])!=null&&Long.valueOf(split[0])!=0&& split[2]!=null){

            InvLotParam param = new InvLotParam();
            if (split.length == 3) {
                if (!("null").equals(split[0])) {
                    param.setItemId(Long.valueOf(split[0]));
                }
                if (!("null").equals(split[1])) {
                    param.setVariId(Long.valueOf(split[1]));
                }
                if (!("null").equals(split[2])) {
                    param.setLotNo(split[2]);
                }
                // List<InvLotRespVO> invo = invLotRepoProc.findAllByItemIdAndLotNoAndVariId(param).fetch();
                List<InvLotDTO> invLotDTOList = invLotDomainService.findAllByItemIdAndLotNoAndVariId(param);
                if (invLotDTOList != null && invLotDTOList.size() > 0) {
                    InvLotRespVO invLotRespVO = InvLotConvert.INSTANCE.dtoToRespVo(invLotDTOList.get(0));
                    invLotRespVOList.add(invLotRespVO);
                }
            }
        }
        return invLotRespVOList;
    }


    @Override
    @Transactional
    public Long createOne(InvLotSaveVO invLotSaveVO) {
        InvLot invLot = InvLotConvert.INSTANCE.saveVoToEn(invLotSaveVO);
        // return invLotRepo.save(InvLotConvert.INSTANCE.voToSaveDO(invLotSaveVO)).getId();
        return invLotDomainService.createOne(invLot);
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvLotSaveVO> list) {
        List<InvLot> invLots = list.stream().map(InvLotConvert.INSTANCE::saveVoToEn).collect(Collectors.toList());
        // return invLotRepo.saveAll(invLots).stream().map(InvLotDO::getId).collect(Collectors.toList());
        return invLotDomainService.createBatch(invLots);
    }

    @Override
    @Transactional
    public void update(InvLotSaveVO saveVO) {
        //  Optional<InvLotDO> optional = invLotRepo.findById(saveVO.getId());
        Optional<InvLotDTO> optional = invLotDomainService.findById(saveVO.getId());
        if (optional.isPresent()) {
            InvLot invLot = InvLotConvert.INSTANCE.saveVoToEn(saveVO);
            // invLotRepo.save(InvLotConvert.INSTANCE.voToSaveDO(saveVO));
            invLotDomainService.createOne(invLot);
        } else {
            throw new BusinessException(ApiCode.FAIL, "操作失败，数据不存在" + saveVO.getId());
        }
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
      /*  val jpaQDo = invLotDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        Optional<InvLotDO> optionalItem = invLotRepo.findOne(predicate);*/
        Optional<InvLotDTO> optional = invLotDomainService.findById(id);
        if (optional.isPresent()) {
          /*  InvLotDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            invLotRepo.save(do1);*/
            invLotDomainService.updateDeleteFlagById(1, id);
        } else {
            throw new BusinessException(ApiCode.FAIL, "操作失败，数据不存在" + id);
        }
    }

    @Override
    public List<InvLotRespVO> findByQueryParam(List<String> queryParam) {
        List<InvLotDO> invLotDTOS = invLotDomainService.findByQueryParam(queryParam);
        return invLotDTOS.stream().map(InvLotConvert.INSTANCE::doToRespVO).collect(Collectors.toList());
    }


    @Override
    @Transactional
    public void deleteOne(Long id) {


      /*  val jpaQDo = invLotDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        Optional<InvLotDO> optionalItem = invLotRepo.findOne(predicate);*/
        Optional<InvLotDTO> optional = invLotDomainService.findById(id);
        if (optional.isPresent()) {
            //  this.invLotRepo.deleteById(id);
            invLotDomainService.deleteById(id);
        } else {
            throw new BusinessException(ApiCode.FAIL, "操作失败，数据不存在" + id);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {

        list.forEach(id -> invLotDomainService.deleteById(id));
    }

    @Override
    public Optional<InvLotAllRespVO> findInvLotAllOne(Long id) {
        val invLotDTOOptional = this.findIdOne(id);
        if (invLotDTOOptional.isEmpty()) {
            return Optional.empty();
        }
        InvLotRespVO invLotRespVO = invLotDTOOptional.get();

        this.fillUpNameList(List.of(invLotRespVO));


        InvLotAllRespVO invLotAllRespVO = InvLotConvert.INSTANCE.voToAllVo(invLotRespVO);

        return Optional.of(invLotAllRespVO);
    }

    @Override
    @SysCodeProc
    public PagingVO<InvLotRespVO> findCombine(InvLotCombineParam param) {
        val pagingVo = invLotDomainService.findCombine(param);
        if (CollectionUtils.isEmpty(pagingVo.getRecords())) {
            return PagingVO.<InvLotRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        val records = pagingVo.getRecords().stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());


        this.fillUpNameList(records);
        return PagingVO.<InvLotRespVO>builder()
                .total(pagingVo.getTotal())
                .records(records)
                .build();
    }


    @Override
    public List<InvLotRespVO> findByParams(InvLotParam queryParam) {
        //return invLotRepoProc.select(null).where(invLotRepoProc.where(queryParam)).fetch();
        List<InvLotDTO> invLotDTOList = invLotDomainService.findByParam(queryParam);
        List<InvLotRespVO> invLotRespVOList = invLotDTOList.stream().map(InvLotConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());

        return invLotRespVOList;
    }

    @Override
    public void addSinQty(String lotNo, Long itemId, Double sinQty, String sinStatus, String sinNo) {
        // invLotRepo.addSinQty(lotNo, itemId, sinQty, sinStatus, sinNo);
        invLotDomainService.addSinQty(lotNo, itemId, sinQty, sinStatus, sinNo);
    }

    /**
     * 批次主档关联库存余额
     *
     * @param param
     * @return
     */
    @Override
    @SysCodeProc
    public PagingVO<InvStkRespDVO> searchD(InvStkDParam param) {
        //调用封装方法，返回封装jpaQuery
        // PagingVO pagingVO = invLotRepoProc.useSelectD(param);
        val pagingVO = invLotDomainService.useSelectD(param);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<InvStkRespDVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        val vos = pagingVO.getRecords();
        List<InvStkRespDVO> invStkDResults = vos.stream().map(
                InvLotConvert.INSTANCE::lsDtoToRespVo).collect(Collectors.toList());


        //List<InvStkRespDVO> invStkDResults = pagingVO.getRecords();
        //应对前端参数为空情况
        val orgWhResults = invWhDomainService.findIdBatch(invStkDResults.stream().map(InvStkRespDVO::getWhId).collect(Collectors.toList()));
        //：更据商品id list 查找对应的商品 - 外部数据
        List<Long> itemIds = invStkDResults.stream().map(InvStkRespDVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmParam = new ItmItemRpcDtoParam();
        itmParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemDTOS = itmOutService.findItemRpcDtoByParam(itmParam);
        //：更据公司id list 查找对应的公司 - 外部数据
        val orgOuResults = outouService.findOuByIds(orgWhResults.stream().map(InvWhRespVO::getOuId).filter(Objects::nonNull).collect(Collectors.toList()));
        //：更据品项 list 查找对应的包装 - 外部数据
        //TODO
        //  val invItmPkgResults = invItemPkgService.findByItemIdIn(invStkDResults.stream().map(InvStkRespDVO::getItemId).collect(Collectors.toList()));
        //：更据品牌brand,类型 list 查找对应的公司 - 外部数据
//        val c2VOs=comC2Service.findByC2CodeListAndC13Type(itmItemResults.stream().map(ItmItemVO::getBrand).collect(Collectors.toList()), "BRAND");
        //TODO
        // List<ComC2VO> c2VOs = Collections.emptyList();
        //填入数据
        invStkDResults.stream().forEach(i -> {
            orgWhResults.stream().filter(v -> v.getId().equals(i.getWhId()))
                    .findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
            });
            if (!CollectionUtils.isEmpty(itmItemDTOS)) {
                itmItemDTOS.stream().filter(v -> v.getItemCode().equals(i.getItemCode()))
                        .findAny().ifPresent(m -> {
                    i.setItemCode(m.getItemCode());
                    i.setItemName(m.getItemName());
                    i.setBrand(m.getBrand());
                    i.setPackageSpec(m.getPackageSpec());
                    i.setStoreExpireDays(m.getGuaranteeDays());
//                    i.setAgency(m.getAgency());
//                    i.setItemType3(m.getItemType3());
//                    i.setEn1(m.getEn1());
                    //  i.setC2Name(c2VOs.stream().filter(v -> v.getC2Code().equals(i.getBrand())).findAny().map(ComC2VO::getC2Name).orElse(null));
                    i.setBrandName(m.getBrandName());

                    i.setVolume(m.getVolume() == null ? null : m.getVolume().doubleValue());
                    i.setGrossWeight(m.getGrossWeight() == null ? null : m.getGrossWeight().doubleValue());
                    i.setNetWeight(m.getNetWeight() == null ? null : m.getNetWeight().doubleValue());

                    i.setTVolume(i.getOhQty() == null || m.getVolume() == null ? null : i.getOhQty().doubleValue() * m.getVolume().doubleValue());
                    i.setTGrossWeight(i.getOhQty() == null || m.getGrossWeight() == null ? null : i.getOhQty().doubleValue() * m.getGrossWeight().doubleValue());
                    i.setTNetWeight(i.getOhQty() == null || m.getNetWeight() == null ? null : i.getOhQty().doubleValue() * m.getNetWeight().doubleValue());
//                    i.setTAvalQty(i.getAvalQty() == null || m.getEn1() == null ? null : i.getAvalQty() / m.getEn1());
//                    i.setTOhQty(i.getOhQty() == null || m.getEn1() == null ? null : i.getOhQty() / m.getEn1());
//                    i.setTRsvQty(i.getRsvQty() == null || m.getEn1() == null ? null : i.getRsvQty() / m.getEn1());
                });
            }
            if (!CollectionUtils.isEmpty(orgOuResults)) {
                orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId()))
                        .findAny().ifPresent(m -> {
                    i.setOuCode(m.getOuCode());
                    i.setOuName(m.getOuName());
                });
            }
            //TODO
           /* if (!CollectionUtils.isEmpty(invItmPkgResults)) {
                invItmPkgResults.stream().filter(v -> v.getItemId().equals(i.getItemId()) && v.getPkgType().equals("SMALL"))
                        .findAny().ifPresent(m -> {
                    i.setPkgGrossWeight(m.getGrossWeight());
                    i.setPkgHeight(m.getDimHeight());
                    i.setPkgLength(m.getDimLen());
                    i.setPkgWidth(m.getDimWeight());
                    if (i.getOhQty() != null && m.getGrossWeight() != null) {
                        i.setStkWeight(i.getOhQty().doubleValue() * m.getGrossWeight());
                    }
                    if (i.getOhQty() != null && m.getVolume() != null) {
                        i.setStkVolume(i.getOhQty().doubleValue() * m.getVolume());
                    }
                });
            }*/
            val orgWhAreaVo = invWhAreaDomainService.findByWhIdAndWhArea(i.getWhId(), i.getWhArea());
            if (orgWhAreaVo != null) {
                i.setOuterCode(orgWhAreaVo.getOuterCode());
            }
        });
        invStkDResults.stream().forEach(i -> {
            if (i.getManuDate() == null) {
                i.setManuDate(LocalDateTime.now());
            }
        });

        invStkDResults = invStkDResults.stream().sorted(Comparator.comparing(InvStkRespDVO::getManuDate)).collect(Collectors.toList());

        return PagingVO.<InvStkRespDVO>builder()
                .total(pagingVO.getTotal())
                .records(invStkDResults)
                .build();
    }

    /**
     * 填充反查数据
     *
     * @param vos 查询结果
     */
    public void fillUpNameList(List<InvLotRespVO> vos) {
        List<Long> itemIds = vos.stream().map(InvLotRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> suppIds = vos.stream().map(InvLotRespVO::getSuppId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> ouIds = vos.stream().map(InvLotRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, String> docClsMap = systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_STKAJ.getModel(), UdcEnum.COM_DOC_CLS_STKAJ.getCode());
        List<OrgOuRpcDTO> orgOuVOS = outouService.findOuByIds(ouIds);
        // 通过商品ID列表批量查询商品
        ItmItemRpcDtoParam itmParam = new ItmItemRpcDtoParam();
        itmParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itemPartDTOS = itmOutService.findItemRpcDtoByParam(itmParam);
        // 通过采购订单ID 查询采购订单表
        List<PurSuppBaseRpcDTO> purSuppBaseRpcDTOS = purDubbleService.findSuppByIdBatch(suppIds);
        // 渲染数据
        vos.forEach(vo -> {
            if(!docClsMap.isEmpty()){
                if(docClsMap.containsKey(vo.getSrcDocCls())){
                    vo.setSrcDocClsName(docClsMap.get(vo.getSrcDocCls()));
                }
            }
            if (!CollectionUtils.isEmpty(orgOuVOS)) {
                Optional<OrgOuRpcDTO> orgOuVO = orgOuVOS.stream().filter(v -> v.getId().equals(vo.getOuId())).findFirst();
                if (orgOuVO.isPresent()) {
                    OrgOuRpcDTO ouVO = orgOuVO.get();
                    vo.setOuName(ouVO.getOuName());
                    vo.setOuCode(ouVO.getOuCode());
                }
            }

            if (!CollectionUtils.isEmpty(purSuppBaseRpcDTOS)) {
                Optional<PurSuppBaseRpcDTO> suppOptional = purSuppBaseRpcDTOS.stream().filter(v -> v.getId().equals(vo.getSuppId())).findFirst();
                if (suppOptional.isPresent()) {
                    PurSuppBaseRpcDTO suppBaseRpcDTO = suppOptional.get();
                    vo.setSuppCode(suppBaseRpcDTO.getSuppCode());
                    vo.setSuppName(suppBaseRpcDTO.getSuppName());
                }
            }

            if (!CollectionUtils.isEmpty(itemPartDTOS)) {
                Optional<ItmItemRpcDTO> itmItemVO = itemPartDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst();
                if (itmItemVO.isPresent()) {
                    ItmItemRpcDTO itemVO = itmItemVO.get();
                    vo.setItemCode(itemVO.getItemCode());
                    vo.setItemName(itemVO.getItemName());
                }
            }
        });
    }
}
