package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.yst.production.inv.application.out.OrgBuOutService;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.application.facade.export.invwh.InvWhAreaImport;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.*;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.repo.InvWhDeliveryRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.*;
import com.elitesland.yst.production.inv.infr.repo.whAreaSetting.InvWhAreaSettingRepo;
import com.elitesland.yst.production.inv.utils.InvStringUtil;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.invwh.InvWhDeliveryFlagEnum;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.support.provider.org.dto.*;
import com.elitesland.yst.production.support.provider.org.param.*;
import com.google.common.collect.Lists;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;

import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-01-29 14:00:10
 */
@SuppressWarnings("ALL")
@Service("invWhService")
@AllArgsConstructor
@Slf4j
public class InvWhServiceImpl implements InvWhService {

    private final SystemService systemService;
    private final InvWhRepoProc invWhRepoProc;
    private final InvWhRepo invWhRepo;
    private final InvWhAreaService invWhAreaService;
    private final InvWhAreaRepoProc invWhAreaRepoProc;
    private final InvWhDeliveryProc invWhDeliveryProc;
    private final InvWhDeliveryRepo invWhDeliveryRepo;
    private final InvWhDeliveryService invWhDeliveryService;
    private final InvWhAreaSettingService invWhAreaSettingService;
    private final InvWhAreaSettingRepo invWhAreaSettingRepo;
    private final InvWhAreaRepo invWhAreaRepo;
    private final NumSenderService numSenderService;
    private final OrgOutService orgOutService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final Integer TUIHUOFLAG = 1;
    private final InvWhAreaSettingDomainService invWhAreaSettingDomainService;
    private final OrgBuOutService orgBuOutService;
    private final InvDespatchConfigDomainService invDespatchConfigDomainService;

    @Override
    public PagingVO<InvWhAreaRespVO> searchWhArea(InvWhAreaParamVO param) {

        //查询仓库主表
        InvWhParamVO whQueryParam = new InvWhParamVO();
        whQueryParam.setKeyword(param.getKeyword());
        whQueryParam.setWhCode(param.getWhCode());
        whQueryParam.setWhName(param.getWhName());
        whQueryParam.setOtherWhCode(param.getOtherWhCode());
        whQueryParam.setOtherWhType(param.getOtherWhType());
        whQueryParam.setOuId(param.getOuId());
        whQueryParam.setBelongBuId(param.getBelongBuId());
        whQueryParam.setId(param.getId());
        whQueryParam.setBusinessCode(param.getBusinessCode());
        /** 仓库类别**/
        whQueryParam.setWhTypes(param.getWhTypes());
        whQueryParam.setMultiKeywords(param.getMultiKeywords());
        whQueryParam.setWhType(param.getWhType());
        whQueryParam.setWhType2(param.getWhType2());
        whQueryParam.setWhStatus(param.getWhStatus());
        whQueryParam.setDesCode(param.getDesCode());
        whQueryParam.setDesCodeList(param.getDesCodeList());
        //查询表头
        PagingVO<InvWhRespVO> orgWhVOPagingVO = invWhAreaService.searchWh(whQueryParam);
        List<InvWhRespVO> invWhRespVOList = orgWhVOPagingVO.getRecords();
        if (CollectionUtils.isEmpty(invWhRespVOList)) {
            return PagingVO.<InvWhAreaRespVO>builder()
                    .total(0L)
                    .records(new ArrayList<>())
                    .build();
        }
        //查询库区
        List<Long> whIds = invWhRespVOList.stream().map(InvWhRespVO::getId)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        param.setWhIds(whIds);//获得关联ID
        if (param.getSize() == null && param.getCurrent() == null) {
            param.setSize(1000);
        }
        PagingVO<InvWhAreaRespVO> search = invWhAreaService.search(param);
        List<InvWhAreaRespVO> invWhAreaRespVOS = search.getRecords();
        this.translateWh(invWhRespVOList);
        this.translateWhArea(invWhAreaRespVOS, invWhRespVOList);
        return search;
    }

    /**
     * 功能描述  批量创建仓库
     *
     * @param invWhSaveVOS
     * @return java.util.List<java.lang.Long>
     * @author Brian.lai
     * @date 2021/7/24
     */
    @Transactional
    public List<Long> createWhBatch(List<InvWhSaveVO> invWhSaveVOS) {

        //用于批量保存InvWhDO
        List<InvWhDO> whDOList = new ArrayList<>();
        //用于批量保存InvWhAreaDO
        List<InvWhAreaSaveVO> invWhAreaVOS = new ArrayList<>();
        invWhSaveVOS.forEach(v -> {
            //功能区唯一校验
            if (!CollectionUtils.isEmpty(v.getOrgWhAreaCreateParamList())) {
                long count = v.getOrgWhAreaCreateParamList().stream()
                        .map(i -> i.getDeter2() + "_" + i.getPType() + "_" + i.getPCode()).distinct().count();
                if (count != v.getOrgWhAreaCreateParamList().size()) {
                    throw new BusinessException(ApiCode.FAIL, "同一仓库同一库存合作伙伴，功能区不能重复，请检查！");
                }
            }
            InvWhDO invWhDO = BeanUtil.copyProperties(v, InvWhDO.class);
            Long addrNo = saveAddressAndQualifyAndBankAcc(false, null, v);
            invWhDO.setAddrNo(addrNo);
            invWhDO.setCreateTime(LocalDateTime.now());
            whDOList.add(invWhDO);
        });
        //批量保存InvWhDO
        List<InvWhDO> invWhDOS = invWhRepo.saveAll(whDOList);
        //开始构建InvWhArea
        invWhSaveVOS.forEach(v -> {
            invWhDOS.forEach(v2 -> {
                if (v2.getWhCode().equals(v.getWhCode())) {
                    List<InvWhAreaSaveVO> invWhAreaSaveVOS = v.getOrgWhAreaCreateParamList().stream().map(invWhAreaSaveVO -> {
                        invWhAreaSaveVO.setWhId(v2.getId());
                        invWhAreaSaveVO.setCreateTime(LocalDateTime.now());
                        invWhAreaSaveVO.setDeter3(invWhAreaSaveVO.getPCode());
                        return invWhAreaSaveVO;
                    }).collect(Collectors.toList());
                    invWhAreaVOS.addAll(invWhAreaSaveVOS);
                }
            });
        });
        //批量插入InvWhArrea
        invWhAreaService.createBatch(invWhAreaVOS);
        return invWhDOS.stream().map(v -> v.getId()).collect(Collectors.toList());
    }

    @Override
    public PagingVO<InvWhAreaRespVO> listWhArea(InvWhAreaParamVO param) {
        if (param.getWhCode() != null || param.getWhName() != null
                || param.getWhType() != null || param.getOuId() != null
                || param.getWhStatus() != null || StringUtils.isNotBlank(param.getDesCode())
                || CollectionUtil.isNotEmpty(param.getDesCodeList())) {
            InvWhParamVO whQueryParam = new InvWhParamVO();
            whQueryParam.setWhCode(param.getWhCode());
            whQueryParam.setWhName(param.getWhName());
            whQueryParam.setOuId(param.getOuId());
            whQueryParam.setBelongBuId(param.getBelongBuId());
            /** 仓库类别**/
            whQueryParam.setWhTypes(param.getWhTypes());
            whQueryParam.setMultiKeywords(param.getMultiKeywords());
            whQueryParam.setWhType(param.getWhType());
            whQueryParam.setWhStatus(param.getWhStatus());
            whQueryParam.setDesCode(param.getDesCode());
            whQueryParam.setDesCodeList(param.getDesCodeList());
            List<InvWhRespVO> invWhRespVOList = invWhAreaService.searchWhByParam(whQueryParam);
            List<Long> whIds = invWhRespVOList.stream().map(InvWhRespVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(whIds)) {
                return PagingVO.<InvWhAreaRespVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            }
            param.setWhIds(whIds);
        }
        PagingVO<InvWhAreaRespVO> search = invWhAreaDomainService.searchPaging(param);
        List<InvWhAreaRespVO> invWhAreaRespVOS = search.getRecords();
        if (!CollectionUtils.isEmpty(invWhAreaRespVOS)) {
            List<Long> whIds2 = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            param.setWhIds(whIds2);
            List<InvWhRespVO> whRespVOS = invWhDomainService.findByWhIds(whIds2);
            this.translateWh(whRespVOS);
            this.translateWhArea(invWhAreaRespVOS, whRespVOS);

        }
        return search;
    }

    @Override
    @Transactional
    public Long createWh(InvWhSaveVO invWhSaveVO) {
        //库区校验
        this.verifyWhareas(invWhSaveVO.getOrgWhAreaCreateParamList(), invWhSaveVO);
        Long id = invWhSaveVO.getId();
        val runtimeValues = new ArrayList<>();
        if (invWhSaveVO.getOuCode() == null) {
            throw new BusinessException(ApiCode.FAIL, "参数有误，公司编码为空，请检查");
        }
        //发号器校验
        if (id == null) {
            String whcode = this.getIncrForWhcode(invWhSaveVO);
            invWhSaveVO.setWhCode(whcode);
            while (this.existVerify(id, invWhSaveVO.getWhCode())) {
                String whCode = this.getIncrForWhcode(invWhSaveVO);
                invWhSaveVO.setWhCode(whCode);
            }
        }
        //检验类型数据库里以逗号分隔的字符串形式保存
        if (!CollectionUtils.isEmpty(invWhSaveVO.getDesCodeList())) {
            String codeString = InvStringUtil.transitionCodesToStr(invWhSaveVO.getDesCodeList());
            invWhSaveVO.setDesCode(codeString);
        }

        InvWhDO invWhDO = BeanUtil.copyProperties(invWhSaveVO, InvWhDO.class);
        //如果仓库存在更新主表、全删全插子表
        Optional<InvWhDO> optional = Optional.empty();
        if (id != null) {
            optional = invWhRepo.findById(id);
        }
        if (optional.isPresent()) {
            saveAddressAndQualifyAndBankAcc(true, optional.get().getAddrNo(), invWhSaveVO);
            //根据仓库ID删除功能库区
            invWhAreaDomainService.deleteByWhId(id);
            //删除仓库配送范围
            invWhDeliveryRepo.deleteByWhId(id);
            //修改仓库组织
            if (optional.get().getSecBuId() != null) {
                invWhSaveVO.setSecBuId(optional.get().getSecBuId());
//                OrgBuRpcSaveParam saveParam = this.orgBuRpcSaveOrUpdate(invWhSaveVO, optional.get().getAddrNo(), false);
//                OrgBuRpcSaveResult orgBuRpcSaveResult = orgOutService.orgBuRpcSaveOrUpdate(saveParam);
            }
            invWhDO.setSecBuId(optional.get().getSecBuId());
            invWhDO.setSecUserId(optional.get().getSecUserId());
            //sec_ou_id 默认是仓库ouId
            invWhDO.setSecOuId(optional.get().getOuId());
            invWhDO.setRelateOuId(optional.get().getRelateOuId());
            this.update(invWhDO);
        } else {
            Long addrNo = saveAddressAndQualifyAndBankAcc(false, null, invWhSaveVO);
            invWhDO.setAddrNo(addrNo);
            invWhDO.setCreateTime(LocalDateTime.now());
            // 保存仓库组织信息
//            OrgBuRpcSaveParam saveParam = this.orgBuRpcSaveOrUpdate(invWhSaveVO, addrNo, true);
//            OrgBuRpcSaveResult orgBuRpcSaveResult = orgOutService.orgBuRpcSaveOrUpdate(saveParam);
            //数据权限
//            invWhDO.setSecBuId(orgBuRpcSaveResult.getBuId());
            invWhDO.setAddrNo(addrNo);
            invWhDO.setCreateTime(LocalDateTime.now());
            invWhDO.setSecUserId(invWhSaveVO.getSecUserId());
            invWhDO.setSecOuId(invWhSaveVO.getOuId());
            id = invWhRepo.save(invWhDO).getId();

        }
        //创建库区信息
        Long finalId = id;
        List<InvWhAreaSaveVO> invWhAreaSaveVOS = getInvWhAreaSaveVOS(invWhSaveVO, invWhDO, finalId);
        /**
         * 按产品要求去掉默认创建在途库区逻辑
         * 指定默认功能区
         */
//        setDefaultDeter2(invWhSaveVO, invWhDO, finalId, invWhAreaSaveVOS);
        invWhAreaService.createBatch(invWhAreaSaveVOS);
        //地址范围处理
        if (!CollectionUtils.isEmpty(invWhSaveVO.getDeliveryAreas()) && invWhSaveVO.getDeliveryAreas().size() > 0) {
            //全国范围处理
            if (invWhSaveVO.getDeliveryAreas().get(0).getAllArea() != null
                    && invWhSaveVO.getDeliveryAreas().get(0).getAllArea().equals(InvWhDeliveryFlagEnum.C1.getCode())) {
                InvWhDeliverySaveVO invWhDeliverySaveVO = invWhSaveVO.getDeliveryAreas().get(0);
                invWhDeliverySaveVO.setWhId(finalId);
                invWhDeliverySaveVO.setOuId(invWhSaveVO.getOuId());
                invWhDeliverySaveVO.setBuId(invWhDO.getBuId());
                invWhDeliveryService.createOne(invWhDeliverySaveVO);
            } else {
                List<InvWhDeliverySaveVO> deliverySaveVOS = invWhSaveVO.getDeliveryAreas().stream().map(invWhDeliverySaveVO -> {
                    invWhDeliverySaveVO.setWhId(finalId);
                    invWhDeliverySaveVO.setOuId(invWhSaveVO.getOuId());
                    invWhDeliverySaveVO.setBuId(invWhDO.getSecBuId());
                    return invWhDeliverySaveVO;
                }).collect(Collectors.toList());
                invWhDeliveryService.createBatch(deliverySaveVOS);
            }
        }
        return id;
    }

    private List<InvWhAreaSaveVO> getInvWhAreaSaveVOS(InvWhSaveVO invWhSaveVO, InvWhDO invWhDO, Long finalId) {
        List<InvWhAreaSaveVO> invWhAreaSaveVOS = invWhSaveVO.getOrgWhAreaCreateParamList().stream().map(invWhAreaSaveVO -> {
            invWhAreaSaveVO.setWhId(finalId);
            invWhAreaSaveVO.setCreateTime(LocalDateTime.now());
            invWhAreaSaveVO.setDeter3(invWhAreaSaveVO.getPCode());
            invWhAreaSaveVO.setSecBuId(invWhDO.getSecBuId());
            invWhAreaSaveVO.setSecUserId(invWhDO.getSecUserId());
            invWhAreaSaveVO.setSecOuId(invWhDO.getOuId());
            return invWhAreaSaveVO;
        }).collect(Collectors.toList());
        return invWhAreaSaveVOS;
    }

    private void setDefaultDeter2(InvWhSaveVO invWhSaveVO, InvWhDO invWhDO, Long finalId, List<InvWhAreaSaveVO> invWhAreaSaveVOS) {
        long count = invWhAreaSaveVOS.stream().filter(v -> UdcEnum.INV_FUNC_TYPE_9.getValueCode().equals(v.getDeter2())).distinct().count();
        if (count == 0 && !invWhSaveVO.getWhType().equals(UdcEnum.INV_WH_TYPE_6.getValueCode())) {
            InvWhAreaSaveVO whAreaSaveVO = new InvWhAreaSaveVO() {
            };
            whAreaSaveVO.setDeter2(UdcEnum.INV_FUNC_TYPE_9.getValueCode());
            whAreaSaveVO.setWhId(finalId);
            whAreaSaveVO.setSecBuId(invWhDO.getSecBuId());
            whAreaSaveVO.setSecUserId(invWhDO.getSecUserId());
            whAreaSaveVO.setSecOuId(invWhDO.getOuId());
            invWhAreaSaveVOS.add(whAreaSaveVO);
        }
    }

    private void verifyWhareas(List<InvWhAreaSaveVO> invWhAreaSaveVOS, InvWhSaveVO param) {
        List<InvWhDO> invWhDOS = invWhRepo.findByWhName(param.getWhName());
        if (!CollectionUtils.isEmpty(invWhDOS)) {
            invWhDOS.stream()
                    .filter(wh -> !wh.getId().equals(param.getId())).findAny()
                    .ifPresent(m -> {
                        throw new BusinessException(ApiCode.FAIL, String.format("仓库名【%s】已存在，不可重复", param.getWhName()));
                    });
        }
        //功能区唯一校验
        if (!CollectionUtils.isEmpty(param.getOrgWhAreaCreateParamList())) {
            val deter2s = param.getOrgWhAreaCreateParamList().stream()
                    .map(InvWhAreaSaveVO::getDeter2).distinct().collect(Collectors.toList());
            if (deter2s.size() != param.getOrgWhAreaCreateParamList().size()) {
                throw new BusinessException(ApiCode.FAIL, "功能区编码已存在，不能重复，请检查！");
            }
            val deter2Names= param.getOrgWhAreaCreateParamList().stream()
                    .map(InvWhAreaSaveVO::getDeter2Name).distinct().collect(Collectors.toList());
            if (deter2Names.size() != param.getOrgWhAreaCreateParamList().size()) {
                throw new BusinessException(ApiCode.FAIL, "功能区名称已存在，不能重复，请检查！");
            }
            InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
            areaParamVO.setDeter2s(deter2s);
            List<InvWhAreaRespVO> invWhAreaRespVOS = invWhAreaDomainService.findWhAreasByParam(areaParamVO);
            if(!CollectionUtils.isEmpty(invWhAreaRespVOS)){
                for(String deter2 : deter2s){
                    long deter2Count = invWhAreaRespVOS.stream().filter(i -> i.getDeter2().equals(deter2)).count();
                    if(param.getId() != null && deter2Count > 1){
                        throw new BusinessException(ApiCode.FAIL, String.format("功能区编码【%s】已存在，不能重复，请检查！",deter2));
                    }
                    if(param.getId() == null && deter2Count > 0){
                        throw new BusinessException(ApiCode.FAIL, String.format("功能区编码【%s】已存在，不能重复，请检查！",deter2));
                    }
                }
            }
            List<InvWhAreaRespVO> whAreaByDeter2Names = invWhAreaDomainService.findByDeter2Names(deter2Names);
            if(!CollectionUtils.isEmpty(whAreaByDeter2Names)){
                for(String deter2Name : deter2Names){
                    long deter2NameCount = whAreaByDeter2Names.stream().filter(i -> i.getDeter2Name().equals(deter2Name)).count();
                    if(param.getId() != null && deter2NameCount > 1){
                        throw new BusinessException(ApiCode.FAIL, String.format("功能区名称【%s】已存在，不能重复，请检查！",deter2Name));
                    }
                    if(param.getId() == null && deter2NameCount > 0){
                        throw new BusinessException(ApiCode.FAIL, String.format("功能区名称【%s】已存在，不能重复，请检查！",deter2Name));
                    }
                }
            }
        }
        //校验退货仓
        if (TUIHUOFLAG == param.getTuihuoFlag()) {
            List<InvWhRespVO> whRespVOS = invWhRepoProc.selectWhByOuIdAndTuihuoFlag(param.getOuId(), TUIHUOFLAG);
            if (!CollectionUtils.isEmpty(whRespVOS)) {
                if (param.getId() != null) {
                    whRespVOS.stream().filter(v -> !v.getId().equals(param.getId())).findAny().ifPresent(i -> {
                        throw new BusinessException(ApiCode.FAIL, String.format("%s公司已经存在退货仓对接仓，不允许同一家公司有两个退货仓对接仓！", param.getOuCode()));
                    });
                } else {
                    throw new BusinessException(ApiCode.FAIL, String.format("%s公司已经存在退货仓对接仓，不允许同一家公司有两个退货仓对接仓！", param.getOuCode()));
                }
            }
        }
        //校验售后仓
        if (UdcEnum.INV_WH_PROP_AFTERSAL.getValueCode().equals(param.getEs1())) {
            //校验公司售后仓是否存在
            List<InvWhRespVO> respVOS = invWhRepoProc.selectWhByOuIdAndEs1(param.getOuId(), UdcEnum.INV_WH_PROP_AFTERSAL.getValueCode());
            if (!CollectionUtils.isEmpty(respVOS)) {
                if (param.getId() != null) {
                    respVOS.stream().filter(v -> !v.getId().equals(param.getId())).findAny().ifPresent(i -> {
                        throw new BusinessException(ApiCode.FAIL, String.format("%s公司已经存在售后对接仓，不允许同一家公司有两个售后对接仓！", param.getOuCode()));
                    });
                } else {
                    throw new BusinessException(ApiCode.FAIL, String.format("%s公司已经存在售后对接仓，不允许同一家公司有两个售后对接仓！", param.getOuCode()));
                }
            }
        }


    }

    private void verifyWhType(List<InvWhAreaSaveVO> invWhAreaSaveVOS, InvWhSaveVO param) {
        //网格个人仓校验
        if (UdcEnum.INV_WH_TYPE_3.getValueCode().equals(param.getWhType())) {
            List<String> pcodes = invWhAreaSaveVOS.stream().map(InvWhAreaSaveVO::getPCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
            areaParamVO.setPCodes(pcodes);
            areaParamVO.setDeter2(UdcEnum.INV_FUNC_TYPE_15.getValueCode());
            List<InvWhAreaRespVO> invWhAreaRespVOS = invWhAreaDomainService.findWhAreasByParam(areaParamVO);
            if (!CollectionUtils.isEmpty(invWhAreaRespVOS)) {
                invWhAreaRespVOS.stream().filter(a -> !a.getWhId().equals(param.getId()))
                        .findAny().ifPresent(m -> {
                    throw new BusinessException(ApiCode.FAIL, String.format("该网格员【%s】已存在于另一个仓库中，不可重复", m.getPCode()));
                });
            }
        }

    }

    private String getIncrForWhcode(InvWhSaveVO param) {
        Long num = numSenderService.incr("numSender:yst-inv:WHOuCode" + param.getOuCode(), 0L);
        DecimalFormat df = new DecimalFormat("000");
        String numStr = df.format(num);
        String whCode = "WH" + param.getOuCode() + numStr;
        return whCode;
    }

    private OrgAddrRpcSaveParam reduceOrgAddrRpcSaveParam(Long addrNo, InvWhSaveVO param) {
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
        //地址簿
        orgAddrRpcSaveParam.setId(param.getAddressId());
        orgAddrRpcSaveParam.setAddrNo(addrNo);
        orgAddrRpcSaveParam.setAddrName(param.getWhName());
        orgAddrRpcSaveParam.setAddrType(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode());
        List<OrgAddrAddressRpcSaveParam> orgAddrAddressSaveParams = new ArrayList<>();
        OrgAddrAddressRpcSaveParam orgAddrAddressVO = new OrgAddrAddressRpcSaveParam();
        orgAddrAddressVO.setDetailAddr(param.getDetailaddr());
        orgAddrAddressVO.setCountry(param.getCountry());
        orgAddrAddressVO.setProvince(param.getProvince());
        orgAddrAddressVO.setCity(param.getCity());
        orgAddrAddressVO.setCounty(param.getCounty());
        orgAddrAddressVO.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
        orgAddrAddressVO.setDefaultFlag(true);
        /***start****/
        orgAddrAddressVO.setEmail(param.getEmail());
        orgAddrAddressVO.setContPerson(param.getContPerson());
        orgAddrAddressVO.setTel(param.getTel());
        /***end****/
        orgAddrAddressSaveParams.add(orgAddrAddressVO);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressSaveParams);
        return orgAddrRpcSaveParam;

    }

    private OrgBuRpcSaveParam orgBuRpcSaveOrUpdate(InvWhSaveVO param, Long addrNo, Boolean changeFlag) {
        OrgBuRpcSaveParam saveParam = new OrgBuRpcSaveParam();
        if (!changeFlag) {
            saveParam.setId(param.getSecBuId());
        }
        saveParam.setOuId(param.getOuId());
        saveParam.setBuStatus(param.getWhStatus());
        saveParam.setBuName(param.getWhName());
        saveParam.setBuCode(param.getWhCode());
        saveParam.setBuType(UdcEnum.ORG_BU_TYPE_WH.getValueCode());
        saveParam.setBuStatus(param.getWhStatus());
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = reduceOrgAddrRpcSaveParam(addrNo, param);
        saveParam.setOrgAddrSaveParam(orgAddrRpcSaveParam);
        return saveParam;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhRespVO> findWhAreaById(Long id) {
        Optional<InvWhRespVO> orgWhVOOptional = invWhDomainService.findIdOne(id);
        if (orgWhVOOptional.isPresent()) {
            InvWhRespVO vo = orgWhVOOptional.get();
            Long addrNo = vo.getAddrNo();
            List<InvWhAreaRespVO> invWhAreaRespVOS = invWhAreaDomainService.findByWhId(id);
            List<String> deter2Types = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getDeter2Type)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<InvWhAreaSettingRespVO> settingRespVOS = invWhAreaSettingService.findByDeter2Types(deter2Types);
            //省市区
            Map<String, String> areaNameMap = this.selectCityCode(invWhAreaRespVOS);
            //udc数据处理
            ArrayList<InvWhRespVO> vos = new ArrayList<>();
            vos.add(vo);

            //检验类型字符串转换为编码集合,以逗号分隔的字符串形式
            List<String> codeStrList = InvStringUtil.transitionStrToCodes(vo.getDesCode());
            vo.setDesCodeList(codeStrList);

            List<InvDespatchRpcDTO> orgBuRpcAllDTOS = invDespatchConfigDomainService.findByDesCodeBatch(codeStrList);
            Map<String,InvDespatchRpcDTO> ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS) ? new HashMap<>() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(InvDespatchRpcDTO::getDesCode, t -> t, (t1, t2) -> t1));


            invWhAreaRespVOS.forEach(i -> {
                if (i.getPType() != null && i.getPCode() != null) {
                    InvParentParamVO paramVO = new InvParentParamVO();
                    paramVO.setCode(i.getPCode());
                    paramVO.setType(i.getPType());
                    List<OrgRespVO> res = orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(res)) {
                        i.setPName(res.get(0).getName());
                    }
                }
                if (!CollectionUtils.isEmpty(settingRespVOS)) {
                    settingRespVOS.stream().filter(v -> v.getDeter2Type().equals(i.getDeter2Type())).findAny().
                            ifPresent(d ->
                                    {
                                        i.setBusinessChoose(d.getBusinessChoose());
                                        i.setDeter2TypeName(d.getDeter2TypeName());
                                    }
                            );
                }
                if (!areaNameMap.isEmpty()) {
                    i.setProvinceName(areaNameMap.get(i.getProvince()));
                    i.setCityName(areaNameMap.get(i.getCity()));
                    i.setCountyName(areaNameMap.get(i.getCounty()));
                }
            });
            vo.setInvWhAreaRespVOList(invWhAreaRespVOS);
            //查询配送范围
            List<InvWhDeliveryRespVO> whDeliveryList = invWhDeliveryService.findByWhId(id);
            whDeliveryList = whDeliveryList.stream().map(v -> {
                if (Integer.valueOf(InvWhDeliveryFlagEnum.C1.getCode()).equals(v.getAllArea())) {
                    v.setAllAreaName(InvWhDeliveryFlagEnum.C1.getDesc());
                }
                return v;
            }).collect(Collectors.toList());
            vo.setDeliveryAreas(whDeliveryList);
            if (addrNo != null) {
                List<OrgAddrAddressRpcDTO> orgAddrAddressVOS = findOrgAddrAddressList(addrNo);
                if (orgAddrAddressVOS.size() > 0) {
                    OrgAddrAddressRpcDTO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                    vo.setCountry(orgAddrAddressVO.getCountry());
                    vo.setProvince(orgAddrAddressVO.getProvince());
                    vo.setCity(orgAddrAddressVO.getCity());
                    vo.setCounty(orgAddrAddressVO.getCounty());
                    vo.setCountryName(orgAddrAddressVO.getCountry());
                    vo.setProvinceName(orgAddrAddressVO.getProvinceName());
                    vo.setCityName(orgAddrAddressVO.getCityName());
                    vo.setCountyName(orgAddrAddressVO.getCountyName());
                    vo.setDetailaddr(orgAddrAddressVO.getDetailAddr());
                    vo.setEmail(orgAddrAddressVO.getEmail());
                    vo.setTel(orgAddrAddressVO.getTel());
                    vo.setContPerson(orgAddrAddressVO.getContPerson());
                    vo.setDetailaddr(orgAddrAddressVO.getDetailAddr());
                }
            }
            //仓库公司信息
            OrgOuRpcDTO ouVO = orgOutService.findOuById(vo.getOuId());
            if (ouVO != null) {
                vo.setOuName(ouVO.getOuName());
                vo.setOuCode(ouVO.getOuCode());
            }
            if (!org.springframework.util.StringUtils.isEmpty(vo.getBelongBuId())) {
                val orgBuOptional = orgOutService.findBuById(Long.valueOf(vo.getBelongBuId()));
                orgBuOptional.ifPresent(orgBuRpcDTO -> {
                    vo.setBelongBuCode(orgBuRpcDTO.getBuCode());
                    vo.setBelongBuName(orgBuRpcDTO.getBuName());
                });
            }

            List<String> desCodeList = vo.getDesCodeList();
            List<String> desCodeNameList = new ArrayList<>();
            if (CollectionUtil.isNotEmpty(desCodeList)){
                for (String desCode : desCodeList) {
                    InvDespatchRpcDTO orgBuRpcDTO = ouMap.get(desCode);
                    if (Objects.nonNull(orgBuRpcDTO)){
                        desCodeNameList.add(orgBuRpcDTO.getDesName());
                    }
                }
            }
            String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("、"));
            vo.setDesCodeName(desCodeName);

        } else {
            throw new BusinessException(ApiCode.FAIL, "数据不存在，请检查");
        }
        return orgWhVOOptional;
    }

    private Map<String, String> selectCityCode(List<InvWhAreaRespVO> lists) {
        // 省市区翻译
        List<String> provinceCodes = lists.stream().map(InvWhAreaRespVO::getProvince).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> cityCodes = lists.stream().map(InvWhAreaRespVO::getCity).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> countyCodes = lists.stream().map(InvWhAreaRespVO::getCounty).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> areaCodeList = new ArrayList<>();
        areaCodeList.addAll(provinceCodes);
        areaCodeList.addAll(cityCodes);
        areaCodeList.addAll(countyCodes);
        Map<String, String> areaNameMap = systemService.findAreaByParam(areaCodeList)
                .stream().collect(Collectors.toMap(SysAreaRespDTO::getAreaCode, SysAreaRespDTO::getAreaName, (t1, t2) -> t1));
        return areaNameMap;
    }

    /*private boolean checkBusinessChoose(String businessChoose) {
        if (Objects.equals(businessChoose, InvUdcEnum.INV_BUSINESS_CHOOSE_Y.getValueCode())) {
            return true;
        } else if (Objects.equals(businessChoose, InvUdcEnum.INV_BUSINESS_CHOOSE_N.getValueCode())) {
            return false;
        }
        return false;
    }

    private boolean checkIsZeroWh(String isZeroWh) {
        if (Objects.equals(isZeroWh, InvUdcEnum.INV_ZERO_WH_Y.getValueCode())) {
            return true;
        } else if (Objects.equals(isZeroWh, InvUdcEnum.INV_ZERO_WH_N.getValueCode())) {
            return false;
        }
        return false;
    }*/

    @Override
    @SysCodeProc
    public List<InvWhDeter2RespVO> findDeter2sByWhId(Long whId) {
        List<InvWhDeter2RespVO> invWhDeter2RespVOS = invWhAreaRepoProc.findDeter2sByWhId(whId);
        return invWhDeter2RespVOS;
    }


    @Override
    public PagingVO<InvWhRespVO> search(InvWhParamVO param) {
        JPAQuery<InvWhRespVO> jpaQuery = invWhRepoProc.select(null).where(invWhRepoProc.searchWhere(param));
        long dataCount = jpaQuery.fetchCount();
        invWhRepoProc.openOrderAndLimit(jpaQuery, param, QInvWhDO.invWhDO);
        List<InvWhRespVO> lists = jpaQuery.fetch();
        //渲染公司数据
        this.translateWh(lists);
        PagingVO<InvWhRespVO> paging = new PagingVO<>();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    public List<InvWhRespVO> searchWhByParam(InvWhParamVO param) {
        List<InvWhRespVO> whRespVOS = invWhRepoProc.select(null).where(invWhRepoProc.searchWhere(param)).fetch();
        if (!CollectionUtils.isEmpty(whRespVOS)) {
            this.translateWh(whRespVOS);
            return whRespVOS;
        }
        return null;

    }

    @Override
    public List<InvWhRespVO> searchWhBaseByParam(InvWhParamVO param) {
        List<InvWhRespVO> whRespVOS = invWhRepoProc.select(null).where(invWhRepoProc.searchWhere(param)).fetch();
        if (CollectionUtils.isEmpty(whRespVOS)) {
            return Collections.EMPTY_LIST;
        }
        return whRespVOS;
    }


    @Override
    public List<InvWhRespVO> findByCodes(List<String> codes) {
        List<InvWhRespVO> whRespVOList = invWhDomainService.findByCodes(codes);
        this.translateWh(whRespVOList);
        return whRespVOList;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findIdBatch(List<Long> ids) {
        List<InvWhRespVO> invWhRespVOS = invWhDomainService.findIdBatch(ids);
        return invWhRespVOS;
    }


    @Override
    @SysCodeProc
    public List<InvWhListRespVO> list(String keyword) throws ExecutionException, InterruptedException {
        val collect = invWhRepoProc.list(keyword).fetch().stream()
                .map(VO -> BeanUtil.copyProperties(VO, InvWhListRespVO.class)).collect(Collectors.toList());
        val collect1 = collect.stream().map(InvWhListRespVO::getId).distinct().collect(Collectors.toList());
        CompletableFuture<List<InvWhAreaRespVO>> listCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            val allByWhId = invWhAreaService.findAllByWhId(collect1);
            return allByWhId;
        });
        val orgWhAreaVOS = listCompletableFuture1.get();
        //val byAddrNos = listCompletableFuture.get();

        val deter2 = orgWhAreaVOS.stream().filter(v -> {
            return v.getWhId() != null && v.getDeter2() != null;
        }).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter2, (key1, key2) -> key2));

        val deter3 = orgWhAreaVOS.stream().filter(v -> {
            return v.getWhId() != null && v.getDeter3() != null;
        }).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter3, (key1, key2) -> key2));
        collect.stream().forEach(v -> {
            if (deter2.get(v.getId()) != null) {
                v.setDeter2(deter2.get(v.getId()));
            }
            if (deter3.get(v.getId()) != null) {
                v.setDeter3(deter3.get(v.getId()));
            }
            //根据地址号查询地址信息，目前没有批量查询接口，支撑域建议分页这种看是否可以去掉不展示地址信息，可在详情展示
            val first = findOrgAddrAddress(v.getAddrNo());
            first.ifPresent(o -> v.setFromLoc(o.getCity()));
           /* val first = byAddrNos.stream().filter(w -> v.getAddrNo() != null && v.getAddrNo().equals(w.getAddrNo())).findFirst();
            first.ifPresent(o -> v.setFromLoc(o.getCity()));*/
        });
        return collect;
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        invWhDomainService.deleteBatch(list);
    }

    private Boolean existVerify(Long id, String whCode) {
        InvWhParamVO param = new InvWhParamVO();
        param.setWhCode(whCode);
        JPAQuery<InvWhRespVO> select = invWhRepoProc.select(param);
        return select.fetch().stream().anyMatch(w -> !w.getId().equals(id));
    }


    private void translateWh(List<InvWhRespVO> invWhRespVOList) {
        List<Long> ouIds = invWhRespVOList.stream().map(InvWhRespVO::getOuId).distinct().collect(Collectors.toList());
        List<Long> addrNos = invWhRespVOList.stream().map(InvWhRespVO::getAddrNo).distinct().collect(Collectors.toList());
        List<String> buIdStringList = invWhRespVOList.stream().map(InvWhRespVO::getBelongBuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> buIdList = buIdStringList.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());

        //查询公司数据
        List<OrgOuRpcDTO> orgOuVOS = orgOutService.findOuByIds(ouIds);
        OrgAddressRpcDtoParam param = new OrgAddressRpcDtoParam();
        param.setAddrNos(addrNos);
        List<OrgAddressRpcDTO> rpcAddrNos = orgOutService.findRpcDtoByBatchAddrNos(param);
        List<OrgBuRpcDTO> orgBuRpcDTOList = orgOutService.findBuByIds(buIdList);
        invWhRespVOList.forEach(VO -> {
            //渲染地址信息
            if (!CollectionUtils.isEmpty(rpcAddrNos)) {
                rpcAddrNos.stream().filter(a -> a.getAddrNo().equals(VO.getAddrNo()) &&
                        a.getAddrType().equals(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode())).findAny().ifPresent(
                        orgAddressRpcDTO -> {
                            VO.setCountry(orgAddressRpcDTO.getCountry());
                            VO.setProvince(orgAddressRpcDTO.getProvince());
                            VO.setCity(orgAddressRpcDTO.getCity());
                            VO.setCounty(orgAddressRpcDTO.getCounty());
                            VO.setCountryName(orgAddressRpcDTO.getCountry());
                            VO.setProvinceName(orgAddressRpcDTO.getProvinceName());
                            VO.setCityName(orgAddressRpcDTO.getCityName());
                            VO.setCountyName(orgAddressRpcDTO.getCountyName());
                            VO.setDetailaddr(orgAddressRpcDTO.getDetailAddr());
                            VO.setEmail(orgAddressRpcDTO.getEmail());
                            VO.setContPerson(orgAddressRpcDTO.getContPerson());
                            VO.setTel(orgAddressRpcDTO.getTel());
                        });
            }
            //渲染公司相关数据
            Optional<OrgOuRpcDTO> first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst();
            if (first1.isPresent()) {
                OrgOuRpcDTO orgOuVO = first1.get();
                VO.setOuName(orgOuVO.getOuName());
                VO.setOuCode(orgOuVO.getOuCode());
                VO.setOuCurr(orgOuVO.getOuCurr());
            }
            //组织
            Optional<OrgBuRpcDTO> orgBuOptional = orgBuRpcDTOList.stream().filter(buRpcDTO -> Objects.equals(buRpcDTO.getId(), transitionBelongBuId(VO.getBelongBuId()))).findFirst();
            orgBuOptional.ifPresent(buRpcDTO -> {
                VO.setBelongBuName(buRpcDTO.getBuName());
                VO.setBelongBuCode(buRpcDTO.getBuCode());
            });

            //检验类型字符串转换为编码集合,以逗号分隔的字符串形式
            List<String> codeStrList = InvStringUtil.transitionStrToCodes(VO.getDesCode());
            VO.setDesCodeList(codeStrList);

        });
        //渲染公司币种
        List<String> ouCurrList = invWhRespVOList.stream().map(InvWhRespVO::getOuCurr).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ouCurrList)) {
            List<SysCurrencyRespDTO> comCurrRpcDTOS = orgOutService.findRpcDtoByParam(ouCurrList);
            Map<String, String> stringMap = comCurrRpcDTOS.stream().collect(Collectors.toMap(SysCurrencyRespDTO::getCurrCode, SysCurrencyRespDTO::getCurrName));
            if (!CollectionUtils.isEmpty(comCurrRpcDTOS)) {
                invWhRespVOList.stream().forEach(v -> {
                    if (v.getOuCurr() != null) {
                        v.setOuCurrName(stringMap.get(v.getOuCurr()));
                    }
                });
            }
        }

        //销售组织
        List<String> desCodeAllList = invWhRespVOList.stream().flatMap(vo -> vo.getDesCodeList().stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvDespatchRpcDTO> orgBuRpcAllDTOS = invDespatchConfigDomainService.findByDesCodeBatch(desCodeAllList);
        Map<String,InvDespatchRpcDTO> ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS) ? new HashMap<>() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(InvDespatchRpcDTO::getDesCode, t -> t, (t1, t2) -> t1));
        invWhRespVOList.forEach(vo -> {
            List<String> desCodeList = vo.getDesCodeList();
            List<String> desCodeNameList = new ArrayList<>();

            if (CollectionUtil.isNotEmpty(desCodeList)){
                for (String desCode : desCodeList) {
                    InvDespatchRpcDTO orgBuRpcDTO = ouMap.get(desCode);
                    if (Objects.nonNull(orgBuRpcDTO)){
                        desCodeNameList.add(orgBuRpcDTO.getDesCode());
                    }
                }
            }
            String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("、"));
            vo.setDesCodeName(desCodeName);

        });
    }

    private Long transitionBelongBuId(String belongBuId) {
        if (org.springframework.util.StringUtils.isEmpty(belongBuId)) {
            return null;
        }
        return Long.valueOf(belongBuId);
    }

    public void update(InvWhDO invWhDO) {
        Optional<InvWhDO> optional = invWhDomainService.findById(invWhDO.getId());
        if (optional.isPresent()) {
            BeanCopyUtil.beanCopyWithIngore(invWhDO, optional.get(), BeanCopyUtil.getNullAndIgnorePropertyNames(invWhDO));
            invWhDomainService.saveInvWh(invWhDO);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + invWhDO.getId());
        }
    }

    /**
     * 创建地址信息
     *
     * @param changeFlag 是否是修改变更
     * @param addrNo     地址号
     * @param param      创建信息
     * @return 调用结果，如果成功，data 中保存的是 addrNo，而不是id
     */
    private Long saveAddressAndQualifyAndBankAcc(Boolean changeFlag, Long addrNo, InvWhSaveVO param) {
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
        OrgAddrAddressRpcSaveParam orgAddrAddressVO = new OrgAddrAddressRpcSaveParam();

        //修改地址薄信息时先查询出地址薄ID,有ID为修改否则视为新增
        if (changeFlag) {
            OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = orgOutService.findRpcDtoByAddrNo(addrNo);
            if (Objects.nonNull(orgAddrDetailsRpcDto)) {
                orgAddrRpcSaveParam.setId(orgAddrDetailsRpcDto.getId());
                param.setAddressId(orgAddrDetailsRpcDto.getId());

                //地址联系人信息:必填且只有一条，故明细只有修改逻辑
                List<OrgAddrAddressRpcDTO> orgAddrAddressRpcDTOList = orgAddrDetailsRpcDto.getOrgAddrAddressVos();
                if (!CollectionUtils.isEmpty(orgAddrAddressRpcDTOList)) {
                    Long addrAddressId = orgAddrAddressRpcDTOList.get(0).getId();
                    orgAddrAddressVO.setId(addrAddressId);
                }
            } else {

            }
        }
        //地址簿
        orgAddrRpcSaveParam.setAddrNo(addrNo);
        orgAddrRpcSaveParam.setAddrName(param.getWhName());
        orgAddrRpcSaveParam.setAddrType(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode());
        List<OrgAddrAddressRpcSaveParam> orgAddrAddressSaveParams = new ArrayList<>();
        // OrgAddrAddressRpcSaveParam orgAddrAddressVO = new OrgAddrAddressRpcSaveParam();
        orgAddrAddressVO.setDetailAddr(param.getDetailaddr());
        orgAddrAddressVO.setCountry(param.getCountry());
        orgAddrAddressVO.setProvince(param.getProvince());
        orgAddrAddressVO.setCity(param.getCity());
        orgAddrAddressVO.setCounty(param.getCounty());
        orgAddrAddressVO.setAddressType(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode());
        orgAddrAddressVO.setDefaultFlag(true);
        /***start****/
        orgAddrAddressVO.setEmail(param.getEmail());
        orgAddrAddressVO.setContPerson(param.getContPerson());
        orgAddrAddressVO.setTel(param.getTel());
        /***end****/
        orgAddrAddressSaveParams.add(orgAddrAddressVO);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressSaveParams);
        ApiResult<Long> apiResult = orgOutService.orgAddrSaveOrUpdateReturnAddrNo(orgAddrRpcSaveParam);
        if (apiResult.isSuccess()) {
            return apiResult.getData();
        } else {
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        //return null;
    }

    private void saveWhOrgAddrAddress(List<Long> addrNoList, InvWhSaveVO param) {

        addrNoList.forEach(addr -> {
            OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = orgOutService.findRpcDtoByAddrNo(addr);
            if (Objects.nonNull(orgAddrDetailsRpcDto)) {
                List<OrgAddrAddressRpcDTO> orgAddrAddressRpcDtoList = orgAddrDetailsRpcDto.getOrgAddrAddressVos();
                if (!CollectionUtils.isEmpty(orgAddrAddressRpcDtoList)) {
                    //outouService.softDeleteOrgAddrByAddrNo(addr.longValue());

                    OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
                    orgAddrRpcSaveParam.setId(orgAddrDetailsRpcDto.getId());
                    orgAddrRpcSaveParam.setAddrNo(orgAddrDetailsRpcDto.getAddrNo());
                    orgAddrRpcSaveParam.setAddrName(orgAddrDetailsRpcDto.getAddrName());
                    orgAddrRpcSaveParam.setAddrType(orgAddrDetailsRpcDto.getAddrType());
                    List<OrgAddrAddressRpcSaveParam> orgAddrAddressSaveParams = new ArrayList<>();
                    OrgAddrAddressRpcSaveParam invAddrAddress = new OrgAddrAddressRpcSaveParam();

                    //if (Objects.equals(addr, orgAddrDetailsRpcDto.getAddrNo())) {
                    OrgAddrAddressRpcDTO orgAddrAddressRpcDto = orgAddrAddressRpcDtoList.get(0);
                    BeanCopyUtil.beanCopy(orgAddrAddressRpcDto, invAddrAddress);
                    invAddrAddress.setEmail(param.getEmail());
                    invAddrAddress.setContPerson(param.getContPerson());
                    //保存仓库地址
                    orgAddrAddressSaveParams.add(invAddrAddress);
                    orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressSaveParams);
                    orgOutService.orgAddrSaveOrUpdateReturnAddrNo(orgAddrRpcSaveParam);
                    //}
                }
            }
        });

    }

    private void translateWhArea(List<InvWhAreaRespVO> invWhAreaRespVOS, List<InvWhRespVO> invWhRespVOList) {
        List<Long> createUserIds = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getCreateUserId).filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = systemService.findAllEmpsByIdIn(createUserIds);
        List<String> deter2Types = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getDeter2Type)
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());
        List<InvWhAreaSettingRespVO> byDeter2Types = invWhAreaSettingService.findByDeter2Types(deter2Types);
        invWhAreaRespVOS.forEach(VO -> {
            if(!CollectionUtils.isEmpty(byDeter2Types)){
                byDeter2Types.stream().filter(m -> m.getDeter2Type().equals(VO.getDeter2Type())).findAny()
                        .ifPresent(d ->{
                            VO.setDeter2TypeName(d.getDeter2TypeName());

                });
            }
            if (empsByIdIn != null) {
                empsByIdIn.stream().filter(u -> u.getId() != null && u.getId().equals(VO.getCreateUserId())).findAny().ifPresent(i -> {
                    VO.setCreateUserName(i.getUsername());
                });
            }
            if (!CollectionUtils.isEmpty(invWhRespVOList)) {
                invWhRespVOList.stream().filter(record -> VO.getWhId() != null && VO.getWhId().equals(record.getId())).findAny().ifPresent(
                        VO::setInvWhRespVO
                );
            }
            if (VO.getPType() != null && VO.getPCode() != null) {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setCode(VO.getPCode());
                paramVO.setType(VO.getPType());
                List<OrgRespVO> vos = orgOutService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    VO.setPName(vos.get(0).getName());
                }
            }
        }
);
    }

    /**
     * 功能描述 校验导入数据（仓库功能区导入）
     *
     * @param importParams
     * @return void
     * @author Brian.lai
     * @date 2021/10/9
     */
    private void checkData(List<InvWhAreaImport> importParams, String whType) {
        if (importParams.size() == 0) {
            throw new BusinessException(ApiCode.FAIL, "导入的数据为空，请检查！");
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        StringBuilder builder3 = new StringBuilder();
        StringBuilder builder4 = new StringBuilder();

        InvWhAreaSettingParamVO paramVO = new InvWhAreaSettingParamVO();
        paramVO.setWhType(whType);
        paramVO.setStatus("ACTIVE");
        List<InvWhAreaSettingRespVO> allActives = invWhAreaSettingService.findAllActives(paramVO);
        List<String> deter2List = allActives.stream().map(v -> v.getDeter2()).collect(Collectors.toList());
        List<String> suppcodes = new ArrayList<>();
        AtomicInteger line1 = new AtomicInteger(0);
        importParams.forEach(v -> {
            line1.addAndGet(1);
            if (StringUtils.isEmpty(v.getDeter2())) {
                builder.append("【" + line1 + "】");
            }
            if (!StringUtils.isEmpty(v.getDeter2()) && v.getDeter2().equals("15") && StringUtils.isEmpty(v.getPcode())) {
                builder1.append("【" + line1 + "】");
            }
            if (!deter2List.contains(v.getDeter2())) {
                builder2.append("【" + line1 + "】");
            }
            if (!StringUtils.isEmpty(v.getDeter2()) && v.getDeter2().equals("17") && StringUtils.isEmpty(v.getPcode())) {
                builder3.append("【" + line1 + "】");
            }
        });
        if (builder.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder.toString() + "行必填数据有空值,请检查！");
        }
        if (builder1.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder1.toString() + "行当功能区为网格个人库时，员工编号必填必填，请检查！");
        }
        if (builder2.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder2.toString() + "行该仓库不能选择这个功能区，请检查！");
        }
        if (builder3.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder3.toString() + "行当功能区为供应商仓的时候，供应商编码必填！");
        }
    }

    //调用支撑域设置国家，省，市，区(目前国家没有编码，直接设置成中文)
    private void setProviceAndCityAndCounty(InvWhSaveVO saveVO, InvWhExcelImport excelImport) {
        //设置国家
        saveVO.setCountry(excelImport.getCountry());
        List<String> list = Arrays.asList(excelImport.getProvince(), excelImport.getCity(), excelImport.getCounty());
        List<SysAreaRespDTO> comCityCodeRpcDTOS = systemService.findAreaByParam(list);
        comCityCodeRpcDTOS.forEach(v -> {
            if (v.getAreaName().equals(excelImport.getProvince())) {
                saveVO.setProvince(v.getAreaCode());
            }
            if (v.getAreaName().equals(excelImport.getCity())) {
                saveVO.setCity(v.getAreaCode());
            }
            if (v.getAreaName().equals(excelImport.getCounty())) {
                saveVO.setCounty(v.getAreaCode());
            }
        });
    }


    private String getKey(Map<String, String> map, String value) {
        String key = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (value.equals(entry.getValue())) {
                key = entry.getKey();
            }
        }
        return key;
    }

    /**
     * 功能描述 校验导入数据
     *
     * @param importParams
     * @return void
     * @author Brian.lai
     * @date 2021/7/14
     */
    private void chcekData(List<InvWhExcelImport> importParams) {

        StringBuilder builder = new StringBuilder();
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        StringBuilder builder3 = new StringBuilder();
        StringBuilder builder4 = new StringBuilder();
        StringBuilder builder5 = new StringBuilder();
        StringBuilder builder6 = new StringBuilder();

        //查询公司
        List<String> ouCodes = importParams.stream().map(InvWhExcelImport::getOuCode).collect(Collectors.toList());
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(ouCodes);
//        List<OrgOuRpcDTO> ouRpcDTOS = outouService.findOuDtoByParam(orgOuRpcDtoParam);
        //查询库存合作伙伴类型
        List<String> pCodeList = importParams.stream().map(InvWhExcelImport::getPCode).collect(Collectors.toList());
        OrgEmpRpcDtoParam empRpcDtoParam = new OrgEmpRpcDtoParam();
        empRpcDtoParam.setEmpCodes(pCodeList);
        //设置过滤条件，类型为员工的合作伙伴类型
//        empRpcDtoParam.setEmpType("EMP");
//        List<OrgEmpRpcDTO> empDtoByParam = outouService.findEmpDtoByParam(empRpcDtoParam);
        //获取仓库编码
        List<String> whCodeList = importParams.stream().map(v -> v.getWhCode()).collect(Collectors.toList());
        List<InvWhRespVO> invWhRespVOS = this.findByCodes(whCodeList);

        AtomicInteger line1 = new AtomicInteger(0);
        importParams.forEach(v -> {
            line1.addAndGet(1);
            //先判断是否为空
            if (StringUtils.isEmpty(v.getWhCode()) || StringUtils.isEmpty(v.getWhName()) || StringUtils.isEmpty(v.getOuCode())
                    || StringUtils.isEmpty(v.getProvince()) || StringUtils.isEmpty(v.getCity()) || StringUtils.isEmpty(v.getCounty())
                    || StringUtils.isEmpty(v.getDetailaddr()) || StringUtils.isEmpty(v.getContPerson()) || StringUtils.isEmpty(v.getTel())
                    || StringUtils.isEmpty(v.getEmail()) || StringUtils.isEmpty(v.getDeter2())) {
                builder.append("【" + line1 + "】");
            }
        });
        //遍历map集合,开始校验同一个仓库的基础信息是否相同
        //先根据仓库编码进行分割数据
        Map<String, List<InvWhExcelImport>> listMap = importParams.stream().collect(Collectors.groupingBy(InvWhExcelImport::getWhCode));
        for (Map.Entry<String, List<InvWhExcelImport>> a : listMap.entrySet()) {
            List<InvWhExcelImport> value = a.getValue();
            InvWhExcelImport excelImport = value.get(0);
            value.forEach(v -> {
                //判断是不是同一个仓库的基础信息是否相同
                if (!(v.getWhType().equals(excelImport.getWhType())) || (!v.getWhName().equals(excelImport.getWhName()))
                        || (!v.getOuCode().equals(v.getOuCode())) || (!v.getProvince().equals(excelImport.getProvince())) || (!v.getCity().equals(excelImport.getCity())) || (!v.getCounty().equals(excelImport.getCounty()))
                        || (!v.getDetailaddr().equals(excelImport.getDetailaddr())) || (!v.getContPerson().equals(excelImport.getContPerson()))
                        || (!v.getTel().equals(excelImport.getTel())) || (!v.getEmail().equals(excelImport.getEmail()))) {
                    builder1.append("【" + v.getWhName() + "】");
                }
            });
        }
        AtomicInteger line2 = new AtomicInteger(0);
        importParams.forEach(v -> {
            line2.addAndGet(1);
            //校验公司是否存在
            /*Optional<OrgOuRpcDTO> optional = ouRpcDTOS.stream().filter(o -> o.getOuCode().equals(v.getOuCode())).findFirst();
            if (optional.isEmpty()) {
                builder2.append("【" + line2 + "】");
            }*/
            //当功能区为”网格个人库的时候，“库存合作伙伴名称”为必填。
            if (v.getDeter2().equals("15")) {
                if (v.getPCode() == null) {
                    builder3.append("【" + line2 + "】");
                }
                //校验库存合作伙伴是否存在
                /*Optional<OrgEmpRpcDTO> first = empDtoByParam.stream().filter(e -> e.getEmpCode().equals(v.getPCode())).findFirst();
                if (first.isEmpty()) {
                    builder4.append("【" + line2 + "】");

                }*/
            } else {
                if (v.getPCode() != null) {
                    builder5.append("【" + line2 + "】");
                }
            }
        });
        //校验仓库编码是否存在
        AtomicInteger line3 = new AtomicInteger(0);
        if (!CollectionUtils.isEmpty(invWhRespVOS)) {
            importParams.forEach(v -> {
                line3.addAndGet(1);
                invWhRespVOS.forEach(v2 -> {
                    if (v2.getWhCode().equals(v.getWhCode())) {
                        builder6.append("【" + line3 + "】");
                    }
                });
            });
        }
        if (builder.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder.toString() + "行数据有空值,请检查！");
        }
        if (builder1.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "仓库名称为：" + builder1.toString() + "同一个仓库的基础信息不相同，请检查！");
        }
        if (builder2.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder2.toString() + "行公司不存在，请检查！");
        }
        if (builder3.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder3.toString() + "行功能区为网格个人库的时候时,库存合作伙伴编码必填，请检查！");
        }
        if (builder4.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder4.toString() + "行库存合作伙伴不存在，请检查！");
        }
        if (builder5.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder5.toString() + "行功能区不为网格个人库的时候时,库存合作伙伴名称不必填，请检查！");
        }
        if (builder6.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "第" + builder6.toString() + "仓库编码已存在，请检查！");
        }


    }

    /**
     * 根据地址号获取对应的地址信息集合
     *
     * @param addrNo 地址号
     * @return 地址号地址信息对象集合
     */
    private List<OrgAddrAddressRpcDTO> findOrgAddrAddressList(Long addrNo) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = orgOutService.findRpcDtoByAddrNo(addrNo);
        if (Objects.isNull(orgAddrDetailsRpcDto)) {
            return Lists.newArrayList();
        }

        return orgAddrDetailsRpcDto.getOrgAddrAddressVos();
    }

    /**
     * 根据地址号获取对应的单个地址信息
     *
     * @param addrNo 地址号
     * @return 地址号地址信息对象
     */
    private Optional<OrgAddrAddressRpcDTO> findOrgAddrAddress(Long addrNo) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = orgOutService.findRpcDtoByAddrNo(addrNo);
        if (Objects.isNull(orgAddrDetailsRpcDto)) {
            return Optional.empty();
        }

        val first = orgAddrDetailsRpcDto.getOrgAddrAddressVos().stream().findFirst();
        if (first.isEmpty()) {
            return Optional.empty();
        }
        return first;
    }

    @Override
    public List<InvWhRespVO> getDespatchWhByDeter2KeyWord(String deter2KeyWord) {
        return invWhRepoProc.getDespatchWhByDeter2KeyWord(deter2KeyWord);
    }

    @Override
    public List<InvWhRespVO> findWhByIdBatch(List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return new ArrayList<>();
        }
        return invWhRepoProc.findWhByIdBatch(ids);
    }

    @Override
    public List<InvWhRespVO> findWhByNameCode(String whNameCode) {
        return invWhRepoProc.findByWhNameCode(whNameCode);
    }

}

