package com.elitesland.yst.production.inv.application.service.impl;

import com.elitesland.yst.production.inv.application.service.NumSenderService;
import lombok.AllArgsConstructor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @author lvqf
 * @Date 2021/7/26
 * @Description
 */
@Component
@AllArgsConstructor
public class NumSenderServiceImpl implements NumSenderService {

    private final RedisTemplate<Object, Object> redisTemplate;
    @Override
    public Long incr(String key, long liveTime) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, redisTemplate.getConnectionFactory());
        Long increment = entityIdCounter.getAndIncrement()+1L;

        if ((null == increment || increment.longValue() == 0) && liveTime > 0) {//初始设置过期时间
            entityIdCounter.expire(liveTime, TimeUnit.HOURS);
        }
        return increment;
    }
}
