package com.elitesland.yst.production.inv.application.service.stk;

import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDtlDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkQtyResultDTO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 库存操作接口
 * @date 2022/04/25
 * @author sushiqi
 */

@Transactional(rollbackFor = Exception.class)
public interface InvStkOptService {

    /**
     * 库存操作
     * @param dtlDTO 库存场景配置
     * @param param  操作明细
     * @return
     */
    List<InvStkQtyResultDTO> stkOperatePortal(InvSceneConfigDtlDTO dtlDTO,String sceneCode, List<InvStkCommonOperateBodyDTO> param);
}
