package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.InvIoSearchBatchParam;
import com.elitesland.yst.production.inv.application.service.InvIoService;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/inv/invIo")
@Api(value = "出入库台账", tags = {"出入库台账"})
@AllArgsConstructor
public class InvIoController {

    private final InvIoService invIoService;

    @PostMapping("/stkAcct")
    @ApiOperation("库存查询-出入库台账-库存移动记录查询")
    public ApiResult<?> stkAcct(@RequestBody InvIoSearchBatchParam param){
        val ret=invIoService.searchStkAcct(param);
        return ApiResult.ok(ret);
    }
}
