package com.elitesland.yst.production.inv.application.web.controller.workflow;

import com.elitesland.yst.production.inv.application.service.InvAjProcessService;
import com.elitesland.yst.production.inv.constants.CallBackPathConstant;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * 库存调整工作流回调
 */
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(CallBackPathConstant.INV_ADJST_PATH)
public class InvAjCallBackController implements WorkflowCallBack {
    private final InvAjProcessService invAjProcessService;

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人:{}", payload.toString());
        //库存转移工作流回调
        return invAjProcessService.taskAssignee(null, payload.getCustomParams());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}",payload.toString());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调:{}",payload.toString());
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("状态修改回调:{}",payload.toString());
        invAjProcessService.processStatusChange(Long.parseLong(payload.getBusinessKey()), payload.getProcInstStatus());
    }
}
