package com.elitesland.yst.production.inv.domain.entity.ck;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvCkD extends BaseModel implements Serializable {
    private static final long serialVersionUID = -4007711596238924827L;

    @ApiModelProperty("主表ID")
    Long masId;

    @ApiModelProperty("行号")
    Double lineNo;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    String lineType;

    @ApiModelProperty("仓库ID")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("限定4")
    String deter4;

    @ApiModelProperty("限定5")
    String deter5;

    @ApiModelProperty("限定6")
    String deter6;

    @ApiModelProperty("限定7")
    String deter7;

    @ApiModelProperty("限定8")
    String deter8;

    @ApiModelProperty("品项ID")
    Long itemId;

    @ApiModelProperty("异构ID")
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("账面数")
    BigDecimal accQty;

    @ApiModelProperty("实盘数")
    BigDecimal factQty;

    @ApiModelProperty("差异数")
    BigDecimal diffQty;

    @ApiModelProperty("单位")
    String uom;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;



}
