package com.elitesland.yst.production.inv.domain.entity.ck;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lvqf
 * @date 2021-02-10
 */
@Entity
@Table(name = "inv_ck_d")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "inv_ck_d", comment = "库存盘点明细")
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "INV_CK_D", description = "库存盘点明细")
public class InvCkDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -3540495147067281958L;

    @ApiModelProperty("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20)  comment '主表ID'")
    Long masId;

    @ApiModelProperty("行号")
    @Column(columnDefinition = "NUMERIC(20,3)   comment '行号'")
    Double lineNo;

    @ApiModelProperty("行状态")
    @Column(name = "line_status", columnDefinition = "varchar(40)  comment '行状态'")
    String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    @Column(name = "line_type", columnDefinition = "varchar(40)  comment '行类型 [UDC]COM:IO'")
    String lineType;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "bigint(20)  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @Column(name = "deter1", columnDefinition = "varchar(40)  comment '温层 [UDC]INV:TEMP_TYPE'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name = "deter2", columnDefinition = "varchar(40)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("客户标识")
    @Column(name = "deter3", columnDefinition = "varchar(40)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name = "deter4", columnDefinition = "varchar(40)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name = "deter5", columnDefinition = "varchar(40)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name = "deter6", columnDefinition = "varchar(40)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name = "deter7", columnDefinition = "varchar(40)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name = "deter8", columnDefinition = "varchar(40)  comment '限定8'")
    String deter8;

    @ApiModelProperty("品项ID")
    @Column(name = "item_id", columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("异构ID")
    @Column(name = "vari_id", columnDefinition = "bigint default 0  comment '异构ID'")
    Long variId;

    @ApiModelProperty("批次")
    @Column(name = "lot_no", columnDefinition = "varchar(40)  comment '批次'")
    String lotNo;

    @ApiModelProperty("序列号")
    @Column(name = "sn_no", columnDefinition = "varchar(40)  comment '序列号'")
    String snNo;

    @ApiModelProperty("账面数")
    @Column(name = "acc_qty", columnDefinition = "NUMERIC(20,8) comment '账面数'")
    BigDecimal accQty;

    @ApiModelProperty("实盘数")
    @Column(name = "fact_qty", columnDefinition = "NUMERIC(20,8) comment '实盘数'")
    BigDecimal factQty;

    @ApiModelProperty("差异数")
    @Column(name = "diff_qty", columnDefinition = "NUMERIC(20,8) comment '差异数'")
    BigDecimal diffQty;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(40)  comment '单位'")
    String uom;

    @ApiModelProperty("库存合作伙伴编码")
    @Column(name = "p_code", columnDefinition = "varchar(40)  comment '库存合作伙伴编码'")
    private String pCode;

    @ApiModelProperty("库存合作伙伴类型")
    @Column(name = "p_type", columnDefinition = "varchar(40)  comment '库存合作伙伴类型'")
    private String pType;

   /* @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvCkDDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvCkDDO entity = (InvCkDDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }*/
}

