package com.elitesland.yst.production.inv.domain.entity.invwh;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @date 2021/5/28
 */
@Entity
@Table(name = "inv_wh_delivery")
@org.hibernate.annotations.Table(appliesTo = "inv_wh_delivery", comment = "配送范围")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
@ApiModel(value = "仓库配送范围表", description = "仓库配送范围表")
public class InvWhDeliveryDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("公司ID")
    @Column(name="ou_id" , columnDefinition = "bigint default 0  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("BUID 有OU和BU是为了同一客户在不同BU可能有不同属性")
    @Column(name="bu_id" , columnDefinition = "bigint default 0  comment 'BUID 有OU和BU是为了同一客户在不同BU可能有不同属性'")
    Long buId;

    @ApiModelProperty("仓库")
    @Column(name="wh_id" , columnDefinition = "bigint(20)  comment '仓库'")
    Long whId;

    @ApiModelProperty("是否配送全国")
    @Column(name = "all_area", columnDefinition = "int(18)  comment '是否配送全国'")
    Integer allArea;

    @ApiModelProperty("省编码")
    @Column(name="p_code" , columnDefinition = "varchar(40)  comment '省'")
    String pCode;

    @ApiModelProperty("省名")
    @Column(name="p_name" , columnDefinition = "varchar(40)  comment '省名'")
    String pName;

    @ApiModelProperty("市编码")
    @Column(name="c_code" , columnDefinition = "varchar(40)  comment '市编码'")
    String cCode;

    @ApiModelProperty("市名")
    @Column(name="c_name" , columnDefinition = "varchar(40)  comment '市名'")
    String cName;

    @ApiModelProperty("区/县编码")
    @Column(name="a_code" , columnDefinition = "varchar(10)  comment '县（区）'")
    String aCode;

    @ApiModelProperty("区/县名")
    @Column(name="a_name" , columnDefinition = "varchar(40)  comment '县（区）名'")
    String aName;

    @ApiModelProperty("乡/街道编码")
    @Column(name="s_code" , columnDefinition = "varchar(10)  comment '乡(街道)'")
    String sCode;

    @ApiModelProperty("乡/街道名")
    @Column(name="s_name" , columnDefinition = "varchar(40)  comment '乡(街道)名'")
    String sName;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvWhDeliveryDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvWhDeliveryDO entity = (InvWhDeliveryDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
