package com.elitesland.yst.production.inv.domain.entity.ioc;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:库存操作码
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvIoc extends BaseModel implements Serializable {
    private static final long serialVersionUID = 8161205375197747026L;

    @ApiModelProperty("操作码")
    private String ioCode;

    @ApiModelProperty("操作码名称")
    private String ioName;

    @ApiModelProperty("操作类型 [UDC]INV:IO_TYPE")
    private String ioType;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    private String status;


}
