package com.elitesland.yst.production.inv.infr.repo;
import com.elitesland.yst.production.inv.entity.QInvTrnDO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * @author jeesie.jiang
 * @date 2022-02-19 11:39
 * Desc:
 */
@Component
@AllArgsConstructor
public class InvTrnRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public Predicate where(List<Long> ids) {
        val jpaQDO = QInvTrnDO.invTrnDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDO.isNotNull());
        predicate = ExpressionUtils.and(predicate, jpaQDO.id.in(ids));
        return predicate;
    }


    public void updateDocStatusByIds(List<Long> ids,String docStatus){
        val jpaQDO = QInvTrnDO.invTrnDO;
        jpaQueryFactory.update(jpaQDO).set(jpaQDO.docStatus,docStatus).where(jpaQDO.id.in(ids)).execute();
    }

    public Predicate queryJdWhere() {
        val jpaQDO = QInvTrnDO.invTrnDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDO.isNotNull());
        predicate = ExpressionUtils.and(predicate, jpaQDO.docStatus.eq(UdcEnum.INV_TRN_STATUS_CF.getValueCode()));
        predicate = ExpressionUtils.and(predicate, jpaQDO.jdPoOrderNo.isNotNull());
        return predicate;
    }


}
