package com.elitesland.yst.production.inv.infr.repo.invwh;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Tuple;
import java.util.List;

@Repository
public interface InvWhRepo extends JpaRepository<InvWhDO, Long>, QuerydslPredicateExecutor<InvWhDO> {


    @Transactional(rollbackFor = Exception.class)
    void deleteByBuId(Long buId);

    List<InvWhDO> findByPhysicalWhCode(String physicalWhCode);

    List<InvWhDO> findByWhCode(String whCode);

    List<InvWhDO> findByWhType(String whType);

    List<InvWhDO> findByWhName(String whName);

    @Query("select id from InvWhDO where jdbadFlag=?1 and jdrelateCode=?2")
    List<InvWhDO> findByJdbadFlagAndJdrelateCode(int jdbadFlag, String jdRelateCode);

    /**
     * 销售待发货单后段下拉搜索蒙华
     *
     * @param phyCode 物理仓编号
     * @return 该编号的id
     */
    @Query("select id from InvWhDO where physicalWhCode=?1")
    List<Tuple> findIdByPhyCode(String phyCode);

    @Query(value = "select VV1.id,VV1.ou_id,VV1.item_id,VV1.wh_id,VV1.wh_code,VV1.wh_name,VV1.deter2name,vv1.p_code\n" +
            ",vv1.clokNum  ioRsvQty,vv2.lockNum rsvQty\n" +
            ",VV1.elseNum ioLockQty,vv2.elseNum  lockQty\n" +
            ",VV1.nowNum ioOhQty,vv2.nowNum ohQty\n" +
            ",VV1.yongNum  ioAvalQty,vv2.yongNum avalQty\n" +
            "from \n" +
            "(select id,ou_id,wh_code,wh_name,deter2name,item_id,wh_id,deter2,p_code\n" +
            ",sum(lock_soadd_qty)+sum(lock_sosub_qty)  clokNum\n" +
            ",sum(lock_add_qty)+sum(lock_sub_qty) elseNum\n" +
            ",(sum(i_qty)+sum(o_qty)-(sum(lock_add_qty)+sum(lock_soadd_qty)+sum(lock_sub_qty)+sum(lock_sosub_qty))) yongNum\n" +
            ",sum(i_qty)+sum(o_qty) nowNum\n" +
            "from  \n" +
            "(SELECT inv_io.id,inv_io.ou_id,inv_io.wh_id,inv_wh.wh_name,inv_wh.wh_code,inv_io.deter2,inv_wh_area_setting.deter2name,inv_io.item_id\n" +
            ", ifnull(CASE WHEN inv_io.io_code IN ('T_TYPE_20', 'T_TYPE_21', 'T_TYPE_22', 'T_TYPE_23' )\n" +
            "THEN inv_io.qty ELSE 0.0 END,0)  'lock_add_qty'\n" +
            ", ifnull(CASE WHEN inv_io.io_code IN ('T_TYPE_07_01' )\n" +
            "THEN inv_io.qty ELSE 0.0 END,0)  'lock_soadd_qty'\n" +
            ",ifnull(CASE WHEN inv_io.io_code IN ('T_TYPE_24', 'T_TYPE_25', 'T_TYPE_26', 'T_TYPE_27' )\n" +
            "THEN inv_io.qty ELSE 0.0 END,0) 'lock_sub_qty'\n" +
            ",ifnull(CASE WHEN inv_io.io_code IN ('T_TYPE_07_02' )\n" +
            "THEN inv_io.qty ELSE 0.0 END,0) 'lock_sosub_qty'\n" +
            ",ifnull(CASE WHEN inv_io.io_code IN ('I_TYPE_02', 'I_TYPE_04', 'I_TYPE_06', 'I_TYPE_15', 'I_TYPE_16', 'I_TYPE_18' )\n" +
            "THEN inv_io.qty ELSE 0.0 END,0)  'i_qty'\n" +
            ",ifnull(CASE WHEN inv_io.io_code IN ('O_TYPE_01_01', 'O_TYPE_03', 'O_TYPE_05', 'O_TYPE_14', 'O_TYPE_17', 'O_TYPE_19' )\n" +
            "THEN inv_io.qty ELSE 0.0 END ,0) 'o_qty'\n" +
            ",inv_io.p_code,inv_io.p_type,inv_io.lot_no,inv_io.create_time,inv_io.src_doc_no,inv_io.src_doc_cls,inv_io.src_doc_id,inv_io.src_doc_did\n" +
            "FROM inv_io inv_io \n" +
            "LEFT JOIN inv_wh ON inv_io.wh_id = inv_wh.id\n" +
            "left join inv_wh_area_setting on inv_io.deter2 =inv_wh_area_setting.deter2\n" +
            ") V1 group by item_id,wh_code,wh_name,deter2name,p_code\n" +
            ")VV1 right JOIN\n" +
            "(select wh_id,wh_code,item_id,deter2,deter2name,p_code\n" +
            ",sum(kuNum) nowNum,sum(lockNum) lockNum,sum(elseNum) elseNum\n" +
            ",sum(keNum) yongNum \n" +
            "from \n" +
            "(select inv_stk.wh_id,inv_wh.wh_code,inv_wh.wh_name,inv_stk.item_id,inv_stk.deter2,inv_wh_area_setting.deter2name,inv_stk.p_code\n" +
            ",ifnull(inv_stk.oh_qty,0) kuNum,ifnull(inv_stk.rsv_qty,0) lockNum,ifnull(lock_qty,0) elseNum,ifnull(inv_stk.aval_qty,0) keNum\n" +
            "from inv_stk \n" +
            "LEFT JOIN inv_wh ON inv_stk.wh_id = inv_wh.id\n" +
            "left join inv_wh_area_setting on inv_stk.deter2 =inv_wh_area_setting.deter2\n" +
            ") V2 GROUP BY  wh_id,wh_code,item_id ,item_id,deter2,deter2name,p_code\n" +
            ") VV2 \n" +
            "on vv1.wh_id=vv2.wh_id and vv1.item_id=vv2.item_id and vv1.deter2=vv2.deter2 and ifnull(vv1.p_code,'pcode')=ifnull(vv2.p_code,'pcode')\n" +
            "where (vv1.clokNum-vv2.lockNum <>0\n" +
            "or VV1.elseNum-vv2.elseNum <>0 \n" +
            "or VV1.nowNum -vv2.nowNum <>0\n" +
            "or VV1.yongNum- vv2.yongNum <>0 )", nativeQuery = true)
    List<Tuple> findFirstCheck();

    boolean existsByWhCode(String whCode);

    boolean existsByWhCodeAndPid(String whCode, Long pid);

    List<InvWhRespVO> findByPid(Long pid);
}
