/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAsmService;
import com.elitesland.yst.production.inv.domain.convert.InvAsmConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAsm;
import com.elitesland.yst.production.inv.domain.entity.InvAsmD;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmRepoProc;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvAsmServiceImpl
implements InvAsmService {
    private static final Logger log = LoggerFactory.getLogger(InvAsmServiceImpl.class);
    private final InvAsmRepo invAsmRepo;
    private final InvAsmRepoProc invAsmRepoProc;
    private final InvAsmDRepo invAsmDRepo;
    private final InvWhDomainService invWhService;
    private final SystemService systemService;
    private final OrgOutService outouService;
    private final InvAsmDomainService invAsmDomainService;
    private final InvAsmDDomainService invAsmDDomainService;
    private final WorkflowService workflowService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    @Override
    public Optional<InvAsmRespVO> findIdOne(Long id) {
        Optional<InvAsmRespVO> invAsmVo = this.invAsmRepo.findById(id).map(invAsmDO -> (InvAsmRespVO)BeanUtil.copyProperties((Object)invAsmDO, InvAsmRespVO.class, (String[])new String[0]));
        if (invAsmVo.isPresent()) {
            OrgEmpRpcDTO empRpcDTO;
            Optional<InvWhRespVO> wh = this.invWhService.findIdOne(invAsmVo.get().getWhId() != null ? invAsmVo.get().getWhId() : 0L);
            if (wh.isPresent()) {
                invAsmVo.get().setWhName(wh.get().getWhName());
            }
            if (invAsmVo.get().getApplyEmpId() != null && (empRpcDTO = this.outouService.findEmpById(invAsmVo.get().getApplyEmpId())) != null) {
                invAsmVo.get().setApplyEmpName(empRpcDTO.getEmpName());
            }
            invAsmVo = this.udcChange(invAsmVo);
            return invAsmVo;
        }
        return invAsmVo;
    }

    @Override
    @Transactional
    public Long create(InvAsmAndAsmDSaveVO inv) {
        inv.getHeader().setDeleteFlag(0);
        inv.getDetails().stream().forEach(v -> v.setDeleteFlag(0));
        if (inv.getHeader().getId() == null) {
            inv.getHeader().setDocStatus(UdcEnum.INV_ASM_STATUS_DR.getValueCode());
            inv.getHeader().setDocType(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            ArrayList<String> runtimeValues = new ArrayList<String>();
            runtimeValues.add(String.valueOf(inv.getHeader().getOuCode()));
            String code = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IY.getCode(), runtimeValues);
            inv.getHeader().setDocNo(inv.getHeader().getDocNo() != null ? inv.getHeader().getDocNo() : code);
        } else {
            Optional<InvAsmDTO> invAsmDOOptional = this.invAsmDomainService.findIdOne(inv.getHeader().getId());
            if (invAsmDOOptional.isPresent()) {
                InvAsmDTO invAsmDTO = invAsmDOOptional.get();
                String procInstId = invAsmDTO.getProcInstId();
                inv.getHeader().setProcInstId(procInstId);
                inv.getHeader().setDocNo(invAsmDTO.getDocNo());
                inv.getHeader().setApprComment(invAsmDTO.getApprComment());
                inv.getHeader().setProcInstStatus(invAsmDTO.getProcInstStatus());
                inv.getHeader().setSubmitTime(invAsmDTO.getSubmitTime());
                inv.getHeader().setCreateTime(LocalDateTime.now());
            }
            List<InvAsmDDO> invAsmDDOS = this.invAsmDDomainService.findByMasId(inv.getHeader().getId());
            List<Long> detailIds = invAsmDDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
            this.invAsmDDomainService.deleteBatch(detailIds);
        }
        InvAsm asm = InvAsmConvert.INSTANCE.voToAsm(inv.getHeader());
        Long id = this.invAsmDomainService.create(asm);
        AtomicDouble linoNo = new AtomicDouble(0.0);
        if (inv.getDetails().size() > 0) {
            List detailDOs = inv.getDetails().stream().map(d -> {
                d.setCreateTime(LocalDateTime.now());
                d.setMasId(id);
                d.setLineNo(linoNo.addAndGet(1.0));
                return d;
            }).collect(Collectors.toList());
            List<InvAsmD> invAsmDS = detailDOs.stream().map(InvAsmDConvert.INSTANCE::voToAsmd).collect(Collectors.toList());
            this.invAsmDDomainService.createBatch(invAsmDS);
        }
        return id;
    }

    @Override
    @Transactional
    public List<Long> updateStatusInBatch(List<Long> ids, String status) {
        Iterable asms = this.invAsmRepo.findAll(this.invAsmRepoProc.where(ids));
        ArrayList listAsms = Lists.newArrayList((Iterable)asms);
        if (listAsms.size() > 0) {
            listAsms.stream().forEach(a -> a.setDocStatus(status));
            List<Long> ret = this.updateInBatch(listAsms);
            return ret;
        }
        return ids;
    }

    @Override
    @Transactional
    public Long submit(Long id) {
        SysUserDTO user = this.systemService.sysUserCurrent();
        if (user == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        InvAsmDO invAsmDO = (InvAsmDO)this.invAsmRepo.findById(id).orElseThrow(new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728"));
        List<InvAsmDDO> invAsmDDOS = this.invAsmDRepo.findByMasId(id);
        if (invAsmDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invAsmDO.getProcInstStatus())) {
            String procInstName = ProcDefKey.INV_ASM.getDesc() + invAsmDO.getDocNo();
            this.startWorkFlow(ProcDefKey.INV_ASM.name(), procInstName, "" + invAsmDO.getId(), "" + user.getId(), id);
        } else {
            invAsmDO.setDocStatus(UdcEnum.INV_ASM_STATUS_APPING.getValueCode());
            invAsmDO.setIoDate(LocalDateTime.now());
            this.invAsmRepo.save(invAsmDO);
        }
        return id;
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAsmDDO> invAsmDDOS, InvAsmDO invAsmDO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invAsmDDOS.stream().forEach(invAsmDDO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAsmDO.getWhId());
            operateBodyDTO.setItemId(invAsmDDO.getItemId());
            operateBodyDTO.setDeter2(invAsmDO.getDeter2());
            operateBodyDTO.setSrcDocId(invAsmDO.getId());
            operateBodyDTO.setDocNo(invAsmDO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAsmDDO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_ASM.getValueCode());
            operateBodyDTO.setLineNo(invAsmDDO.getLineNo());
            operateBodyDTO.setCreateUserId(invAsmDO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAsmDDO.getUom());
            operateBodyDTO.setQty(invAsmDDO.getQty());
            operateBodyDTO.setLotNo(invAsmDDO.getLotNo());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }

    private void startWorkFlow(String processDefinitionKey, String procInstName, String businessKey, String currentUserId, Long id) {
        try {
            WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)processDefinitionKey, (String)procInstName, (String)businessKey, null));
            log.info("\u5e93\u5b58\u8f6c\u79fb\u542f\u52a8\u6d41\u7a0b\u8fd4\u56de:" + processInfoWorkflowResult);
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
            }
            QInvAsmDO qInvAsmDO = QInvAsmDO.invAsmDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvAsmDO).set((Path)qInvAsmDO.procInstId, (Object)((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstId()).set(qInvAsmDO.submitTime, (Object)LocalDateTime.now()).set(qInvAsmDO.ioDate, (Object)LocalDateTime.now()).where(new Predicate[]{qInvAsmDO.id.eq((Object)id)});
            if (!Objects.equals(((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qInvAsmDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)qInvAsmDO.docStatus, (Object)UdcEnum.INV_TRN_STATUS_APPING.getValueCode());
            }
            jpaUpdateClause.execute();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u5f00\u542f\u5de5\u4f5c\u6d41\u670d\u52a1\u5931\u8d25:" + e.getMessage());
        }
    }

    public List<Long> updateInBatch(List<InvAsmDO> list) {
        return this.invAsmRepo.saveAll(list).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    public Optional<InvAsmRespVO> udcChange(Optional<InvAsmRespVO> invAsmVo) {
        Map<String, String> udcDocType = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_TYPE_DEF.getModel(), UdcEnum.INV_ASM_TYPE_DEF.getCode());
        Map<String, String> udcDocStatus = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_ASM_STATUS_DR.getModel(), UdcEnum.INV_ASM_STATUS_DR.getCode());
        Map<String, String> udcApprStatus = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());
        Map<String, String> udcDeter1 = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
        areaParamVO.setDeter2(invAsmVo.get().getDeter2());
        areaParamVO.setWhId(invAsmVo.get().getWhId());
        List<InvWhAreaRespVO> whAreasByParam = this.invWhAreaDomainService.findWhAreasByParam(areaParamVO);
        Map<String, String> udcReasonCode = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_183.getModel(), UdcEnum.COM_REASON_CODE_183.getCode());
        Map<String, String> udcRelateDocCls = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_SPA.getModel(), UdcEnum.COM_DOC_CLS_SPA.getCode());
        invAsmVo.stream().forEach(Asm -> {
            if (StringUtils.isNotBlank((CharSequence)Asm.getDocType()) && !MapUtils.isEmpty((Map)udcDocType)) {
                Asm.setDocTypeName((String)udcDocType.get(Asm.getDocType()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getDocStatus()) && !MapUtils.isEmpty((Map)udcDocStatus)) {
                Asm.setDocStatusName((String)udcDocStatus.get(Asm.getDocStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getApprStatus()) && !MapUtils.isEmpty((Map)udcApprStatus)) {
                Asm.setApprStatusName((String)udcApprStatus.get(Asm.getApprStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getDeter1()) && !MapUtils.isEmpty((Map)udcDeter1)) {
                Asm.setDeter1Name((String)udcDeter1.get(Asm.getDeter1()));
            }
            if (!CollectionUtils.isEmpty((Collection)whAreasByParam)) {
                whAreasByParam.stream().filter(i -> i.getWhId().equals(Asm.getWhId()) && i.getDeter2().equals(Asm.getDeter2())).findAny().ifPresent(m -> Asm.setDeter2Name(m.getDeter2Name()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getReasonCode()) && !MapUtils.isEmpty((Map)udcReasonCode)) {
                Asm.setReasonCodeName((String)udcReasonCode.get(Asm.getReasonCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)Asm.getRelateDocCls()) && !MapUtils.isEmpty((Map)udcRelateDocCls)) {
                Asm.setRelateDocClsName((String)udcRelateDocCls.get(Asm.getRelateDocCls()));
            }
        });
        return invAsmVo;
    }

    public InvAsmServiceImpl(InvAsmRepo invAsmRepo, InvAsmRepoProc invAsmRepoProc, InvAsmDRepo invAsmDRepo, InvWhDomainService invWhService, SystemService systemService, OrgOutService outouService, InvAsmDomainService invAsmDomainService, InvAsmDDomainService invAsmDDomainService, WorkflowService workflowService, InvWhAreaDomainService invWhAreaDomainService) {
        this.invAsmRepo = invAsmRepo;
        this.invAsmRepoProc = invAsmRepoProc;
        this.invAsmDRepo = invAsmDRepo;
        this.invWhService = invWhService;
        this.systemService = systemService;
        this.outouService = outouService;
        this.invAsmDomainService = invAsmDomainService;
        this.invAsmDDomainService = invAsmDDomainService;
        this.workflowService = workflowService;
        this.invWhAreaDomainService = invWhAreaDomainService;
    }
}

