/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.export.invwh.InvWhAreaImport;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliverySaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeter2RespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhExcelImport;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhListRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.OrgBuOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.application.service.InvWhDeliveryService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.application.service.NumSenderService;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import com.elitesland.yst.production.inv.infr.repo.InvWhDeliveryRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepoProc;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhDeliveryProc;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepoProc;
import com.elitesland.yst.production.inv.infr.repo.whAreaSetting.InvWhAreaSettingRepo;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.InvStringUtil;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.invwh.InvWhDeliveryFlagEnum;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrAddressRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.google.common.collect.Lists;
import com.querydsl.jpa.impl.JPAQuery;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="invWhService")
public class InvWhServiceImpl
implements InvWhService {
    private static final Logger log = LoggerFactory.getLogger(InvWhServiceImpl.class);
    private final SystemService systemService;
    private final InvWhRepoProc invWhRepoProc;
    private final InvWhRepo invWhRepo;
    private final InvWhAreaService invWhAreaService;
    private final InvWhAreaRepoProc invWhAreaRepoProc;
    private final InvWhDeliveryProc invWhDeliveryProc;
    private final InvWhDeliveryRepo invWhDeliveryRepo;
    private final InvWhDeliveryService invWhDeliveryService;
    private final InvWhAreaSettingService invWhAreaSettingService;
    private final InvWhAreaSettingRepo invWhAreaSettingRepo;
    private final InvWhAreaRepo invWhAreaRepo;
    private final NumSenderService numSenderService;
    private final OrgOutService orgOutService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final Integer TUIHUOFLAG = 1;
    private final InvWhAreaSettingDomainService invWhAreaSettingDomainService;
    private final OrgBuOutService orgBuOutService;
    private final InvDespatchConfigDomainService invDespatchConfigDomainService;

    @Override
    public PagingVO<InvWhAreaRespVO> searchWhArea(InvWhAreaParamVO param) {
        InvWhParamVO whQueryParam = new InvWhParamVO();
        whQueryParam.setKeyword(param.getKeyword());
        whQueryParam.setWhCode(param.getWhCode());
        whQueryParam.setWhName(param.getWhName());
        whQueryParam.setOtherWhCode(param.getOtherWhCode());
        whQueryParam.setOtherWhType(param.getOtherWhType());
        whQueryParam.setOuId(param.getOuId());
        whQueryParam.setBelongBuId(param.getBelongBuId());
        whQueryParam.setId(param.getId());
        whQueryParam.setBusinessCode(param.getBusinessCode());
        whQueryParam.setWhTypes(param.getWhTypes());
        whQueryParam.setMultiKeywords(param.getMultiKeywords());
        whQueryParam.setWhType(param.getWhType());
        whQueryParam.setWhType2(param.getWhType2());
        whQueryParam.setWhStatus(param.getWhStatus());
        whQueryParam.setDesCode(param.getDesCode());
        whQueryParam.setDesCodeList(param.getDesCodeList());
        PagingVO<InvWhRespVO> orgWhVOPagingVO = this.invWhAreaService.searchWh(whQueryParam);
        List invWhRespVOList = orgWhVOPagingVO.getRecords();
        if (CollectionUtils.isEmpty((Collection)invWhRespVOList)) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        List<Long> whIds = invWhRespVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        param.setWhIds(whIds);
        if (param.getSize() == null && param.getCurrent() == null) {
            param.setSize(1000);
        }
        PagingVO<InvWhAreaRespVO> search = this.invWhAreaService.search(param);
        List invWhAreaRespVOS = search.getRecords();
        this.translateWh(invWhRespVOList);
        this.translateWhArea(invWhAreaRespVOS, invWhRespVOList);
        return search;
    }

    @Transactional
    public List<Long> createWhBatch(List<InvWhSaveVO> invWhSaveVOS) {
        ArrayList whDOList = new ArrayList();
        ArrayList<InvWhAreaSaveVO> invWhAreaVOS = new ArrayList<InvWhAreaSaveVO>();
        invWhSaveVOS.forEach(v -> {
            long count;
            if (!CollectionUtils.isEmpty(v.getOrgWhAreaCreateParamList()) && (count = v.getOrgWhAreaCreateParamList().stream().map(i -> i.getDeter2() + "_" + i.getPType() + "_" + i.getPCode()).distinct().count()) != (long)v.getOrgWhAreaCreateParamList().size()) {
                throw new BusinessException(ApiCode.FAIL, "\u540c\u4e00\u4ed3\u5e93\u540c\u4e00\u5e93\u5b58\u5408\u4f5c\u4f19\u4f34\uff0c\u529f\u80fd\u533a\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            InvWhDO invWhDO = (InvWhDO)BeanUtil.copyProperties((Object)v, InvWhDO.class, (String[])new String[0]);
            Long addrNo = this.saveAddressAndQualifyAndBankAcc(false, null, (InvWhSaveVO)v);
            invWhDO.setAddrNo(addrNo);
            invWhDO.setCreateTime(LocalDateTime.now());
            whDOList.add(invWhDO);
        });
        List invWhDOS = this.invWhRepo.saveAll(whDOList);
        invWhSaveVOS.forEach(v -> invWhDOS.forEach(v2 -> {
            if (v2.getWhCode().equals(v.getWhCode())) {
                List invWhAreaSaveVOS = v.getOrgWhAreaCreateParamList().stream().map(invWhAreaSaveVO -> {
                    invWhAreaSaveVO.setWhId(v2.getId());
                    invWhAreaSaveVO.setCreateTime(LocalDateTime.now());
                    invWhAreaSaveVO.setDeter3(invWhAreaSaveVO.getPCode());
                    return invWhAreaSaveVO;
                }).collect(Collectors.toList());
                invWhAreaVOS.addAll(invWhAreaSaveVOS);
            }
        }));
        this.invWhAreaService.createBatch(invWhAreaVOS);
        return invWhDOS.stream().map(v -> v.getId()).collect(Collectors.toList());
    }

    @Override
    public PagingVO<InvWhAreaRespVO> listWhArea(InvWhAreaParamVO param) {
        PagingVO<InvWhAreaRespVO> search;
        List invWhAreaRespVOS;
        if (param.getWhCode() != null || param.getWhName() != null || param.getWhType() != null || param.getOuId() != null || param.getWhStatus() != null || StringUtils.isNotBlank((CharSequence)param.getDesCode()) || CollectionUtil.isNotEmpty(param.getDesCodeList())) {
            InvWhParamVO whQueryParam = new InvWhParamVO();
            whQueryParam.setWhCode(param.getWhCode());
            whQueryParam.setWhName(param.getWhName());
            whQueryParam.setOuId(param.getOuId());
            whQueryParam.setBelongBuId(param.getBelongBuId());
            whQueryParam.setWhTypes(param.getWhTypes());
            whQueryParam.setMultiKeywords(param.getMultiKeywords());
            whQueryParam.setWhType(param.getWhType());
            whQueryParam.setWhStatus(param.getWhStatus());
            whQueryParam.setDesCode(param.getDesCode());
            whQueryParam.setDesCodeList(param.getDesCodeList());
            List<InvWhRespVO> invWhRespVOList = this.invWhAreaService.searchWhByParam(whQueryParam);
            List<Long> whIds = invWhRespVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(whIds)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            param.setWhIds(whIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(invWhAreaRespVOS = (search = this.invWhAreaDomainService.searchPaging(param)).getRecords()))) {
            List<Long> whIds2 = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            param.setWhIds(whIds2);
            List<InvWhRespVO> whRespVOS = this.invWhDomainService.findByWhIds(whIds2);
            this.translateWh(whRespVOS);
            this.translateWhArea(invWhAreaRespVOS, whRespVOS);
        }
        return search;
    }

    @Override
    @Transactional
    public Long createWh(InvWhSaveVO invWhSaveVO) {
        this.verifyWhareas(invWhSaveVO.getOrgWhAreaCreateParamList(), invWhSaveVO);
        Long id = invWhSaveVO.getId();
        ArrayList runtimeValues = new ArrayList();
        if (invWhSaveVO.getOuCode() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u6709\u8bef\uff0c\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (id == null) {
            String whcode = this.getIncrForWhcode(invWhSaveVO);
            invWhSaveVO.setWhCode(whcode);
            while (this.existVerify(id, invWhSaveVO.getWhCode()).booleanValue()) {
                String whCode = this.getIncrForWhcode(invWhSaveVO);
                invWhSaveVO.setWhCode(whCode);
            }
        }
        if (!CollectionUtils.isEmpty(invWhSaveVO.getDesCodeList())) {
            String codeString = InvStringUtil.transitionCodesToStr(invWhSaveVO.getDesCodeList());
            invWhSaveVO.setDesCode(codeString);
        }
        InvWhDO invWhDO = (InvWhDO)BeanUtil.copyProperties((Object)invWhSaveVO, InvWhDO.class, (String[])new String[0]);
        Optional optional = Optional.empty();
        if (id != null) {
            optional = this.invWhRepo.findById(id);
        }
        if (optional.isPresent()) {
            this.saveAddressAndQualifyAndBankAcc(true, ((InvWhDO)optional.get()).getAddrNo(), invWhSaveVO);
            this.invWhAreaDomainService.deleteByWhId(id);
            this.invWhDeliveryRepo.deleteByWhId(id);
            if (((InvWhDO)optional.get()).getSecBuId() != null) {
                invWhSaveVO.setSecBuId(((InvWhDO)optional.get()).getSecBuId());
            }
            invWhDO.setSecBuId(((InvWhDO)optional.get()).getSecBuId());
            invWhDO.setSecUserId(((InvWhDO)optional.get()).getSecUserId());
            invWhDO.setSecOuId(((InvWhDO)optional.get()).getOuId());
            invWhDO.setRelateOuId(((InvWhDO)optional.get()).getRelateOuId());
            this.update(invWhDO);
        } else {
            Long addrNo = this.saveAddressAndQualifyAndBankAcc(false, null, invWhSaveVO);
            invWhDO.setAddrNo(addrNo);
            invWhDO.setCreateTime(LocalDateTime.now());
            invWhDO.setAddrNo(addrNo);
            invWhDO.setCreateTime(LocalDateTime.now());
            invWhDO.setSecUserId(invWhSaveVO.getSecUserId());
            invWhDO.setSecOuId(invWhSaveVO.getOuId());
            id = ((InvWhDO)this.invWhRepo.save(invWhDO)).getId();
        }
        Long finalId = id;
        List<InvWhAreaSaveVO> invWhAreaSaveVOS = this.getInvWhAreaSaveVOS(invWhSaveVO, invWhDO, finalId);
        this.invWhAreaService.createBatch(invWhAreaSaveVOS);
        if (!CollectionUtils.isEmpty(invWhSaveVO.getDeliveryAreas()) && invWhSaveVO.getDeliveryAreas().size() > 0) {
            if (invWhSaveVO.getDeliveryAreas().get(0).getAllArea() != null && invWhSaveVO.getDeliveryAreas().get(0).getAllArea().equals(InvWhDeliveryFlagEnum.C1.getCode())) {
                InvWhDeliverySaveVO invWhDeliverySaveVO2 = invWhSaveVO.getDeliveryAreas().get(0);
                invWhDeliverySaveVO2.setWhId(finalId);
                invWhDeliverySaveVO2.setOuId(invWhSaveVO.getOuId());
                invWhDeliverySaveVO2.setBuId(invWhDO.getBuId());
                this.invWhDeliveryService.createOne(invWhDeliverySaveVO2);
            } else {
                List<InvWhDeliverySaveVO> deliverySaveVOS = invWhSaveVO.getDeliveryAreas().stream().map(invWhDeliverySaveVO -> {
                    invWhDeliverySaveVO.setWhId(finalId);
                    invWhDeliverySaveVO.setOuId(invWhSaveVO.getOuId());
                    invWhDeliverySaveVO.setBuId(invWhDO.getSecBuId());
                    return invWhDeliverySaveVO;
                }).collect(Collectors.toList());
                this.invWhDeliveryService.createBatch(deliverySaveVOS);
            }
        }
        return id;
    }

    private List<InvWhAreaSaveVO> getInvWhAreaSaveVOS(InvWhSaveVO invWhSaveVO, InvWhDO invWhDO, Long finalId) {
        List<InvWhAreaSaveVO> invWhAreaSaveVOS = invWhSaveVO.getOrgWhAreaCreateParamList().stream().map(invWhAreaSaveVO -> {
            invWhAreaSaveVO.setWhId(finalId);
            invWhAreaSaveVO.setCreateTime(LocalDateTime.now());
            invWhAreaSaveVO.setDeter3(invWhAreaSaveVO.getPCode());
            invWhAreaSaveVO.setSecBuId(invWhDO.getSecBuId());
            invWhAreaSaveVO.setSecUserId(invWhDO.getSecUserId());
            invWhAreaSaveVO.setSecOuId(invWhDO.getOuId());
            return invWhAreaSaveVO;
        }).collect(Collectors.toList());
        return invWhAreaSaveVOS;
    }

    private void setDefaultDeter2(InvWhSaveVO invWhSaveVO, InvWhDO invWhDO, Long finalId, List<InvWhAreaSaveVO> invWhAreaSaveVOS) {
        long count = invWhAreaSaveVOS.stream().filter(v -> UdcEnum.INV_FUNC_TYPE_9.getValueCode().equals(v.getDeter2())).distinct().count();
        if (count == 0L && !invWhSaveVO.getWhType().equals(UdcEnum.INV_WH_TYPE_6.getValueCode())) {
            InvWhAreaSaveVO whAreaSaveVO = new InvWhAreaSaveVO(){};
            whAreaSaveVO.setDeter2(UdcEnum.INV_FUNC_TYPE_9.getValueCode());
            whAreaSaveVO.setWhId(finalId);
            whAreaSaveVO.setSecBuId(invWhDO.getSecBuId());
            whAreaSaveVO.setSecUserId(invWhDO.getSecUserId());
            whAreaSaveVO.setSecOuId(invWhDO.getOuId());
            invWhAreaSaveVOS.add(whAreaSaveVO);
        }
    }

    private void verifyWhareas(List<InvWhAreaSaveVO> invWhAreaSaveVOS, InvWhSaveVO param) {
        List<InvWhRespVO> respVOS;
        List<InvWhRespVO> whRespVOS;
        List<InvWhDO> invWhDOS = this.invWhRepo.findByWhName(param.getWhName());
        if (!CollectionUtils.isEmpty(invWhDOS)) {
            invWhDOS.stream().filter(wh -> !wh.getId().equals(param.getId())).findAny().ifPresent(m -> {
                throw new BusinessException(ApiCode.FAIL, String.format("\u4ed3\u5e93\u540d\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d", param.getWhName()));
            });
        }
        if (!CollectionUtils.isEmpty(param.getOrgWhAreaCreateParamList())) {
            List<InvWhAreaRespVO> whAreaByDeter2Names;
            List<String> deter2s = param.getOrgWhAreaCreateParamList().stream().map(InvWhAreaSaveVO::getDeter2).distinct().collect(Collectors.toList());
            if (deter2s.size() != param.getOrgWhAreaCreateParamList().size()) {
                throw new BusinessException(ApiCode.FAIL, "\u529f\u80fd\u533a\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            List<String> deter2Names = param.getOrgWhAreaCreateParamList().stream().map(InvWhAreaSaveVO::getDeter2Name).distinct().collect(Collectors.toList());
            if (deter2Names.size() != param.getOrgWhAreaCreateParamList().size()) {
                throw new BusinessException(ApiCode.FAIL, "\u529f\u80fd\u533a\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
            areaParamVO.setDeter2s(deter2s);
            List<InvWhAreaRespVO> invWhAreaRespVOS = this.invWhAreaDomainService.findWhAreasByParam(areaParamVO);
            if (!CollectionUtils.isEmpty(invWhAreaRespVOS)) {
                for (String deter2 : deter2s) {
                    long deter2Count = invWhAreaRespVOS.stream().filter(i -> i.getDeter2().equals(deter2)).count();
                    if (param.getId() != null && deter2Count > 1L) {
                        throw new BusinessException(ApiCode.FAIL, String.format("\u529f\u80fd\u533a\u7f16\u7801\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", deter2));
                    }
                    if (param.getId() != null || deter2Count <= 0L) continue;
                    throw new BusinessException(ApiCode.FAIL, String.format("\u529f\u80fd\u533a\u7f16\u7801\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", deter2));
                }
            }
            if (!CollectionUtils.isEmpty(whAreaByDeter2Names = this.invWhAreaDomainService.findByDeter2Names(deter2Names))) {
                for (String deter2Name : deter2Names) {
                    long deter2NameCount = whAreaByDeter2Names.stream().filter(i -> i.getDeter2Name().equals(deter2Name)).count();
                    if (param.getId() != null && deter2NameCount > 1L) {
                        throw new BusinessException(ApiCode.FAIL, String.format("\u529f\u80fd\u533a\u540d\u79f0\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", deter2Name));
                    }
                    if (param.getId() != null || deter2NameCount <= 0L) continue;
                    throw new BusinessException(ApiCode.FAIL, String.format("\u529f\u80fd\u533a\u540d\u79f0\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", deter2Name));
                }
            }
        }
        if (this.TUIHUOFLAG == param.getTuihuoFlag() && !CollectionUtils.isEmpty(whRespVOS = this.invWhRepoProc.selectWhByOuIdAndTuihuoFlag(param.getOuId(), this.TUIHUOFLAG))) {
            if (param.getId() != null) {
                whRespVOS.stream().filter(v -> !v.getId().equals(param.getId())).findAny().ifPresent(i -> {
                    throw new BusinessException(ApiCode.FAIL, String.format("%s\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u9000\u8d27\u4ed3\u5bf9\u63a5\u4ed3\uff0c\u4e0d\u5141\u8bb8\u540c\u4e00\u5bb6\u516c\u53f8\u6709\u4e24\u4e2a\u9000\u8d27\u4ed3\u5bf9\u63a5\u4ed3\uff01", param.getOuCode()));
                });
            } else {
                throw new BusinessException(ApiCode.FAIL, String.format("%s\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u9000\u8d27\u4ed3\u5bf9\u63a5\u4ed3\uff0c\u4e0d\u5141\u8bb8\u540c\u4e00\u5bb6\u516c\u53f8\u6709\u4e24\u4e2a\u9000\u8d27\u4ed3\u5bf9\u63a5\u4ed3\uff01", param.getOuCode()));
            }
        }
        if (UdcEnum.INV_WH_PROP_AFTERSAL.getValueCode().equals(param.getEs1()) && !CollectionUtils.isEmpty(respVOS = this.invWhRepoProc.selectWhByOuIdAndEs1(param.getOuId(), UdcEnum.INV_WH_PROP_AFTERSAL.getValueCode()))) {
            if (param.getId() != null) {
                respVOS.stream().filter(v -> !v.getId().equals(param.getId())).findAny().ifPresent(i -> {
                    throw new BusinessException(ApiCode.FAIL, String.format("%s\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u552e\u540e\u5bf9\u63a5\u4ed3\uff0c\u4e0d\u5141\u8bb8\u540c\u4e00\u5bb6\u516c\u53f8\u6709\u4e24\u4e2a\u552e\u540e\u5bf9\u63a5\u4ed3\uff01", param.getOuCode()));
                });
            } else {
                throw new BusinessException(ApiCode.FAIL, String.format("%s\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u552e\u540e\u5bf9\u63a5\u4ed3\uff0c\u4e0d\u5141\u8bb8\u540c\u4e00\u5bb6\u516c\u53f8\u6709\u4e24\u4e2a\u552e\u540e\u5bf9\u63a5\u4ed3\uff01", param.getOuCode()));
            }
        }
    }

    private void verifyWhType(List<InvWhAreaSaveVO> invWhAreaSaveVOS, InvWhSaveVO param) {
        if (UdcEnum.INV_WH_TYPE_3.getValueCode().equals(param.getWhType())) {
            List<String> pcodes = invWhAreaSaveVOS.stream().map(InvWhAreaSaveVO::getPCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
            areaParamVO.setPCodes(pcodes);
            areaParamVO.setDeter2(UdcEnum.INV_FUNC_TYPE_15.getValueCode());
            List<InvWhAreaRespVO> invWhAreaRespVOS = this.invWhAreaDomainService.findWhAreasByParam(areaParamVO);
            if (!CollectionUtils.isEmpty(invWhAreaRespVOS)) {
                invWhAreaRespVOS.stream().filter(a -> !a.getWhId().equals(param.getId())).findAny().ifPresent(m -> {
                    throw new BusinessException(ApiCode.FAIL, String.format("\u8be5\u7f51\u683c\u5458\u3010%s\u3011\u5df2\u5b58\u5728\u4e8e\u53e6\u4e00\u4e2a\u4ed3\u5e93\u4e2d\uff0c\u4e0d\u53ef\u91cd\u590d", m.getPCode()));
                });
            }
        }
    }

    private String getIncrForWhcode(InvWhSaveVO param) {
        Long num = this.numSenderService.incr("numSender:yst-inv:WHOuCode" + param.getOuCode(), 0L);
        DecimalFormat df = new DecimalFormat("000");
        String numStr = df.format(num);
        String whCode = "WH" + param.getOuCode() + numStr;
        return whCode;
    }

    private OrgAddrRpcSaveParam reduceOrgAddrRpcSaveParam(Long addrNo, InvWhSaveVO param) {
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
        orgAddrRpcSaveParam.setId(param.getAddressId());
        orgAddrRpcSaveParam.setAddrNo(addrNo);
        orgAddrRpcSaveParam.setAddrName(param.getWhName());
        orgAddrRpcSaveParam.setAddrType(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode());
        ArrayList<OrgAddrAddressRpcSaveParam> orgAddrAddressSaveParams = new ArrayList<OrgAddrAddressRpcSaveParam>();
        OrgAddrAddressRpcSaveParam orgAddrAddressVO = new OrgAddrAddressRpcSaveParam();
        orgAddrAddressVO.setDetailAddr(param.getDetailaddr());
        orgAddrAddressVO.setCountry(param.getCountry());
        orgAddrAddressVO.setProvince(param.getProvince());
        orgAddrAddressVO.setCity(param.getCity());
        orgAddrAddressVO.setCounty(param.getCounty());
        orgAddrAddressVO.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
        orgAddrAddressVO.setDefaultFlag(Boolean.valueOf(true));
        orgAddrAddressVO.setEmail(param.getEmail());
        orgAddrAddressVO.setContPerson(param.getContPerson());
        orgAddrAddressVO.setTel(param.getTel());
        orgAddrAddressSaveParams.add(orgAddrAddressVO);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressSaveParams);
        return orgAddrRpcSaveParam;
    }

    private OrgBuRpcSaveParam orgBuRpcSaveOrUpdate(InvWhSaveVO param, Long addrNo, Boolean changeFlag) {
        OrgBuRpcSaveParam saveParam = new OrgBuRpcSaveParam();
        if (!changeFlag.booleanValue()) {
            saveParam.setId(param.getSecBuId());
        }
        saveParam.setOuId(param.getOuId());
        saveParam.setBuStatus(param.getWhStatus());
        saveParam.setBuName(param.getWhName());
        saveParam.setBuCode(param.getWhCode());
        saveParam.setBuType(UdcEnum.ORG_BU_TYPE_WH.getValueCode());
        saveParam.setBuStatus(param.getWhStatus());
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = this.reduceOrgAddrRpcSaveParam(addrNo, param);
        saveParam.setOrgAddrSaveParam(orgAddrRpcSaveParam);
        return saveParam;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhRespVO> findWhAreaById(Long id) {
        ArrayList<String> desCodeNameList;
        InvWhRespVO vo;
        Optional<InvWhRespVO> orgWhVOOptional = this.invWhDomainService.findIdOne(id);
        if (orgWhVOOptional.isPresent()) {
            OrgOuRpcDTO ouVO;
            List<OrgAddrAddressRpcDTO> orgAddrAddressVOS;
            vo = orgWhVOOptional.get();
            Long addrNo = vo.getAddrNo();
            List<InvWhAreaRespVO> invWhAreaRespVOS = this.invWhAreaDomainService.findByWhId(id);
            List<String> deter2Types = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getDeter2Type).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<InvWhAreaSettingRespVO> settingRespVOS = this.invWhAreaSettingService.findByDeter2Types(deter2Types);
            Map<String, String> areaNameMap = this.selectCityCode(invWhAreaRespVOS);
            ArrayList<InvWhRespVO> vos = new ArrayList<InvWhRespVO>();
            vos.add(vo);
            List<String> codeStrList = InvStringUtil.transitionStrToCodes(vo.getDesCode());
            vo.setDesCodeList(codeStrList);
            List<InvDespatchRpcDTO> orgBuRpcAllDTOS = this.invDespatchConfigDomainService.findByDesCodeBatch(codeStrList);
            HashMap ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS) ? new HashMap() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(InvDespatchRpcDTO::getDesCode, t -> t, (t1, t2) -> t1));
            invWhAreaRespVOS.forEach(i -> {
                if (i.getPType() != null && i.getPCode() != null) {
                    InvParentParamVO paramVO = new InvParentParamVO();
                    paramVO.setCode(i.getPCode());
                    paramVO.setType(i.getPType());
                    List<OrgRespVO> res = this.orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(res)) {
                        i.setPName(res.get(0).getName());
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)settingRespVOS)) {
                    settingRespVOS.stream().filter(v -> v.getDeter2Type().equals(i.getDeter2Type())).findAny().ifPresent(d -> {
                        i.setBusinessChoose(d.getBusinessChoose());
                        i.setDeter2TypeName(d.getDeter2TypeName());
                    });
                }
                if (!areaNameMap.isEmpty()) {
                    i.setProvinceName((String)areaNameMap.get(i.getProvince()));
                    i.setCityName((String)areaNameMap.get(i.getCity()));
                    i.setCountyName((String)areaNameMap.get(i.getCounty()));
                }
            });
            vo.setInvWhAreaRespVOList(invWhAreaRespVOS);
            List<InvWhDeliveryRespVO> whDeliveryList = this.invWhDeliveryService.findByWhId(id);
            whDeliveryList = whDeliveryList.stream().map(v -> {
                if (Integer.valueOf(InvWhDeliveryFlagEnum.C1.getCode()).equals(v.getAllArea())) {
                    v.setAllAreaName(InvWhDeliveryFlagEnum.C1.getDesc());
                }
                return v;
            }).collect(Collectors.toList());
            vo.setDeliveryAreas(whDeliveryList);
            if (addrNo != null && (orgAddrAddressVOS = this.findOrgAddrAddressList(addrNo)).size() > 0) {
                OrgAddrAddressRpcDTO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                vo.setCountry(orgAddrAddressVO.getCountry());
                vo.setProvince(orgAddrAddressVO.getProvince());
                vo.setCity(orgAddrAddressVO.getCity());
                vo.setCounty(orgAddrAddressVO.getCounty());
                vo.setCountryName(orgAddrAddressVO.getCountry());
                vo.setProvinceName(orgAddrAddressVO.getProvinceName());
                vo.setCityName(orgAddrAddressVO.getCityName());
                vo.setCountyName(orgAddrAddressVO.getCountyName());
                vo.setDetailaddr(orgAddrAddressVO.getDetailAddr());
                vo.setEmail(orgAddrAddressVO.getEmail());
                vo.setTel(orgAddrAddressVO.getTel());
                vo.setContPerson(orgAddrAddressVO.getContPerson());
                vo.setDetailaddr(orgAddrAddressVO.getDetailAddr());
            }
            if ((ouVO = this.orgOutService.findOuById(vo.getOuId())) != null) {
                vo.setOuName(ouVO.getOuName());
                vo.setOuCode(ouVO.getOuCode());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)vo.getBelongBuId())) {
                Optional<OrgBuRpcDTO> orgBuOptional = this.orgOutService.findBuById(Long.valueOf(vo.getBelongBuId()));
                orgBuOptional.ifPresent(orgBuRpcDTO -> {
                    vo.setBelongBuCode(orgBuRpcDTO.getBuCode());
                    vo.setBelongBuName(orgBuRpcDTO.getBuName());
                });
            }
            List<String> desCodeList = vo.getDesCodeList();
            desCodeNameList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(desCodeList)) {
                for (String desCode : desCodeList) {
                    InvDespatchRpcDTO orgBuRpcDTO2 = (InvDespatchRpcDTO)ouMap.get(desCode);
                    if (!Objects.nonNull(orgBuRpcDTO2)) continue;
                    desCodeNameList.add(orgBuRpcDTO2.getDesName());
                }
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
        vo.setDesCodeName(desCodeName);
        return orgWhVOOptional;
    }

    private Map<String, String> selectCityCode(List<InvWhAreaRespVO> lists) {
        List provinceCodes = lists.stream().map(InvWhAreaRespVO::getProvince).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List cityCodes = lists.stream().map(InvWhAreaRespVO::getCity).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List countyCodes = lists.stream().map(InvWhAreaRespVO::getCounty).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<String> areaCodeList = new ArrayList<String>();
        areaCodeList.addAll(provinceCodes);
        areaCodeList.addAll(cityCodes);
        areaCodeList.addAll(countyCodes);
        Map<String, String> areaNameMap = this.systemService.findAreaByParam(areaCodeList).stream().collect(Collectors.toMap(SysAreaRespDTO::getAreaCode, SysAreaRespDTO::getAreaName, (t1, t2) -> t1));
        return areaNameMap;
    }

    @Override
    @SysCodeProc
    public List<InvWhDeter2RespVO> findDeter2sByWhId(Long whId) {
        List<InvWhDeter2RespVO> invWhDeter2RespVOS = this.invWhAreaRepoProc.findDeter2sByWhId(whId);
        return invWhDeter2RespVOS;
    }

    @Override
    public PagingVO<InvWhRespVO> search(InvWhParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param));
        long dataCount = jpaQuery.fetchCount();
        this.invWhRepoProc.openOrderAndLimit(jpaQuery, param, QInvWhDO.invWhDO);
        List lists = jpaQuery.fetch();
        this.translateWh(lists);
        PagingVO paging = new PagingVO();
        paging.setRecords(lists);
        paging.setTotal(dataCount);
        return paging;
    }

    @Override
    public List<InvWhRespVO> searchWhByParam(InvWhParamVO param) {
        List whRespVOS = ((JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param))).fetch();
        if (!CollectionUtils.isEmpty((Collection)whRespVOS)) {
            this.translateWh(whRespVOS);
            return whRespVOS;
        }
        return null;
    }

    @Override
    public List<InvWhRespVO> searchWhBaseByParam(InvWhParamVO param) {
        List whRespVOS = ((JPAQuery)this.invWhRepoProc.select(null).where(this.invWhRepoProc.searchWhere(param))).fetch();
        if (CollectionUtils.isEmpty((Collection)whRespVOS)) {
            return Collections.EMPTY_LIST;
        }
        return whRespVOS;
    }

    @Override
    public List<InvWhRespVO> findByCodes(List<String> codes) {
        List<InvWhRespVO> whRespVOList = this.invWhDomainService.findByCodes(codes);
        this.translateWh(whRespVOList);
        return whRespVOList;
    }

    @Override
    @SysCodeProc
    public List<InvWhRespVO> findIdBatch(List<Long> ids) {
        List<InvWhRespVO> invWhRespVOS = this.invWhDomainService.findIdBatch(ids);
        return invWhRespVOS;
    }

    @Override
    @SysCodeProc
    public List<InvWhListRespVO> list(String keyword) throws ExecutionException, InterruptedException {
        List<InvWhListRespVO> collect = this.invWhRepoProc.list(keyword).fetch().stream().map(VO -> (InvWhListRespVO)BeanUtil.copyProperties((Object)VO, InvWhListRespVO.class, (String[])new String[0])).collect(Collectors.toList());
        List collect1 = collect.stream().map(InvWhListRespVO::getId).distinct().collect(Collectors.toList());
        CompletableFuture<List> listCompletableFuture1 = CompletableFuture.supplyAsync(() -> {
            List<InvWhAreaRespVO> allByWhId = this.invWhAreaService.findAllByWhId(collect1);
            return allByWhId;
        });
        List orgWhAreaVOS = listCompletableFuture1.get();
        Map<Long, String> deter2 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter2() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter2, (key1, key2) -> key2));
        Map<Long, String> deter3 = orgWhAreaVOS.stream().filter(v -> v.getWhId() != null && v.getDeter3() != null).collect(Collectors.toMap(InvWhAreaRespVO::getWhId, InvWhAreaRespVO::getDeter3, (key1, key2) -> key2));
        collect.stream().forEach(v -> {
            if (deter2.get(v.getId()) != null) {
                v.setDeter2((String)deter2.get(v.getId()));
            }
            if (deter3.get(v.getId()) != null) {
                v.setDeter3((String)deter3.get(v.getId()));
            }
            Optional<OrgAddrAddressRpcDTO> first = this.findOrgAddrAddress(v.getAddrNo());
            first.ifPresent(o -> v.setFromLoc(o.getCity()));
        });
        return collect;
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        this.invWhDomainService.deleteBatch(list);
    }

    private Boolean existVerify(Long id, String whCode) {
        InvWhParamVO param = new InvWhParamVO();
        param.setWhCode(whCode);
        JPAQuery<InvWhRespVO> select = this.invWhRepoProc.select(param);
        return select.fetch().stream().anyMatch(w -> !w.getId().equals(id));
    }

    private void translateWh(List<InvWhRespVO> invWhRespVOList) {
        List<String> desCodeAllList;
        List<InvDespatchRpcDTO> orgBuRpcAllDTOS;
        List<Long> ouIds = invWhRespVOList.stream().map(InvWhRespVO::getOuId).distinct().collect(Collectors.toList());
        List addrNos = invWhRespVOList.stream().map(InvWhRespVO::getAddrNo).distinct().collect(Collectors.toList());
        List buIdStringList = invWhRespVOList.stream().map(InvWhRespVO::getBelongBuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> buIdList = buIdStringList.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuVOS = this.orgOutService.findOuByIds(ouIds);
        OrgAddressRpcDtoParam param = new OrgAddressRpcDtoParam();
        param.setAddrNos(addrNos);
        List<OrgAddressRpcDTO> rpcAddrNos = this.orgOutService.findRpcDtoByBatchAddrNos(param);
        List<OrgBuRpcDTO> orgBuRpcDTOList = this.orgOutService.findBuByIds(buIdList);
        invWhRespVOList.forEach(VO -> {
            Optional<OrgOuRpcDTO> first1;
            if (!CollectionUtils.isEmpty((Collection)rpcAddrNos)) {
                rpcAddrNos.stream().filter(a -> a.getAddrNo().equals(VO.getAddrNo()) && a.getAddrType().equals(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode())).findAny().ifPresent(orgAddressRpcDTO -> {
                    VO.setCountry(orgAddressRpcDTO.getCountry());
                    VO.setProvince(orgAddressRpcDTO.getProvince());
                    VO.setCity(orgAddressRpcDTO.getCity());
                    VO.setCounty(orgAddressRpcDTO.getCounty());
                    VO.setCountryName(orgAddressRpcDTO.getCountry());
                    VO.setProvinceName(orgAddressRpcDTO.getProvinceName());
                    VO.setCityName(orgAddressRpcDTO.getCityName());
                    VO.setCountyName(orgAddressRpcDTO.getCountyName());
                    VO.setDetailaddr(orgAddressRpcDTO.getDetailAddr());
                    VO.setEmail(orgAddressRpcDTO.getEmail());
                    VO.setContPerson(orgAddressRpcDTO.getContPerson());
                    VO.setTel(orgAddressRpcDTO.getTel());
                });
            }
            if ((first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst()).isPresent()) {
                OrgOuRpcDTO orgOuVO = first1.get();
                VO.setOuName(orgOuVO.getOuName());
                VO.setOuCode(orgOuVO.getOuCode());
                VO.setOuCurr(orgOuVO.getOuCurr());
            }
            Optional<OrgBuRpcDTO> orgBuOptional = orgBuRpcDTOList.stream().filter(buRpcDTO -> Objects.equals(buRpcDTO.getId(), this.transitionBelongBuId(VO.getBelongBuId()))).findFirst();
            orgBuOptional.ifPresent(buRpcDTO -> {
                VO.setBelongBuName(buRpcDTO.getBuName());
                VO.setBelongBuCode(buRpcDTO.getBuCode());
            });
            List<String> codeStrList = InvStringUtil.transitionStrToCodes(VO.getDesCode());
            VO.setDesCodeList(codeStrList);
        });
        List<String> ouCurrList = invWhRespVOList.stream().map(InvWhRespVO::getOuCurr).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ouCurrList)) {
            List<SysCurrencyRespDTO> comCurrRpcDTOS = this.orgOutService.findRpcDtoByParam(ouCurrList);
            Map<String, String> stringMap = comCurrRpcDTOS.stream().collect(Collectors.toMap(SysCurrencyRespDTO::getCurrCode, SysCurrencyRespDTO::getCurrName));
            if (!CollectionUtils.isEmpty(comCurrRpcDTOS)) {
                invWhRespVOList.stream().forEach(v -> {
                    if (v.getOuCurr() != null) {
                        v.setOuCurrName((String)stringMap.get(v.getOuCurr()));
                    }
                });
            }
        }
        HashMap ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS = this.invDespatchConfigDomainService.findByDesCodeBatch(desCodeAllList = invWhRespVOList.stream().flatMap(vo -> vo.getDesCodeList().stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) ? new HashMap() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(InvDespatchRpcDTO::getDesCode, t -> t, (t1, t2) -> t1));
        invWhRespVOList.forEach(vo -> {
            List<String> desCodeList = vo.getDesCodeList();
            ArrayList<String> desCodeNameList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(desCodeList)) {
                for (String desCode : desCodeList) {
                    InvDespatchRpcDTO orgBuRpcDTO = (InvDespatchRpcDTO)ouMap.get(desCode);
                    if (!Objects.nonNull(orgBuRpcDTO)) continue;
                    desCodeNameList.add(orgBuRpcDTO.getDesCode());
                }
            }
            String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("\u3001"));
            vo.setDesCodeName(desCodeName);
        });
    }

    private Long transitionBelongBuId(String belongBuId) {
        if (org.springframework.util.StringUtils.isEmpty((Object)belongBuId)) {
            return null;
        }
        return Long.valueOf(belongBuId);
    }

    public void update(InvWhDO invWhDO) {
        Optional<InvWhDO> optional = this.invWhDomainService.findById(invWhDO.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + invWhDO.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(invWhDO, optional.get(), BeanCopyUtil.getNullAndIgnorePropertyNames(invWhDO, new String[0]));
        this.invWhDomainService.saveInvWh(invWhDO);
    }

    private Long saveAddressAndQualifyAndBankAcc(Boolean changeFlag, Long addrNo, InvWhSaveVO param) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto;
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
        OrgAddrAddressRpcSaveParam orgAddrAddressVO = new OrgAddrAddressRpcSaveParam();
        if (changeFlag.booleanValue() && Objects.nonNull(orgAddrDetailsRpcDto = this.orgOutService.findRpcDtoByAddrNo(addrNo))) {
            orgAddrRpcSaveParam.setId(orgAddrDetailsRpcDto.getId());
            param.setAddressId(orgAddrDetailsRpcDto.getId());
            List orgAddrAddressRpcDTOList = orgAddrDetailsRpcDto.getOrgAddrAddressVos();
            if (!CollectionUtils.isEmpty((Collection)orgAddrAddressRpcDTOList)) {
                Long addrAddressId = ((OrgAddrAddressRpcDTO)orgAddrAddressRpcDTOList.get(0)).getId();
                orgAddrAddressVO.setId(addrAddressId);
            }
        }
        orgAddrRpcSaveParam.setAddrNo(addrNo);
        orgAddrRpcSaveParam.setAddrName(param.getWhName());
        orgAddrRpcSaveParam.setAddrType(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode());
        ArrayList<OrgAddrAddressRpcSaveParam> orgAddrAddressSaveParams = new ArrayList<OrgAddrAddressRpcSaveParam>();
        orgAddrAddressVO.setDetailAddr(param.getDetailaddr());
        orgAddrAddressVO.setCountry(param.getCountry());
        orgAddrAddressVO.setProvince(param.getProvince());
        orgAddrAddressVO.setCity(param.getCity());
        orgAddrAddressVO.setCounty(param.getCounty());
        orgAddrAddressVO.setAddressType(UdcEnum.ORG_ADDR_TYPE_WH.getValueCode());
        orgAddrAddressVO.setDefaultFlag(Boolean.valueOf(true));
        orgAddrAddressVO.setEmail(param.getEmail());
        orgAddrAddressVO.setContPerson(param.getContPerson());
        orgAddrAddressVO.setTel(param.getTel());
        orgAddrAddressSaveParams.add(orgAddrAddressVO);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressSaveParams);
        ApiResult<Long> apiResult = this.orgOutService.orgAddrSaveOrUpdateReturnAddrNo(orgAddrRpcSaveParam);
        if (apiResult.isSuccess()) {
            return (Long)apiResult.getData();
        }
        throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
    }

    private void saveWhOrgAddrAddress(List<Long> addrNoList, InvWhSaveVO param) {
        addrNoList.forEach(addr -> {
            List orgAddrAddressRpcDtoList;
            OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = this.orgOutService.findRpcDtoByAddrNo((Long)addr);
            if (Objects.nonNull(orgAddrDetailsRpcDto) && !CollectionUtils.isEmpty((Collection)(orgAddrAddressRpcDtoList = orgAddrDetailsRpcDto.getOrgAddrAddressVos()))) {
                OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
                orgAddrRpcSaveParam.setId(orgAddrDetailsRpcDto.getId());
                orgAddrRpcSaveParam.setAddrNo(orgAddrDetailsRpcDto.getAddrNo());
                orgAddrRpcSaveParam.setAddrName(orgAddrDetailsRpcDto.getAddrName());
                orgAddrRpcSaveParam.setAddrType(orgAddrDetailsRpcDto.getAddrType());
                ArrayList<OrgAddrAddressRpcSaveParam> orgAddrAddressSaveParams = new ArrayList<OrgAddrAddressRpcSaveParam>();
                OrgAddrAddressRpcSaveParam invAddrAddress = new OrgAddrAddressRpcSaveParam();
                OrgAddrAddressRpcDTO orgAddrAddressRpcDto = (OrgAddrAddressRpcDTO)orgAddrAddressRpcDtoList.get(0);
                BeanCopyUtil.beanCopy(orgAddrAddressRpcDto, invAddrAddress);
                invAddrAddress.setEmail(param.getEmail());
                invAddrAddress.setContPerson(param.getContPerson());
                orgAddrAddressSaveParams.add(invAddrAddress);
                orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressSaveParams);
                this.orgOutService.orgAddrSaveOrUpdateReturnAddrNo(orgAddrRpcSaveParam);
            }
        });
    }

    private void translateWhArea(List<InvWhAreaRespVO> invWhAreaRespVOS, List<InvWhRespVO> invWhRespVOList) {
        List<Long> createUserIds = invWhAreaRespVOS.stream().map(BaseModelVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = this.systemService.findAllEmpsByIdIn(createUserIds);
        List<String> deter2Types = invWhAreaRespVOS.stream().map(InvWhAreaRespVO::getDeter2Type).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhAreaSettingRespVO> byDeter2Types = this.invWhAreaSettingService.findByDeter2Types(deter2Types);
        invWhAreaRespVOS.forEach(VO -> {
            if (!CollectionUtils.isEmpty((Collection)byDeter2Types)) {
                byDeter2Types.stream().filter(m -> m.getDeter2Type().equals(VO.getDeter2Type())).findAny().ifPresent(d -> VO.setDeter2TypeName(d.getDeter2TypeName()));
            }
            if (empsByIdIn != null) {
                empsByIdIn.stream().filter(u -> u.getId() != null && u.getId().equals(VO.getCreateUserId())).findAny().ifPresent(i -> VO.setCreateUserName(i.getUsername()));
            }
            if (!CollectionUtils.isEmpty((Collection)invWhRespVOList)) {
                invWhRespVOList.stream().filter(record -> VO.getWhId() != null && VO.getWhId().equals(record.getId())).findAny().ifPresent(VO::setInvWhRespVO);
            }
            if (VO.getPType() != null && VO.getPCode() != null) {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setCode(VO.getPCode());
                paramVO.setType(VO.getPType());
                List<OrgRespVO> vos = this.orgOutService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    VO.setPName(vos.get(0).getName());
                }
            }
        });
    }

    private void checkData(List<InvWhAreaImport> importParams, String whType) {
        if (importParams.size() == 0) {
            throw new BusinessException(ApiCode.FAIL, "\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        StringBuilder builder3 = new StringBuilder();
        StringBuilder builder4 = new StringBuilder();
        InvWhAreaSettingParamVO paramVO = new InvWhAreaSettingParamVO();
        paramVO.setWhType(whType);
        paramVO.setStatus("ACTIVE");
        List<InvWhAreaSettingRespVO> allActives = this.invWhAreaSettingService.findAllActives(paramVO);
        List deter2List = allActives.stream().map(v -> v.getDeter2()).collect(Collectors.toList());
        ArrayList suppcodes = new ArrayList();
        AtomicInteger line1 = new AtomicInteger(0);
        importParams.forEach(v -> {
            line1.addAndGet(1);
            if (StringUtils.isEmpty((CharSequence)v.getDeter2())) {
                builder.append("\u3010" + line1 + "\u3011");
            }
            if (!StringUtils.isEmpty((CharSequence)v.getDeter2()) && v.getDeter2().equals("15") && StringUtils.isEmpty((CharSequence)v.getPcode())) {
                builder1.append("\u3010" + line1 + "\u3011");
            }
            if (!deter2List.contains(v.getDeter2())) {
                builder2.append("\u3010" + line1 + "\u3011");
            }
            if (!StringUtils.isEmpty((CharSequence)v.getDeter2()) && v.getDeter2().equals("17") && StringUtils.isEmpty((CharSequence)v.getPcode())) {
                builder3.append("\u3010" + line1 + "\u3011");
            }
        });
        if (builder.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder.toString() + "\u884c\u5fc5\u586b\u6570\u636e\u6709\u7a7a\u503c,\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder1.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder1.toString() + "\u884c\u5f53\u529f\u80fd\u533a\u4e3a\u7f51\u683c\u4e2a\u4eba\u5e93\u65f6\uff0c\u5458\u5de5\u7f16\u53f7\u5fc5\u586b\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder2.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder2.toString() + "\u884c\u8be5\u4ed3\u5e93\u4e0d\u80fd\u9009\u62e9\u8fd9\u4e2a\u529f\u80fd\u533a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder3.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder3.toString() + "\u884c\u5f53\u529f\u80fd\u533a\u4e3a\u4f9b\u5e94\u5546\u4ed3\u7684\u65f6\u5019\uff0c\u4f9b\u5e94\u5546\u7f16\u7801\u5fc5\u586b\uff01");
        }
    }

    private void setProviceAndCityAndCounty(InvWhSaveVO saveVO, InvWhExcelImport excelImport) {
        saveVO.setCountry(excelImport.getCountry());
        List<String> list = Arrays.asList(excelImport.getProvince(), excelImport.getCity(), excelImport.getCounty());
        List<SysAreaRespDTO> comCityCodeRpcDTOS = this.systemService.findAreaByParam(list);
        comCityCodeRpcDTOS.forEach(v -> {
            if (v.getAreaName().equals(excelImport.getProvince())) {
                saveVO.setProvince(v.getAreaCode());
            }
            if (v.getAreaName().equals(excelImport.getCity())) {
                saveVO.setCity(v.getAreaCode());
            }
            if (v.getAreaName().equals(excelImport.getCounty())) {
                saveVO.setCounty(v.getAreaCode());
            }
        });
    }

    private String getKey(Map<String, String> map, String value) {
        String key = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            key = entry.getKey();
        }
        return key;
    }

    private void chcekData(List<InvWhExcelImport> importParams) {
        StringBuilder builder = new StringBuilder();
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        StringBuilder builder3 = new StringBuilder();
        StringBuilder builder4 = new StringBuilder();
        StringBuilder builder5 = new StringBuilder();
        StringBuilder builder6 = new StringBuilder();
        List ouCodes = importParams.stream().map(InvWhExcelImport::getOuCode).collect(Collectors.toList());
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        List pCodeList = importParams.stream().map(InvWhExcelImport::getPCode).collect(Collectors.toList());
        OrgEmpRpcDtoParam empRpcDtoParam = new OrgEmpRpcDtoParam();
        empRpcDtoParam.setEmpCodes(pCodeList);
        List<String> whCodeList = importParams.stream().map(v -> v.getWhCode()).collect(Collectors.toList());
        List<InvWhRespVO> invWhRespVOS = this.findByCodes(whCodeList);
        AtomicInteger line1 = new AtomicInteger(0);
        importParams.forEach(v -> {
            line1.addAndGet(1);
            if (StringUtils.isEmpty((CharSequence)v.getWhCode()) || StringUtils.isEmpty((CharSequence)v.getWhName()) || StringUtils.isEmpty((CharSequence)v.getOuCode()) || StringUtils.isEmpty((CharSequence)v.getProvince()) || StringUtils.isEmpty((CharSequence)v.getCity()) || StringUtils.isEmpty((CharSequence)v.getCounty()) || StringUtils.isEmpty((CharSequence)v.getDetailaddr()) || StringUtils.isEmpty((CharSequence)v.getContPerson()) || StringUtils.isEmpty((CharSequence)v.getTel()) || StringUtils.isEmpty((CharSequence)v.getEmail()) || StringUtils.isEmpty((CharSequence)v.getDeter2())) {
                builder.append("\u3010" + line1 + "\u3011");
            }
        });
        Map<String, List<InvWhExcelImport>> listMap = importParams.stream().collect(Collectors.groupingBy(InvWhExcelImport::getWhCode));
        for (Map.Entry<String, List<InvWhExcelImport>> a : listMap.entrySet()) {
            List<InvWhExcelImport> value = a.getValue();
            InvWhExcelImport excelImport = value.get(0);
            value.forEach(v -> {
                if (!(v.getWhType().equals(excelImport.getWhType()) && v.getWhName().equals(excelImport.getWhName()) && v.getOuCode().equals(v.getOuCode()) && v.getProvince().equals(excelImport.getProvince()) && v.getCity().equals(excelImport.getCity()) && v.getCounty().equals(excelImport.getCounty()) && v.getDetailaddr().equals(excelImport.getDetailaddr()) && v.getContPerson().equals(excelImport.getContPerson()) && v.getTel().equals(excelImport.getTel()) && v.getEmail().equals(excelImport.getEmail()))) {
                    builder1.append("\u3010" + v.getWhName() + "\u3011");
                }
            });
        }
        AtomicInteger line2 = new AtomicInteger(0);
        importParams.forEach(v -> {
            line2.addAndGet(1);
            if (v.getDeter2().equals("15")) {
                if (v.getPCode() == null) {
                    builder3.append("\u3010" + line2 + "\u3011");
                }
            } else if (v.getPCode() != null) {
                builder5.append("\u3010" + line2 + "\u3011");
            }
        });
        AtomicInteger line3 = new AtomicInteger(0);
        if (!CollectionUtils.isEmpty(invWhRespVOS)) {
            importParams.forEach(v -> {
                line3.addAndGet(1);
                invWhRespVOS.forEach(v2 -> {
                    if (v2.getWhCode().equals(v.getWhCode())) {
                        builder6.append("\u3010" + line3 + "\u3011");
                    }
                });
            });
        }
        if (builder.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder.toString() + "\u884c\u6570\u636e\u6709\u7a7a\u503c,\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder1.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u4ed3\u5e93\u540d\u79f0\u4e3a\uff1a" + builder1.toString() + "\u540c\u4e00\u4e2a\u4ed3\u5e93\u7684\u57fa\u7840\u4fe1\u606f\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder2.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder2.toString() + "\u884c\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder3.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder3.toString() + "\u884c\u529f\u80fd\u533a\u4e3a\u7f51\u683c\u4e2a\u4eba\u5e93\u7684\u65f6\u5019\u65f6,\u5e93\u5b58\u5408\u4f5c\u4f19\u4f34\u7f16\u7801\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder4.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder4.toString() + "\u884c\u5e93\u5b58\u5408\u4f5c\u4f19\u4f34\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder5.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder5.toString() + "\u884c\u529f\u80fd\u533a\u4e0d\u4e3a\u7f51\u683c\u4e2a\u4eba\u5e93\u7684\u65f6\u5019\u65f6,\u5e93\u5b58\u5408\u4f5c\u4f19\u4f34\u540d\u79f0\u4e0d\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (builder6.length() > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u7b2c" + builder6.toString() + "\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private List<OrgAddrAddressRpcDTO> findOrgAddrAddressList(Long addrNo) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = this.orgOutService.findRpcDtoByAddrNo(addrNo);
        if (Objects.isNull(orgAddrDetailsRpcDto)) {
            return Lists.newArrayList();
        }
        return orgAddrDetailsRpcDto.getOrgAddrAddressVos();
    }

    private Optional<OrgAddrAddressRpcDTO> findOrgAddrAddress(Long addrNo) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = this.orgOutService.findRpcDtoByAddrNo(addrNo);
        if (Objects.isNull(orgAddrDetailsRpcDto)) {
            return Optional.empty();
        }
        Optional<OrgAddrAddressRpcDTO> first = orgAddrDetailsRpcDto.getOrgAddrAddressVos().stream().findFirst();
        if (first.isEmpty()) {
            return Optional.empty();
        }
        return first;
    }

    @Override
    public List<InvWhRespVO> getDespatchWhByDeter2KeyWord(String deter2KeyWord) {
        return this.invWhRepoProc.getDespatchWhByDeter2KeyWord(deter2KeyWord);
    }

    @Override
    public List<InvWhRespVO> findWhByIdBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<InvWhRespVO>();
        }
        return this.invWhRepoProc.findWhByIdBatch(ids);
    }

    @Override
    public List<InvWhRespVO> findWhByNameCode(String whNameCode) {
        return this.invWhRepoProc.findByWhNameCode(whNameCode);
    }

    public InvWhServiceImpl(SystemService systemService, InvWhRepoProc invWhRepoProc, InvWhRepo invWhRepo, InvWhAreaService invWhAreaService, InvWhAreaRepoProc invWhAreaRepoProc, InvWhDeliveryProc invWhDeliveryProc, InvWhDeliveryRepo invWhDeliveryRepo, InvWhDeliveryService invWhDeliveryService, InvWhAreaSettingService invWhAreaSettingService, InvWhAreaSettingRepo invWhAreaSettingRepo, InvWhAreaRepo invWhAreaRepo, NumSenderService numSenderService, OrgOutService orgOutService, InvWhDomainService invWhDomainService, InvWhAreaDomainService invWhAreaDomainService, InvWhAreaSettingDomainService invWhAreaSettingDomainService, OrgBuOutService orgBuOutService, InvDespatchConfigDomainService invDespatchConfigDomainService) {
        this.systemService = systemService;
        this.invWhRepoProc = invWhRepoProc;
        this.invWhRepo = invWhRepo;
        this.invWhAreaService = invWhAreaService;
        this.invWhAreaRepoProc = invWhAreaRepoProc;
        this.invWhDeliveryProc = invWhDeliveryProc;
        this.invWhDeliveryRepo = invWhDeliveryRepo;
        this.invWhDeliveryService = invWhDeliveryService;
        this.invWhAreaSettingService = invWhAreaSettingService;
        this.invWhAreaSettingRepo = invWhAreaSettingRepo;
        this.invWhAreaRepo = invWhAreaRepo;
        this.numSenderService = numSenderService;
        this.orgOutService = orgOutService;
        this.invWhDomainService = invWhDomainService;
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.invWhAreaSettingDomainService = invWhAreaSettingDomainService;
        this.orgBuOutService = orgBuOutService;
        this.invDespatchConfigDomainService = invDespatchConfigDomainService;
    }
}

