/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.stk.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvSceneConfigBizService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptService;
import com.elitesland.yst.production.inv.application.service.stk.impl.InvStkOptFactory;
import com.elitesland.yst.production.inv.enums.WhetherEnum;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDTO;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDtlDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkQtyResultDTO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvStkOptBizServiceImpl
implements InvStkOptBizService {
    private static final Logger log = LoggerFactory.getLogger(InvStkOptBizServiceImpl.class);
    @Autowired
    private InvSceneConfigBizService invSceneConfigBizService;
    @Autowired
    private RedLockUtils redLockUtils;
    @Autowired
    private SystemService systemService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InvStkQtyResultDTO> invStkCommonOperate(@Valid InvStkCommonOperateDTO param) {
        ArrayList<InvStkQtyResultDTO> resultList = new ArrayList<InvStkQtyResultDTO>();
        SysSettingVO sysSetting = this.systemService.findSysSetting("ENABLE_STK_SCENE_OPER");
        if (sysSetting != null && "0".equals(sysSetting.getSettingVal())) {
            return resultList;
        }
        List<InvSceneConfigDtlDTO> configDtls = this.validateBusParam(param);
        RedissonRedLock rLock = this.redLockUtils.getRedLock("YST_INV_INV_STK_COMMON_OPERATE_KEY_" + param.getRequestId());
        try {
            boolean lockFlag = rLock.tryLock(3L, 60L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u64cd\u4f5c\u5e93\u5b58\uff0c\u83b7\u53d6\u9501\u5931\u8d25...,\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)param.getRequestId());
                throw new BusinessException("\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u5e93\u5b58\uff01\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a" + param.getRequestId());
            }
            log.info("\u64cd\u4f5c\u5e93\u5b58\uff0c\u52a0\u9501\u6210\u529f\uff0c\u6765\u6e90\u7cfb\u7edf:{},\u8bf7\u6c42\u6d41\u6c34\u53f7:{},\u5e93\u5b58\u573a\u666f\u7f16\u7801:{}", new Object[]{param.getSource(), param.getRequestId(), param.getSceneCode()});
            for (InvSceneConfigDtlDTO configDtl : configDtls) {
                InvStkOptService optService = InvStkOptFactory.STK_OPT_SERVICE_HASH_MAP.get(configDtl.getIoType());
                if (optService == null) {
                    log.error("invStkCommonOperate \u672a\u627e\u5230\u76f8\u5e94\u7684\u5e93\u5b58\u64cd\u4f5c\u5b9e\u73b0\u7c7b" + configDtl.getIoType());
                    throw new BusinessException("invStkCommonOperate \u672a\u627e\u5230\u76f8\u5e94\u7684\u5e93\u5b58\u64cd\u4f5c\u5b9e\u73b0\u7c7b" + configDtl.getIoType());
                }
                if (UdcEnum.INV_OPT_TYPE_B.getValueCode().equals(configDtl.getWhoptType())) {
                    if (CollectionUtils.isEmpty(param.getTargetBodyList())) {
                        throw new BusinessException(ApiCode.FAIL, "\u76ee\u7684\u5e93\u5b58\u64cd\u4f5c\u660e\u7ec6\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    resultList.addAll(optService.stkOperatePortal(configDtl, param.getSceneCode(), param.getTargetBodyList()));
                    continue;
                }
                resultList.addAll(optService.stkOperatePortal(configDtl, param.getSceneCode(), param.getSourceBodyList()));
            }
        }
        catch (InterruptedException e) {
            log.error("invStkCommonOperate InterruptedException,cause->", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7cfb\u7edf\u7ebf\u7a0b\u4e2d\u65ad\uff01");
        }
        finally {
            rLock.unlock();
        }
        return resultList;
    }

    private List<InvSceneConfigDtlDTO> validateBusParam(InvStkCommonOperateDTO param) {
        if (StringUtils.isBlank((CharSequence)param.getSceneCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e93\u5b58\u573a\u666f\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getRequestId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u552f\u4e00\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSource())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6765\u6e90\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (CollectionUtils.isEmpty(param.getSourceBodyList())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8981\u64cd\u4f5c\u7684\u5e93\u5b58\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        InvSceneConfigDTO sceneConfig = this.invSceneConfigBizService.getBySceneCode(param.getSceneCode());
        if (sceneConfig == null || CollectionUtils.isEmpty(sceneConfig.getInvSceneConfigDtlList())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u914d\u7f6e\u5e93\u5b58\u573a\u666f\uff0c\u8bf7\u68c0\u67e5!");
        }
        if (!WhetherEnum.Y.name().equals(sceneConfig.getIsEnable())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u5e93\u5b58\u573a\u666f\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5!");
        }
        return sceneConfig.getInvSceneConfigDtlList().stream().sorted(Comparator.comparing(InvSceneConfigDtlDTO::getOptSeq, Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
    }
}

