/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocParamVO;
import com.elitesland.yst.production.inv.domain.convert.InvIocConvert;
import com.elitesland.yst.production.inv.domain.entity.ioc.InvIoc;
import com.elitesland.yst.production.inv.domain.entity.ioc.InvIocDO;
import com.elitesland.yst.production.inv.domain.service.InvIocDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvIocDTO;
import com.elitesland.yst.production.inv.infr.repo.ioc.InvIocRepo;
import com.elitesland.yst.production.inv.infr.repo.ioc.InvIocRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="InvIocDomainService")
public class InvIocDomainServiceImpl
implements InvIocDomainService {
    private final InvIocRepo InvIocRepo;
    private final InvIocRepoProc InvIocRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvIocDTO> search(InvIocParamVO param) {
        PagingVO<InvIocDTO> pagingVo = this.InvIocRepoProc.search(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveInvIoc(InvIoc InvIoc2, Optional<InvIocDTO> optional) {
        if (optional.isPresent()) {
            InvIocDTO InvIocDTO2 = optional.get();
            InvIoc2.setIoCode(InvIocDTO2.getIoCode());
            InvIoc2.setId(InvIocDTO2.getId());
            InvIoc2.setCreator(InvIocDTO2.getCreator());
            InvIoc2.setCreateUserId(InvIocDTO2.getCreateUserId());
            InvIoc2.setCreateTime(InvIocDTO2.getCreateTime());
            InvIoc2.setModifyTime(LocalDateTime.now());
        } else {
            InvIoc2.setId(null);
            InvIoc2.setCreator(null);
            InvIoc2.setCreateUserId(null);
            InvIoc2.setCreateTime(LocalDateTime.now());
            InvIoc2.setModifyUserId(null);
            InvIoc2.setUpdater(null);
            InvIoc2.setModifyTime(LocalDateTime.now());
        }
        InvIocDO InvIocDO2 = InvIocConvert.INSTANCE.enToDo(InvIoc2);
        Long id = ((InvIocDO)this.InvIocRepo.save(InvIocDO2)).getId();
        return id;
    }

    @Override
    @SysCodeProc
    public Optional<InvIocDTO> findById(Long id) {
        return this.InvIocRepo.findById(id).map(InvIocConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public Optional<InvIocDTO> findByCode(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return Optional.empty();
        }
        InvIocParamVO param = new InvIocParamVO();
        param.setIoCode(code);
        JPAQuery<InvIocDTO> jpaQuery = this.InvIocRepoProc.select(param);
        return Optional.of((InvIocDTO)jpaQuery.fetchFirst());
    }

    @Override
    @SysCodeProc
    public List<InvIocDTO> findByIdBatch(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvIocDTO> whAreaSettingDTOList = this.InvIocRepo.findAllById(idList).stream().map(InvIocConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return whAreaSettingDTOList;
    }

    @Override
    @SysCodeProc
    public List<InvIocDTO> findByCodeBatch(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.EMPTY_LIST;
        }
        InvIocParamVO param = new InvIocParamVO();
        param.setIoCodeList(codeList);
        JPAQuery<InvIocDTO> jpaQuery = this.InvIocRepoProc.select(param);
        List InvIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)InvIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return InvIocDTOS;
    }

    @Override
    @SysCodeProc
    public List<InvIocDTO> selectByParam(InvIocParamVO param) {
        JPAQuery<InvIocDTO> jpaQuery = this.InvIocRepoProc.select(param);
        List InvIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)InvIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return InvIocDTOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        this.InvIocRepoProc.updateDeleteFlagByIds(deleteFlag, idList).execute();
    }

    public InvIocDomainServiceImpl(InvIocRepo InvIocRepo2, InvIocRepoProc InvIocRepoProc2) {
        this.InvIocRepo = InvIocRepo2;
        this.InvIocRepoProc = InvIocRepoProc2;
    }
}

