/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryGroupParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvStkDO;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.dto.invstk.InvStkAllRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDTO;
import com.elitesland.yst.production.inv.dto.invstk.InvStkRpcDtoParam;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkFullDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkGroupDTO;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepo;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepoProc;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="InvStkDomainService")
public class InvStkDomainServiceImpl
implements InvStkDomainService {
    private final InvStkRepo invStkRepo;
    private final InvStkRepoProc invStkRepoProc;

    @Override
    public InvStkDO saveInvStk(InvStkDO invStkDO) {
        return (InvStkDO)this.invStkRepo.save(invStkDO);
    }

    @Override
    public List<InvStkDO> saveInvStkList(List<InvStkDO> invStkList) {
        return this.invStkRepo.saveAll(invStkList);
    }

    @Override
    public int saveInvStkAll(List<InvStkDO> invStkList) {
        return this.invStkRepo.saveAll(invStkList).size();
    }

    @Override
    public Optional<InvStkDO> getInvStkById(Long id) {
        return this.invStkRepo.findById(id);
    }

    @Override
    public InvStkDTO getInvStk(InvBaseModel queryParam) {
        List fetch = ((JPAQuery)this.invStkRepoProc.select(null).where(this.getPredicate(QInvStkDO.invStkDO, queryParam))).fetch();
        if (!ObjectUtils.isEmpty((Object)fetch) && fetch.size() > 0) {
            return (InvStkDTO)fetch.get(0);
        }
        return null;
    }

    @Override
    public List<InvStkRpcDTO> findStkAllRpcDTOByParam(InvStkAllRpcDtoParam param) {
        List<InvStkRpcDTO> invStkRpcDTOS = this.invStkRepoProc.findStkAllDTOByParam(param);
        return invStkRpcDTOS;
    }

    @Override
    public List<InvStkRpcDTO> getInvStkRpcDTOByParam(InvStkRpcDtoParam param) {
        List<InvStkRpcDTO> invStkRpcDTOS = this.invStkRepoProc.findStkRpcDTOByParam(param);
        return invStkRpcDTOS;
    }

    @Override
    public void deleteById(Long id) {
        this.invStkRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invStkRepo.deleteById(id));
    }

    @Override
    public List<InvStkDTO> findInvStkRespVOs(InvStkQueryParamVO param) {
        Iterable invStkDOIterable = this.invStkRepo.findAll(this.invStkRepoProc.findInvStkList(param));
        List<InvStkDTO> invStkDTOS = StreamSupport.stream(invStkDOIterable.spliterator(), false).map(InvStkConvert.INSTANCE::doToDto).collect(Collectors.toList());
        return invStkDTOS;
    }

    @Override
    @SysCodeProc
    public List<InvStkGroupDTO> selectInvStkGroupByParam(InvStkQueryGroupParamVO param) {
        List invStkGroupDTOList = this.invStkRepoProc.selectInvStkGroupByParam(param).fetch();
        if (CollectionUtils.isEmpty((Collection)invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invStkGroupDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkGroupDTO> invStkGroupSearch(InvStkQueryGroupParamVO param) {
        PagingVO<InvStkGroupDTO> pagingVo = this.invStkRepoProc.invStkGroupSearch(param);
        return pagingVo;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkFullDTO> fullSearch(InvStkQueryGroupParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.invStkRepoProc.fullSearch(null).where(this.invStkRepoProc.whereGroup(param));
        param.fillOrders(jpaQuery, QInvStkDO.invStkDO);
        param.setPaging(jpaQuery);
        return PagingVO.builder().total((long)jpaQuery.fetch().size()).records(jpaQuery.fetch()).build();
    }

    @Override
    @SysCodeProc
    public List<InvStkGroupDTO> selectInvStkGroupByInvBaseModel(InvBaseModel param) {
        List invStkGroupDTOList = ((JPAQuery)this.invStkRepoProc.selectInvStkGroupByParam(null).where(this.getPredicate(QInvStkDO.invStkDO, param))).fetch();
        if (CollectionUtils.isEmpty((Collection)invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return invStkGroupDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkDTO> queryAll(InvStkQueryParamVO param) {
        return this.invStkRepoProc.queryAll(param);
    }

    private Predicate getPredicate(QInvStkDO jpaQDo, InvBaseModel queryParam) {
        BooleanExpression predicate1 = queryParam.getItemId() != null ? jpaQDo.itemId.eq((Object)queryParam.getItemId()) : null;
        BooleanExpression predicate2 = queryParam.getVariId() != null && queryParam.getVariId() != 0L ? jpaQDo.variId.eq((Object)queryParam.getVariId()) : null;
        BooleanExpression predicate3 = !StringUtils.isEmpty((Object)queryParam.getLotNo()) ? jpaQDo.lotNo.eq((Object)queryParam.getLotNo()) : null;
        BooleanExpression predicate4 = queryParam.getWhId() != null ? jpaQDo.whId.eq((Object)queryParam.getWhId()) : null;
        BooleanExpression predicate5 = !StringUtils.isEmpty((Object)queryParam.getDeter1()) ? jpaQDo.deter1.eq((Object)queryParam.getDeter1()) : null;
        BooleanExpression predicate6 = !StringUtils.isEmpty((Object)queryParam.getDeter2()) ? jpaQDo.deter2.eq((Object)queryParam.getDeter2()) : null;
        BooleanExpression predicate7 = !StringUtils.isEmpty((Object)queryParam.getUom()) ? jpaQDo.uom.eq((Object)queryParam.getUom()) : null;
        BooleanExpression predicate8 = !StringUtils.isEmpty((Object)queryParam.getPType()) ? jpaQDo.pType.eq((Object)queryParam.getPType()) : null;
        BooleanExpression predicate9 = !StringUtils.isEmpty((Object)queryParam.getPCode()) ? jpaQDo.pCode.eq((Object)queryParam.getPCode()) : null;
        BooleanExpression predicate10 = !StringUtils.isEmpty((Object)queryParam.getSnNo()) ? jpaQDo.snNo.eq((Object)queryParam.getSnNo()) : null;
        BooleanExpression predicate11 = !StringUtils.isEmpty((Object)queryParam.getDeter3()) ? jpaQDo.deter3.eq((Object)queryParam.getDeter3()) : null;
        BooleanExpression predicate12 = !StringUtils.isEmpty((Object)queryParam.getLimit1()) ? jpaQDo.limit1.eq((Object)queryParam.getLimit1()) : null;
        BooleanExpression predicate13 = !StringUtils.isEmpty((Object)queryParam.getLimit2()) ? jpaQDo.limit2.eq((Object)queryParam.getLimit2()) : null;
        return ExpressionUtils.allOf((Predicate[])new Predicate[]{predicate1, predicate2, predicate3, predicate4, predicate5, predicate6, predicate7, predicate8, predicate9, predicate10, predicate11, predicate12, predicate13});
    }

    public InvStkDomainServiceImpl(InvStkRepo invStkRepo, InvStkRepoProc invStkRepoProc) {
        this.invStkRepo = invStkRepo;
        this.invStkRepoProc = invStkRepoProc;
    }
}

