/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAllQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.domain.convert.InvTrnDConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrnD;
import com.elitesland.yst.production.inv.domain.service.InvTrnDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvTrnAndTrnDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnDRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvTrnDDomainServiceImpl
implements InvTrnDDomainService {
    private static final Logger log = LoggerFactory.getLogger(InvTrnDDomainServiceImpl.class);
    private final InvTrnDRepo invTrnDRepo;
    private final InvTrnDRepoProc invTrnDRepoProc;
    private final SystemService systemService;
    private final InvWhAreaDomainService invWhAreaDomainService;

    @Override
    public PagingVO<InvTrnAndTrnDTO> search(InvTrnAllQueryParamVO param) {
        if (StringUtils.hasText((String)param.getODeter2KeyWord()) && this.findByDeter2KeyWord(param)) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        if (StringUtils.hasText((String)param.getIDeter2KeyWord()) && this.findByDeter2KeyWord(param)) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        JPAQuery<InvTrnAndTrnDTO> invTrns = this.invTrnDRepoProc.selectH(param);
        param.fillOrders(invTrns);
        param.setPaging(invTrns);
        List ins = invTrns.fetch();
        ins.forEach(i -> Optional.of(i.getId()).ifPresent(t -> this.invTrnDRepo.findById(t).ifPresent(tt -> {
            i.setODeter1(tt.getODeter1());
            i.setODeter2(tt.getODeter2());
            i.setOWhId(tt.getOWhId());
            i.setOOuId(tt.getOOuId());
            i.setIDeter1(tt.getIDeter1());
            i.setIDeter2(tt.getIDeter2());
            i.setIWhId(tt.getIWhId());
        })));
        return PagingVO.builder().total(invTrns.fetchCount()).records(ins).build();
    }

    private boolean findByDeter2KeyWord(InvTrnAllQueryParamVO param) {
        List<InvWhAreaRespVO> byDeter2KeyWord = this.invWhAreaDomainService.findByDeter2KeyWord(param.getODeter2KeyWord());
        if (CollectionUtils.isEmpty(byDeter2KeyWord)) {
            return true;
        }
        List<String> iDeter2s = byDeter2KeyWord.stream().map(InvWhAreaRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        param.setODeter2s(iDeter2s);
        return false;
    }

    @Override
    public List<InvTrnDDTO> findByMasId(Long trnId) {
        return this.invTrnDRepo.findByMasId(trnId).stream().map(InvTrnDConvert.INSTANCE::doToTrnDDTO).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> idList) {
        idList.forEach(id -> this.invTrnDRepo.deleteById(id));
    }

    @Override
    @SysCodeProc
    public List<InvTrnAndTrnDTO> findAll(InvTrnAllQueryParamVO param) {
        List invTrns = this.invTrnDRepoProc.selectD(param).fetch();
        invTrns.forEach(i -> Optional.of(i.getId()).ifPresent(t -> this.invTrnDRepo.findById(t).ifPresent(tt -> {
            i.setODeter1(tt.getODeter1());
            i.setODeter2(tt.getODeter2());
            i.setOWhId(tt.getOWhId());
            i.setOWhCode(tt.getOWhCode());
            i.setIWhCode(tt.getIWhCode());
            i.setIDeter1(tt.getIDeter1());
            i.setIDeter2(tt.getIDeter2());
            i.setIWhId(tt.getIWhId());
        })));
        return invTrns;
    }

    @Override
    @Transactional
    public void createBatch(List<InvTrnD> invTrnDS) {
        List list = invTrnDS.stream().map(InvTrnDConvert.INSTANCE::invTrnDToDO).collect(Collectors.toList());
        this.invTrnDRepo.saveAll(list);
    }

    public InvTrnDDomainServiceImpl(InvTrnDRepo invTrnDRepo, InvTrnDRepoProc invTrnDRepoProc, SystemService systemService, InvWhAreaDomainService invWhAreaDomainService) {
        this.invTrnDRepo = invTrnDRepo;
        this.invTrnDRepoProc = invTrnDRepoProc;
        this.systemService = systemService;
        this.invWhAreaDomainService = invWhAreaDomainService;
    }
}

