package com.elitesland.yst.production.inv.application.facade.vo.carr;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单
 * @date 2021-09-19 11:25:37
 */
@Data
@ApiModel(value = "inv_carr", description = "承运商配送单")
public class InvCarrParamVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 1303550942399307716L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> buIds;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 [UDC]PUR:SS_TYPE
     */
    @ApiModelProperty("单据类型 [UDC]PUR:SS_TYPE")
    private String docType;
    /**
     * 单据状态 [UDC]PUR:SS_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:SS_STATUS")
    private String docStatus;
    private List<String> docStatuses;
    /**
     * 发货日期
     */
    @ApiModelProperty("发货日期")
    private List<LocalDateTime> shipmentDate;

    @ApiModelProperty("发货日期从")
    private LocalDateTime shipmentDateS;

    @ApiModelProperty("发货日期至")
    private LocalDateTime shipmentDateE;
    /**
     * 采购订单ID
     */
    @ApiModelProperty("采购订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poId;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> suppIds;
    @ApiModelProperty("承运商ID")
    private Long carrierSuppId;
    /**
     * 供应商发货单号
     */
    @ApiModelProperty("供应商发货单号")
    private String suppDocNo;
    /**
     * 越库标识
     */
    @ApiModelProperty("越库标识")
    private Integer crosswhFlag;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;
    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 预计到货日期
     */
    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;
    /**
     * 发运联系人
     */
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;
    /**
     * 发运联系电话
     */
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;
    /**
     * 拒收原因
     */
    @ApiModelProperty("拒收原因")
    private String rejectReason;
    /**
     * 拒收时间
     */
    @ApiModelProperty("拒收时间")
    private LocalDateTime rejectTime;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> relateDocIds;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> relateIds;
    /**
     * 关联编号
     */
    @ApiModelProperty("关联编号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;

    @ApiModelProperty("收货地址")
    private String recvAddr;

    /**
     * 逻辑删除，0：无接口，1：有接口
     */
    @ApiModelProperty("逻辑删除，0：无接口，1：有接口")
    private Integer intfFlag;

    @ApiModelProperty("商品ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIds;
    @ApiModelProperty("商品ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<String> brands;

    @ApiModelProperty("发货批次")
    private String lotNo;

    @ApiModelProperty("收货人ID列表")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> recvEmpIds;
    @ApiModelProperty("配送日期起")
    private LocalDateTime deliveryDateStart;
    @ApiModelProperty("配送日期止")
    private LocalDateTime deliveryDateEnd;
    @ApiModelProperty("创建人id")
    private Long createUserId;
}
