package com.elitesland.yst.production.inv.application.facade.vo.carr;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单
 * @date 2021-09-19 11:20:59
 */
@Data
@ApiModel(value = "inv_carr", description = "承运商配送单")
public class InvCarrRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -4860614819571220789L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID(收货单位)")
    private Long ouId;
    private String ouCode;
    private String ouName;
    @ApiModelProperty("单据编号(配送单号)")
    private String docNo;
    @ApiModelProperty("单据状态 [UDC]INV:CARR_STATUS")
    @SysCode(sys = "yst-inv", mod = "CARR_STATUS")
    private String docStatus;
    @ApiModelProperty("单据状态名称")
    private String docStatusName;
    @ApiModelProperty("发货日期")
    private LocalDateTime shipmentDate;
    @ApiModelProperty("配送日期")
    private LocalDateTime deliveryDate;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID(发货单位)")
    private Long suppId;
    private String suppCode;
    private String suppName;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("承运商ID")
    private Long carrierSuppId;
    @ApiModelProperty("承运商编码")
    private String carrierSuppCode;
    @ApiModelProperty("承运商名称")
    private String carrierSuppName;
    @ApiModelProperty("供应商发货单号")
    private String suppDocNo;
    @ApiModelProperty("供应商送货单号")
    private String suppDocNo1;
    @ApiModelProperty("发运联系人")
    private String shipmentContactName;
    @ApiModelProperty("发运联系电话")
    private String shipmentContactTel;
    @ApiModelProperty("发运详细地址")
    private String shipmentDetailAddr;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("采购单id")
    private Long poId;
    @ApiModelProperty("收货地址")
    private String recvAddr;
    @ApiModelProperty("收货人名称")
    private String recvEmpName;
    @ApiModelProperty("收货人ID")
    private Long recvEmpId;
    @ApiModelProperty("收货联系电话")
    private String tel;
    @ApiModelProperty("收货地址")
    private String detailAddr;
    @ApiModelProperty("快递公司编号")
    @SysCode(sys = "yst-tms", mod = "PAAS_LOGISTICS_OU_CODE")
    private String logisticsOuCode;
    @ApiModelProperty("快递公司名称")
    private String logisticsOuCodeName;
    @ApiModelProperty("快递公司名称")
    private String logisticsOuName;
    @ApiModelProperty("物流单号")
    private String logisticsDocNo;
    @ApiModelProperty("车号")
    private String carNumber;
    @ApiModelProperty("司机")
    private String driver;
    @ApiModelProperty("司机电话")
    private String driverPhone;
    @ApiModelProperty("包装数量")
    private String packingQty;
    @ApiModelProperty("总重量")
    private String totalWeight;
    @ApiModelProperty("物流备注")
    private String logisticsRemark;
    @ApiModelProperty("承运商联系人")
    private String carrierContactName;
    @ApiModelProperty("承运商联系电话")
    private String carrierContactTel;
    @ApiModelProperty("配送单明细")
    private List<InvCarrDRespVO> invCarrDRespVOS;
    @ApiModelProperty("配送单附件")
    private List<InvCarrFileRespVO> invCarrFileRespVOS;
}
