package com.elitesland.yst.production.inv.application.facade.vo.despatch.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 04日 5:16 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "invDespatchConfigQueryParam", description = "分页查询条件")
public class InvDespatchConfigQueryParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -119762454035499838L;
    @ApiModelProperty("发货地编码")
    private String desCode;

    @ApiModelProperty("发货地名")
    private String desName;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("多字段查询关键字")
    String multiKeywords;

    @ApiModelProperty("发货地编码")
    private List<String> desCodes;

    @ApiModelProperty("功能区关键字查询")
    private String deter2KeyWord;

    @ApiModelProperty("所属公司")
    private String deter1;
    @ApiModelProperty("所属公司集合")
    private List<String> deter1List;

    /*@ApiModelProperty("所属公司关键字查询")
    private String deter1KeyWord;*/

    @ApiModelProperty(value = "贸易公司白名单标识")
    private Boolean tradeCompanyFlag;

    @ApiModelProperty("启用状态")
    private String isEnable;
}
