package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.alibaba.excel.annotation.format.NumberFormat;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(value="inv_search_detailed",description = "库存帐卡查询")
public class InvIoStkAcctRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -7884857722686737416L;

    @ApiModelProperty("ioId")
    @JsonSerialize(using = ToStringSerializer.class)
    Long id;

    @ApiModelProperty("stkId")
    @JsonSerialize(using = ToStringSerializer.class)
    Long stkId;

    @ApiModelProperty("批次号")
    String lotNo;

    @ApiModelProperty("场景码")
    String sceneCode;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("品项id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("品项代码")
    String itemCode;

    @ApiModelProperty("品类")
    String itemCateCode;

    @ApiModelProperty("品类名")
    String itemCateCodeName;

    @ApiModelProperty("共享类型")
    String shareType;

    @ApiModelProperty("品项名")
    String itemName;

    @ApiModelProperty("原因码")
    @SysCode(sys = "COM", mod = "REASON_CODE")
    String reasonCode;
    String reasonCodeName;

    @ApiModelProperty("箱系数")
    Float en1;

    @ApiModelProperty("包装规格")
    String packageSpec;

    @ApiModelProperty("仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("温层名称")
    String deter1Name;

    @ApiModelProperty("功能区")
    String deter2;

    @ApiModelProperty("功能区名称")
    String deter2Name;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("业务单据类型 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    String srcDocCls;

    @ApiModelProperty("业务单据类型名称")
    String srcDocClsName;

    @ApiModelProperty("单据编号")
    String srcDocNo;

    @ApiModelProperty("单据编号2")
    String srcDocNo2;

    @ApiModelProperty("交易数量")
    @NumberFormat(value = "#,###.##")
    BigDecimal qty;

    @ApiModelProperty("共享参数配置")
    BigDecimal shareSetting;

    @ApiModelProperty("共享剩余数量")
    BigDecimal sharedQty;

    @ApiModelProperty("共享数量配置天数")
    BigDecimal shareDay;

    @ApiModelProperty("库存存在天数")
    Integer sharedDay;


    @ApiModelProperty("箱装数")
    Integer pkgQty;

    @ApiModelProperty("单位 [UDC]COM:UOM")
    String uom;

    @ApiModelProperty("单位名称")
    String uomName;

    @ApiModelProperty("交易日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    LocalDateTime ioDate;

    @ApiModelProperty("公司id")//翻译
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;

    @ApiModelProperty("公司代码")
    String ouCode;

    @ApiModelProperty("公司名")
    String ouName;

    @ApiModelProperty("业务类型【UDC】INV:BUSI_TYPE")
    String ioCode;

    @ApiModelProperty("业务类型名称")
    String ioCodeName;

    @ApiModelProperty("操作类型")
    String ioName;

    @ApiModelProperty("业务单据编号（暂时使用）")
    String srcCode;

    @ApiModelProperty(" 交易时间（暂时使用）")
    String srcDate;

    @ApiModelProperty("条码（暂时使用）")
    String barCode;

    @ApiModelProperty("保质期天数（暂时使用）")
    Integer expireDays;

    @ApiModelProperty(value = "品牌编码（暂时使用）")
    String brand;

    @ApiModelProperty(value = "品牌名称（暂时使用）")
    String brandName;

    @ApiModelProperty(value ="库存编码（暂时使用）")
    String whCode;

    @ApiModelProperty(value ="库存名称（暂时使用）")
    String whName;

    @ApiModelProperty("合作伙伴类型")
    @SysCode(sys = "yst-inv",mod = "PARTNER_TYPE")
    private String pType;

    private String pTypeName;

    @ApiModelProperty("合作伙伴编码")
    private String pCode;

    @ApiModelProperty("合作伙伴名称")
    private String pName;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

}
