package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 在库商品查询
 * </p>
 *
 * @author jeesie.jiang
 * @date 2021/6/28
 */
@Data
@ApiModel(value = "ItmInvStkItemRespVO", description = "在库商品查询")
public class ItmInvStkItemRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 1729391895274562938L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    private String ouCode;
    private String ouName;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;


    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("商品类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名称（暂时使用）")
    private String deter2Name;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("在库类型")
    private String limit2;

    @ApiModelProperty("客户编码")
    private String limit1;






}
