package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 共享仓库存查询返回实体类
 * </p>
 *
 * @author jeesie.jiang
 * @date 2021/9/26
 */
@Data
@ApiModel(value = "ItmInvStkShareRespVO", description = "共享仓库存查询返回实体类")
public class ItmInvStkShareRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 37414380636180276L;
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("共享类型")
    private String shareType;
    @SysCode(sys = "yst-inv", mod = "SHARE_TYPE")
    private String shareTypeName;

    @ApiModelProperty("共享类型配置参数")
    private BigDecimal shareSetting;


    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("品类")
    private String itemCateCode;

    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    private String uom;
    @SysCode(sys = "COM",mod = "UOM")
    private String uomName;

    @ApiModelProperty("商品类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("共享数量")
    private BigDecimal qty;

    @ApiModelProperty("库存可用数量")
    private BigDecimal avalQty;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("仓库类型")
    private String whTypeName;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    @SysCode(sys = "yst-inv",mod = "FUNC_TYPE")
    private String deter2Name;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("库存合作类型")
    private String pType;

    @ApiModelProperty("商品批次")
    private String lotNo;

    @ApiModelProperty("库存合作合作伙伴名称")
    private String pName;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    @ApiModelProperty("税率(进项)")
    private BigDecimal taxRate;

    @ApiModelProperty("税码(进项)")
    private String taxCode;














}
