package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-05-28 14:00:47
 */
@Data
@ApiModel(value = "inv_wh_delivery", description = "仓库配送范围")
public class InvWhDeliveryParamVO extends AbstractOrderQueryParam {
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("省编码")
    private String pCode;


    @ApiModelProperty("市编码")
    private String cCode;

    /**
     * aCode
     */
    @ApiModelProperty("区（县）编码")
    private String aCode;

    /**
     * sCode
     */
    @ApiModelProperty("乡编码")
    private String sCode;

}
